/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaBreakpointListener;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;

public class SuspendOnUncaughtExceptionListener
implements IJavaBreakpointListener {
    public static final String ID_UNCAUGHT_EXCEPTION_LISTENER = JDIDebugUIPlugin.getUniqueIdentifier() + ".uncaughtExceptionListener";

    public void addingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public void breakpointHasCompilationErrors(IJavaLineBreakpoint breakpoint, Message[] errors) {
    }

    public void breakpointHasRuntimeException(IJavaLineBreakpoint breakpoint, DebugException exception) {
    }

    public int breakpointHit(IJavaThread thread, IJavaBreakpoint breakpoint) {
        if (!JavaDebugOptionsManager.getDefault().isSuspendOnCompilationErrors()) {
            try {
                IJavaStackFrame frame = (IJavaStackFrame)thread.getTopStackFrame();
                if (frame != null && JavaDebugOptionsManager.getDefault().getProblem(frame) != null) {
                    return 2;
                }
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return 1;
    }

    public void breakpointInstalled(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public int installingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint, IJavaType type) {
        return 4;
    }
}

