/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Collections;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.ProgramBlock;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;

public class JUnitProgramBlock
extends ProgramBlock {
    public JUnitProgramBlock(AbstractLauncherTab tab) {
        super(tab);
    }

    @Override
    protected String getApplicationAttribute() {
        return "testApplication";
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        if (!LauncherUtils.requiresUI((ILaunchConfiguration)config)) {
            config.setAttribute("application", "org.eclipse.pde.junit.runtime.coretestapplication");
        } else {
            super.setDefaults(config);
        }
    }

    @Override
    protected String[] getApplicationNames() {
        TreeSet<String> result = new TreeSet<String>();
        result.add(PDEUIMessages.JUnitProgramBlock_headless);
        String[] appNames = super.getApplicationNames();
        Collections.addAll(result, appNames);
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected void initializeApplicationSection(ILaunchConfiguration config) throws CoreException {
        String application = config.getAttribute("application", null);
        if ("org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
            this.fApplicationCombo.setText(PDEUIMessages.JUnitProgramBlock_headless);
        } else {
            super.initializeApplicationSection(config);
        }
    }

    @Override
    protected void saveApplicationSection(ILaunchConfigurationWorkingCopy config) {
        if (this.fApplicationCombo.getText().equals(PDEUIMessages.JUnitProgramBlock_headless)) {
            String appName = this.fApplicationCombo.isEnabled() ? "org.eclipse.pde.junit.runtime.coretestapplication" : null;
            config.setAttribute("application", appName);
            config.setAttribute("testApplication", null);
        } else {
            config.setAttribute("application", null);
            super.saveApplicationSection(config);
        }
    }
}

