/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.hierarchy;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ITypeHierarchyBuilder;
import org.eclipse.dltk.utils.NatureExtensionManager;

public class TypeHierarchyBuilders
extends NatureExtensionManager<ITypeHierarchyBuilder> {
    private static TypeHierarchyBuilders INSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TypeHierarchyBuilders get() {
        if (INSTANCE != null) return INSTANCE;
        Class<TypeHierarchyBuilders> clazz = TypeHierarchyBuilders.class;
        synchronized (TypeHierarchyBuilders.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new TypeHierarchyBuilders();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public TypeHierarchyBuilders() {
        super("org.eclipse.dltk.core.typeHierarchy", ITypeHierarchyBuilder.class);
    }

    public static ITypeHierarchy getTypeHierarchy(IType type, ITypeHierarchy.Mode mode, IProgressMonitor monitor) {
        ITypeHierarchyBuilder[] builders;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(type);
        if (toolkit != null && (builders = (ITypeHierarchyBuilder[])TypeHierarchyBuilders.get().getInstances(toolkit.getNatureId())) != null) {
            ITypeHierarchyBuilder[] iTypeHierarchyBuilderArray = builders;
            int n = builders.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeHierarchyBuilder builder = iTypeHierarchyBuilderArray[n2];
                ITypeHierarchy hierarchy = builder.build(type, mode, monitor);
                if (hierarchy != null) {
                    return hierarchy;
                }
                ++n2;
            }
        }
        return null;
    }
}

