/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.connector.ssh.launcher;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.connector.InMemorySettingsStore;
import org.eclipse.terminal.connector.TerminalConnectorExtension;
import org.eclipse.terminal.connector.ssh.connector.SshSettings;
import org.eclipse.terminal.connector.ssh.controls.SshWizardConfigurationPanel;
import org.eclipse.terminal.connector.ssh.launcher.SshMementoHandler;
import org.eclipse.terminal.connector.ssh.nls.Messages;
import org.eclipse.terminal.view.ui.IMementoHandler;
import org.eclipse.terminal.view.ui.launcher.AbstractLauncherDelegate;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanel;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanelContainer;

public class SshLauncherDelegate
extends AbstractLauncherDelegate {
    private final IMementoHandler mementoHandler = new SshMementoHandler();

    public boolean needsUserConfiguration() {
        return true;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new SshWizardConfigurationPanel(container);
    }

    public CompletableFuture<?> execute(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String terminalTitle = this.getTerminalTitle(properties);
        if (terminalTitle != null) {
            properties.put("title", terminalTitle);
        }
        if (!properties.containsKey("terminal.forceNew")) {
            properties.put("terminal.forceNew", Boolean.TRUE);
        }
        try {
            return this.getTerminalService().openConsole(properties);
        }
        catch (RuntimeException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private String getTerminalTitle(Map<String, Object> properties) {
        String port;
        String title = this.getDefaultTerminalTitle(properties);
        if (title != null) {
            return title;
        }
        String host = (String)properties.get("ip.host");
        String user = (String)properties.get("ssh.user");
        Object value = properties.get("ip.port");
        String string = port = value != null ? value.toString() : null;
        if (host != null && user != null) {
            DateFormat format = DateFormat.getDateTimeInstance(3, 3);
            String date = format.format(new Date(System.currentTimeMillis()));
            if (port != null && Integer.valueOf(port) != 22) {
                return NLS.bind((String)Messages.SshLauncherDelegate_terminalTitle_port, (Object[])new String[]{user, host, port, date});
            }
            return NLS.bind((String)Messages.SshLauncherDelegate_terminalTitle, (Object[])new String[]{user, host, date});
        }
        return Messages.SshLauncherDelegate_terminalTitle_default;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IMementoHandler.class.equals(adapter)) {
            return adapter.cast(this.mementoHandler);
        }
        return (T)super.getAdapter(adapter);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) throws CoreException {
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.terminal.connector.ssh.SshConnector";
        }
        String host = (String)properties.get("ip.host");
        Object value = properties.get("ip.port");
        String port = value != null ? value.toString() : null;
        value = properties.get("timeout");
        String timeout = value != null ? value.toString() : null;
        value = properties.get("ssh.keep_alive");
        String keepAlive = value != null ? value.toString() : null;
        String password = (String)properties.get("ssh.password");
        String user = (String)properties.get("ssh.user");
        int portOffset = 0;
        if (properties.get("ip.port.offset") instanceof Integer && (portOffset = ((Integer)properties.get("ip.port.offset")).intValue()) < 0) {
            portOffset = 0;
        }
        if (port != null) {
            port = Integer.toString(Integer.decode(port) + portOffset);
        }
        InMemorySettingsStore store = new InMemorySettingsStore();
        SshSettings sshSettings = new SshSettings();
        sshSettings.setHost(host);
        sshSettings.setPort(port);
        sshSettings.setTimeout(timeout);
        sshSettings.setKeepalive(keepAlive);
        sshSettings.setPassword(password);
        sshSettings.setUser(user);
        sshSettings.save((ISettingsStore)store);
        store.put("Password", password);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        connector.setDefaultSettings();
        connector.load((ISettingsStore)store);
        return connector;
    }
}

