/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class FloatNumberRule
implements IRule {
    private final IToken fToken;
    private final String fDigitSeparators;
    private final String fDecimalSuffixes;
    private final String fFloatSuffixes;

    public FloatNumberRule(IToken token) {
        this(token, null, null, null);
    }

    public FloatNumberRule(IToken token, String digitSeparators, String integerSuffixes, String floatSuffixes) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
        this.fDigitSeparators = digitSeparators;
        this.fDecimalSuffixes = integerSuffixes;
        this.fFloatSuffixes = floatSuffixes;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (Character.isDigit((char)c) || c == 46) {
            int digitCount;
            Mode mode;
            int readCount = 1;
            if (c == 46) {
                mode = Mode.FLOAT;
                digitCount = 0;
            } else {
                mode = Mode.DECIMAL;
                digitCount = 1;
            }
            while (true) {
                char lastDigit = (char)c;
                c = scanner.read();
                ++readCount;
                if (c == 120 || c == 88) {
                    if (mode == Mode.DECIMAL && digitCount == 1 && lastDigit == '0') {
                        mode = Mode.HEX;
                        digitCount = 0;
                        continue;
                    }
                    this.unread(scanner, readCount);
                    return Token.UNDEFINED;
                }
                if (Character.isDigit((char)c) || this.isSeparator(c) || mode == Mode.HEX && (c >= 65 && c <= 70 || c >= 97 && c <= 102)) {
                    ++digitCount;
                    continue;
                }
                if (c != 46 || mode != Mode.DECIMAL) break;
                mode = Mode.FLOAT;
            }
            if (digitCount == 0) {
                this.unread(scanner, readCount);
                return Token.UNDEFINED;
            }
            if (!(c != 101 && c != 69 || mode != Mode.DECIMAL && mode != Mode.FLOAT)) {
                mode = Mode.FLOAT;
                c = scanner.read();
                ++readCount;
                if (c == 43 || c == 45) {
                    c = scanner.read();
                    ++readCount;
                }
                if (Character.isDigit((char)c)) {
                    do {
                        ++readCount;
                    } while (Character.isDigit((char)(c = scanner.read())) || this.isSeparator(c));
                } else {
                    this.unread(scanner, readCount);
                    return Token.UNDEFINED;
                }
            }
            if (!((mode == Mode.DECIMAL || mode == Mode.FLOAT) && this.isFloatSuffix(c) || mode == Mode.DECIMAL && this.isDecimalSuffix(c))) {
                scanner.unread();
            }
            return this.fToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private final void unread(ICharacterScanner scanner, int count) {
        while (--count >= 0) {
            scanner.unread();
        }
    }

    private final boolean isSeparator(int c) {
        return this.fDigitSeparators != null && this.fDigitSeparators.indexOf(c) >= 0;
    }

    private final boolean isDecimalSuffix(int c) {
        return this.fDecimalSuffixes != null && this.fDecimalSuffixes.indexOf(c) >= 0;
    }

    private final boolean isFloatSuffix(int c) {
        return this.fFloatSuffixes != null && this.fFloatSuffixes.indexOf(c) >= 0;
    }

    private static enum Mode {
        DECIMAL,
        HEX,
        FLOAT;

    }
}

