<?php

// Start of openssl v.7.4.0

/**
 * Retrieve the available certificate locations
 * @link http://www.php.net/manual/en/function.openssl-get-cert-locations.php
 * @return array an array with the available certificate locations.
 */
function openssl_get_cert_locations () {}

/**
 * Generate a new signed public key and challenge
 * @link http://www.php.net/manual/en/function.openssl-spki-new.php
 * @param resource $privkey privkey should be set to a private key that was
 * previously generated by openssl_pkey_new (or
 * otherwise obtained from the other openssl_pkey family of functions).
 * The corresponding public portion of the key will be used to sign the
 * CSR.
 * @param string $challenge The challenge associated to associate with the SPKAC
 * @param int $algorithm [optional] The digest algorithm. See openssl_get_md_method().
 * @return string a signed public key and challenge string or NULL on failure.
 */
function openssl_spki_new (&$privkey, string &$challenge, int $algorithm = null) {}

/**
 * Verifies a signed public key and challenge
 * @link http://www.php.net/manual/en/function.openssl-spki-verify.php
 * @param string $spkac Expects a valid signed public key and challenge
 * @return string a boolean on success or failure.
 */
function openssl_spki_verify (string &$spkac) {}

/**
 * Exports a valid PEM formatted public key signed public key and challenge
 * @link http://www.php.net/manual/en/function.openssl-spki-export.php
 * @param string $spkac Expects a valid signed public key and challenge
 * @return string the associated PEM formatted public key or NULL on failure.
 */
function openssl_spki_export (string &$spkac) {}

/**
 * Exports the challenge assoicated with a signed public key and challenge
 * @link http://www.php.net/manual/en/function.openssl-spki-export-challenge.php
 * @param string $spkac Expects a valid signed public key and challenge
 * @return string the associated challenge string or NULL on failure.
 */
function openssl_spki_export_challenge (string &$spkac) {}

/**
 * Frees a private key
 * @link http://www.php.net/manual/en/function.openssl-pkey-free.php
 * @param resource $key Resource holding the key.
 * @return void 
 */
function openssl_pkey_free ($key) {}

/**
 * Generates a new private key
 * @link http://www.php.net/manual/en/function.openssl-pkey-new.php
 * @param array $configargs [optional] You can finetune the key generation (such as specifying the number of
 * bits) using configargs. See
 * openssl_csr_new for more information about
 * configargs.
 * @return resource a resource identifier for the pkey on success, or false on
 * error.
 */
function openssl_pkey_new (array $configargs = null) {}

/**
 * Gets an exportable representation of a key into a string
 * @link http://www.php.net/manual/en/function.openssl-pkey-export.php
 * @param mixed $key 
 * @param string $out 
 * @param string $passphrase [optional] The key is optionally protected by passphrase.
 * @param array $configargs [optional] configargs can be used to fine-tune the export
 * process by specifying and/or overriding options for the openssl
 * configuration file. See openssl_csr_new for more
 * information about configargs.
 * @return bool true on success or false on failure
 */
function openssl_pkey_export ($key, string &$out, string $passphrase = null, array $configargs = null) {}

/**
 * Gets an exportable representation of a key into a file
 * @link http://www.php.net/manual/en/function.openssl-pkey-export-to-file.php
 * @param mixed $key 
 * @param string $outfilename Path to the output file.
 * @param string $passphrase [optional] The key can be optionally protected by a
 * passphrase.
 * @param array $configargs [optional] configargs can be used to fine-tune the export
 * process by specifying and/or overriding options for the openssl
 * configuration file. See openssl_csr_new for more
 * information about configargs.
 * @return bool true on success or false on failure
 */
function openssl_pkey_export_to_file ($key, string $outfilename, string $passphrase = null, array $configargs = null) {}

/**
 * Get a private key
 * @link http://www.php.net/manual/en/function.openssl-pkey-get-private.php
 * @param mixed $key <p>
 * key can be one of the following:
 * <p>
 * <br>a string having the format
 * file://path/to/file.pem. The named file must
 * contain a PEM encoded certificate/private key (it may contain both).
 * <br>A PEM formatted private key.
 * </p>
 * </p>
 * @param string $passphrase [optional] The optional parameter passphrase must be used
 * if the specified key is encrypted (protected by a passphrase).
 * @return resource a positive key resource identifier on success, or false on error.
 */
function openssl_pkey_get_private ($key, string $passphrase = null) {}

/**
 * Extract public key from certificate and prepare it for use
 * @link http://www.php.net/manual/en/function.openssl-pkey-get-public.php
 * @param mixed $certificate <p>
 * certificate can be one of the following:
 * <p>
 * <br>an X.509 certificate resource
 * <br>a string having the format
 * file://path/to/file.pem. The named file must
 * contain a PEM encoded certificate/public key (it may contain both).
 * <br>A PEM formatted public key.
 * </p>
 * </p>
 * @return resource a positive key resource identifier on success, or false on error.
 */
function openssl_pkey_get_public ($certificate) {}

/**
 * Returns an array with the key details
 * @link http://www.php.net/manual/en/function.openssl-pkey-get-details.php
 * @param resource $key Resource holding the key.
 * @return array an array with the key details in success or false in failure.
 * Returned array has indexes bits (number of bits),
 * key (string representation of the public key) and
 * type (type of the key which is one of
 * OPENSSL_KEYTYPE_RSA,
 * OPENSSL_KEYTYPE_DSA,
 * OPENSSL_KEYTYPE_DH,
 * OPENSSL_KEYTYPE_EC or -1 meaning unknown).
 * <p>
 * Depending on the key type used, additional details may be returned. Note that 
 * some elements may not always be available.
 * </p>
 */
function openssl_pkey_get_details ($key) {}

/**
 * Free key resource
 * @link http://www.php.net/manual/en/function.openssl-free-key.php
 * @param resource $key_identifier 
 * @return void 
 */
function openssl_free_key ($key_identifier) {}

/**
 * Alias: openssl_pkey_get_private
 * @link http://www.php.net/manual/en/function.openssl-get-privatekey.php
 * @param mixed $key
 * @param mixed $passphrase [optional]
 */
function openssl_get_privatekey ($key, $passphrase = null) {}

/**
 * Alias: openssl_pkey_get_public
 * @link http://www.php.net/manual/en/function.openssl-get-publickey.php
 * @param mixed $cert
 */
function openssl_get_publickey ($cert) {}

/**
 * Parse an X.509 certificate and return a resource identifier for
 * it
 * @link http://www.php.net/manual/en/function.openssl-x509-read.php
 * @param mixed $x509certdata X509 certificate. See Key/Certificate parameters for a list of valid values.
 * @return resource a resource identifier on success or false on failure.
 */
function openssl_x509_read ($x509certdata) {}

/**
 * Free certificate resource
 * @link http://www.php.net/manual/en/function.openssl-x509-free.php
 * @param resource $x509cert 
 * @return void 
 */
function openssl_x509_free ($x509cert) {}

/**
 * Parse an X509 certificate and return the information as an array
 * @link http://www.php.net/manual/en/function.openssl-x509-parse.php
 * @param mixed $x509cert 
 * @param bool $shortnames [optional] shortnames controls how the data is indexed in the
 * array - if shortnames is true (the default) then
 * fields will be indexed with the short name form, otherwise, the long name
 * form will be used - e.g.: CN is the shortname form of commonName.
 * @return array The structure of the returned data is (deliberately) not
 * yet documented, as it is still subject to change.
 */
function openssl_x509_parse ($x509cert, bool $shortnames = null) {}

/**
 * Verifies if a certificate can be used for a particular purpose
 * @link http://www.php.net/manual/en/function.openssl-x509-checkpurpose.php
 * @param mixed $x509cert The examined certificate.
 * @param int $purpose <table>
 * openssl_x509_checkpurpose purposes
 * <table>
 * <tr valign="top">
 * <td>Constant</td>
 * <td>Description</td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_SSL_CLIENT</td>
 * <td>Can the certificate be used for the client side of an SSL
 * connection?</td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_SSL_SERVER</td>
 * <td>Can the certificate be used for the server side of an SSL
 * connection?</td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_NS_SSL_SERVER</td>
 * <td>Can the cert be used for Netscape SSL server?</td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_SMIME_SIGN</td>
 * <td>Can the cert be used to sign S/MIME email?</td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_SMIME_ENCRYPT</td>
 * <td>Can the cert be used to encrypt S/MIME email?</td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_CRL_SIGN</td>
 * <td>Can the cert be used to sign a certificate revocation list
 * (CRL)?</td>
 * </tr>
 * <tr valign="top">
 * <td>X509_PURPOSE_ANY</td>
 * <td>Can the cert be used for Any/All purposes?</td>
 * </tr>
 * </table>
 * </table>
 * These options are not bitfields - you may specify one only!
 * @param array $cainfo [optional] cainfo should be an array of trusted CA files/dirs
 * as described in Certificate
 * Verification.
 * @param string $untrustedfile [optional] If specified, this should be the name of a PEM encoded file holding
 * certificates that can be used to help verify the certificate, although
 * no trust is placed in the certificates that come from that file.
 * @return int true if the certificate can be used for the intended purpose,
 * false if it cannot, or -1 on error.
 */
function openssl_x509_checkpurpose ($x509cert, int $purpose, array $cainfo = null, string $untrustedfile = null) {}

/**
 * Checks if a private key corresponds to a certificate
 * @link http://www.php.net/manual/en/function.openssl-x509-check-private-key.php
 * @param mixed $cert The certificate.
 * @param mixed $key The private key.
 * @return bool true if key is the private key that
 * corresponds to cert, or false otherwise.
 */
function openssl_x509_check_private_key ($cert, $key) {}

/**
 * @param mixed $cert
 * @param mixed $key
 */
function openssl_x509_verify ($cert, $key) {}

/**
 * Exports a certificate as a string
 * @link http://www.php.net/manual/en/function.openssl-x509-export.php
 * @param mixed $x509 
 * @param string $output On success, this will hold the PEM.
 * @param bool $notext [optional] note.openssl.param-notext
 * @return bool true on success or false on failure
 */
function openssl_x509_export ($x509, string &$output, bool $notext = null) {}

/**
 * Calculates the fingerprint, or digest, of a given X.509 certificate
 * @link http://www.php.net/manual/en/function.openssl-x509-fingerprint.php
 * @param mixed $x509 
 * @param string $hash_algorithm [optional] The digest method or hash algorithm to use, e.g. "sha256", one of openssl_get_md_methods.
 * @param bool $raw_output [optional] When set to true, outputs raw binary data. false outputs lowercase hexits.
 * @return string a string containing the calculated certificate fingerprint as lowercase hexits unless raw_output is set to true in which case the raw binary representation of the message digest is returned.
 * <p>
 * Returns false on failure.
 * </p>
 */
function openssl_x509_fingerprint ($x509, string $hash_algorithm = null, bool $raw_output = null) {}

/**
 * Exports a certificate to file
 * @link http://www.php.net/manual/en/function.openssl-x509-export-to-file.php
 * @param mixed $x509 
 * @param string $outfilename Path to the output file.
 * @param bool $notext [optional] note.openssl.param-notext
 * @return bool true on success or false on failure
 */
function openssl_x509_export_to_file ($x509, string $outfilename, bool $notext = null) {}

/**
 * Exports a PKCS#12 Compatible Certificate Store File to variable
 * @link http://www.php.net/manual/en/function.openssl-pkcs12-export.php
 * @param mixed $x509 
 * @param string $out On success, this will hold the PKCS#12.
 * @param mixed $priv_key Private key component of PKCS#12 file.
 * See Public/Private Key parameters for a list of valid values.
 * @param string $pass Encryption password for unlocking the PKCS#12 file.
 * @param array $args [optional] Optional array, other keys will be ignored.
 * <table>
 * <tr valign="top">
 * <td>Key</td>
 * <td>Description</td>
 * </tr>
 * <tr valign="top">
 * <td>"extracerts"</td>
 * <td>array of extra certificates or a single certificate to be included in the PKCS#12 file.</td>
 * </tr>
 * <tr valign="top">
 * <td>"friendlyname"</td>
 * <td>string to be used for the supplied certificate and key</td>
 * </tr>
 * </table>
 * @return bool true on success or false on failure
 */
function openssl_pkcs12_export ($x509, string &$out, $priv_key, string $pass, array $args = null) {}

/**
 * Exports a PKCS#12 Compatible Certificate Store File
 * @link http://www.php.net/manual/en/function.openssl-pkcs12-export-to-file.php
 * @param mixed $x509 
 * @param string $filename Path to the output file.
 * @param mixed $priv_key Private key component of PKCS#12 file.
 * See Public/Private Key parameters for a list of valid values.
 * @param string $pass Encryption password for unlocking the PKCS#12 file.
 * @param array $args [optional] Optional array, other keys will be ignored.
 * <table>
 * <tr valign="top">
 * <td>Key</td>
 * <td>Description</td>
 * </tr>
 * <tr valign="top">
 * <td>"extracerts"</td>
 * <td>array of extra certificates or a single certificate to be included in the PKCS#12 file.</td>
 * </tr>
 * <tr valign="top">
 * <td>"friendlyname"</td>
 * <td>string to be used for the supplied certificate and key</td>
 * </tr>
 * </table>
 * @return bool true on success or false on failure
 */
function openssl_pkcs12_export_to_file ($x509, string $filename, $priv_key, string $pass, array $args = null) {}

/**
 * Parse a PKCS#12 Certificate Store into an array
 * @link http://www.php.net/manual/en/function.openssl-pkcs12-read.php
 * @param string $pkcs12 The certificate store contents, not its file name.
 * @param array $certs On success, this will hold the Certificate Store Data.
 * @param string $pass Encryption password for unlocking the PKCS#12 file.
 * @return bool true on success or false on failure
 */
function openssl_pkcs12_read (string $pkcs12, array &$certs, string $pass) {}

/**
 * Generates a CSR
 * @link http://www.php.net/manual/en/function.openssl-csr-new.php
 * @param array $dn The Distinguished Name or subject fields to be used in the certificate.
 * @param resource $privkey privkey should be set to a private key that was
 * previously generated by openssl_pkey_new (or
 * otherwise obtained from the other openssl_pkey family of functions).
 * The corresponding public portion of the key will be used to sign the
 * CSR.
 * @param array $configargs [optional] By default, the information in your system openssl.conf
 * is used to initialize the request; you can specify a configuration file
 * section by setting the config_section_section key of
 * configargs. You can also specify an alternative
 * openssl configuration file by setting the value of the
 * config key to the path of the file you want to use.
 * The following keys, if present in configargs
 * behave as their equivalents in the openssl.conf, as
 * listed in the table below.
 * <table>
 * Configuration overrides
 * <table>
 * <tr valign="top">
 * <td>configargs key</td>
 * <td>type</td>
 * <td>openssl.conf equivalent</td>
 * <td>description</td>
 * </tr>
 * <tr valign="top">
 * <td>digest_alg</td>
 * <td>string</td>
 * <td>default_md</td>
 * <td>Digest method or signature hash, usually one of openssl_get_md_methods</td>
 * </tr>
 * <tr valign="top">
 * <td>x509_extensions</td>
 * <td>string</td>
 * <td>x509_extensions</td>
 * <td>Selects which extensions should be used when creating an x509
 * certificate</td>
 * </tr>
 * <tr valign="top">
 * <td>req_extensions</td>
 * <td>string</td>
 * <td>req_extensions</td>
 * <td>Selects which extensions should be used when creating a CSR</td>
 * </tr>
 * <tr valign="top">
 * <td>private_key_bits</td>
 * <td>integer</td>
 * <td>default_bits</td>
 * <td>Specifies how many bits should be used to generate a private
 * key</td>
 * </tr>
 * <tr valign="top">
 * <td>private_key_type</td>
 * <td>integer</td>
 * <td>none</td>
 * <td>Specifies the type of private key to create. This can be one
 * of OPENSSL_KEYTYPE_DSA,
 * OPENSSL_KEYTYPE_DH,
 * OPENSSL_KEYTYPE_RSA or
 * OPENSSL_KEYTYPE_EC.
 * The default value is OPENSSL_KEYTYPE_RSA.
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>encrypt_key</td>
 * <td>boolean</td>
 * <td>encrypt_key</td>
 * <td>Should an exported key (with passphrase) be encrypted?</td>
 * </tr>
 * <tr valign="top">
 * <td>encrypt_key_cipher</td>
 * <td>integer</td>
 * <td>none</td>
 * <td>
 * One of cipher constants.
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>curve_name</td>
 * <td>string</td>
 * <td>none</td>
 * <td>
 * One of openssl_get_curve_names.
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>config</td>
 * <td>string</td>
 * <td>N/A</td>
 * <td>
 * Path to your own alternative openssl.conf file.
 * </td>
 * </tr>
 * </table>
 * </table>
 * @param array $extraattribs [optional] extraattribs is used to specify additional
 * configuration options for the CSR. Both dn and
 * extraattribs are associative arrays whose keys are
 * converted to OIDs and applied to the relevant part of the request.
 * @return mixed the CSR or false on failure.
 */
function openssl_csr_new (array $dn, &$privkey, array $configargs = null, array $extraattribs = null) {}

/**
 * Exports a CSR as a string
 * @link http://www.php.net/manual/en/function.openssl-csr-export.php
 * @param mixed $csr 
 * @param string $out on success, this string will contain the PEM encoded CSR
 * @param bool $notext [optional] note.openssl.param-notext
 * @return bool true on success or false on failure
 */
function openssl_csr_export ($csr, string &$out, bool $notext = null) {}

/**
 * Exports a CSR to a file
 * @link http://www.php.net/manual/en/function.openssl-csr-export-to-file.php
 * @param mixed $csr 
 * @param string $outfilename Path to the output file.
 * @param bool $notext [optional] note.openssl.param-notext
 * @return bool true on success or false on failure
 */
function openssl_csr_export_to_file ($csr, string $outfilename, bool $notext = null) {}

/**
 * Sign a CSR with another certificate (or itself) and generate a certificate
 * @link http://www.php.net/manual/en/function.openssl-csr-sign.php
 * @param mixed $csr A CSR previously generated by openssl_csr_new.
 * It can also be the path to a PEM encoded CSR when specified as
 * file://path/to/csr or an exported string generated
 * by openssl_csr_export.
 * @param mixed $cacert The generated certificate will be signed by cacert.
 * If cacert is null, the generated certificate
 * will be a self-signed certificate.
 * @param mixed $priv_key priv_key is the private key that corresponds to
 * cacert.
 * @param int $days days specifies the length of time for which the
 * generated certificate will be valid, in days.
 * @param array $configargs [optional] You can finetune the CSR signing by configargs.
 * See openssl_csr_new for more information about
 * configargs.
 * @param int $serial [optional] An optional the serial number of issued certificate. If not specified
 * it will default to 0.
 * @return resource an x509 certificate resource on success, false on failure.
 */
function openssl_csr_sign ($csr, $cacert, $priv_key, int $days, array $configargs = null, int $serial = null) {}

/**
 * Returns the subject of a CSR
 * @link http://www.php.net/manual/en/function.openssl-csr-get-subject.php
 * @param mixed $csr 
 * @param bool $use_shortnames [optional] shortnames controls how the data is indexed in the
 * array - if shortnames is true (the default) then
 * fields will be indexed with the short name form, otherwise, the long name
 * form will be used - e.g.: CN is the shortname form of commonName.
 * @return array true on success or false on failure
 */
function openssl_csr_get_subject ($csr, bool $use_shortnames = null) {}

/**
 * Returns the public key of a CSR
 * @link http://www.php.net/manual/en/function.openssl-csr-get-public-key.php
 * @param mixed $csr 
 * @param bool $use_shortnames [optional] This parameter is ignored
 * @return resource a positive key resource identifier on success, or FALSE on error.
 */
function openssl_csr_get_public_key ($csr, bool $use_shortnames = null) {}

/**
 * Computes a digest
 * @link http://www.php.net/manual/en/function.openssl-digest.php
 * @param string $data The data.
 * @param string $method The digest method to use, e.g. "sha256", see openssl_get_md_methods for a list of available digest methods.
 * @param bool $raw_output [optional] Setting to true will return as raw output data, otherwise the return
 * value is binhex encoded.
 * @return string the digested hash value on success or false on failure.
 */
function openssl_digest (string $data, string $method, bool $raw_output = null) {}

/**
 * Encrypts data
 * @link http://www.php.net/manual/en/function.openssl-encrypt.php
 * @param string $data The plaintext message data to be encrypted.
 * @param string $method The cipher method. For a list of available cipher methods, use openssl_get_cipher_methods.
 * @param string $key The key.
 * @param int $options [optional] options is a bitwise disjunction of the flags
 * OPENSSL_RAW_DATA and
 * OPENSSL_ZERO_PADDING.
 * @param string $iv [optional] A non-NULL Initialization Vector.
 * @param string $tag [optional] The authentication tag passed by reference when using AEAD cipher mode (GCM or CCM).
 * @param string $aad [optional] Additional authentication data.
 * @param int $tag_length [optional] The length of the authentication tag. Its value can be between 4 and 16 for GCM mode.
 * @return string the encrypted string on success or false on failure.
 */
function openssl_encrypt (string $data, string $method, string $key, int $options = null, string $iv = null, string &$tag = null, string $aad = null, int $tag_length = null) {}

/**
 * Decrypts data
 * @link http://www.php.net/manual/en/function.openssl-decrypt.php
 * @param string $data The encrypted message to be decrypted.
 * @param string $method The cipher method. For a list of available cipher methods, use 
 * openssl_get_cipher_methods.
 * @param string $key The key.
 * @param int $options [optional] options can be one of
 * OPENSSL_RAW_DATA,
 * OPENSSL_ZERO_PADDING.
 * @param string $iv [optional] A non-NULL Initialization Vector.
 * @param string $tag [optional] The authentication tag in AEAD cipher mode. If it is incorrect, the authentication fails and the function returns false.
 * @param string $aad [optional] Additional authentication data.
 * @return string The decrypted string on success or false on failure.
 */
function openssl_decrypt (string $data, string $method, string $key, int $options = null, string $iv = null, string $tag = null, string $aad = null) {}

/**
 * Gets the cipher iv length
 * @link http://www.php.net/manual/en/function.openssl-cipher-iv-length.php
 * @param string $method The cipher method, see openssl_get_cipher_methods for a list of potential values.
 * @return int the cipher length on success, or false on failure.
 */
function openssl_cipher_iv_length (string $method) {}

/**
 * Generate signature
 * @link http://www.php.net/manual/en/function.openssl-sign.php
 * @param string $data The string of data you wish to sign
 * @param string $signature If the call was successful the signature is returned in
 * signature.
 * @param mixed $priv_key_id <p>
 * resource - a key, returned by openssl_get_privatekey
 * </p>
 * <p>
 * string - a PEM formatted key
 * </p>
 * @param mixed $signature_alg [optional] <p>
 * int - one of these Signature Algorithms.
 * </p>
 * <p>
 * string - a valid string returned by openssl_get_md_methods example, "sha256WithRSAEncryption" or "sha384".
 * </p>
 * @return bool true on success or false on failure
 */
function openssl_sign (string $data, string &$signature, $priv_key_id, $signature_alg = null) {}

/**
 * Verify signature
 * @link http://www.php.net/manual/en/function.openssl-verify.php
 * @param string $data The string of data used to generate the signature previously
 * @param string $signature A raw binary string, generated by openssl_sign or similar means
 * @param mixed $pub_key_id <p>
 * resource - a key, returned by openssl_get_publickey
 * </p>
 * <p>
 * string - a PEM formatted key, example, "-----BEGIN PUBLIC KEY-----
 * MIIBCgK..."
 * </p>
 * @param mixed $signature_alg [optional] <p>
 * int - one of these Signature Algorithms.
 * </p>
 * <p>
 * string - a valid string returned by openssl_get_md_methods example, "sha1WithRSAEncryption" or "sha512".
 * </p>
 * @return int 1 if the signature is correct, 0 if it is incorrect, and
 * -1 on error.
 */
function openssl_verify (string $data, string $signature, $pub_key_id, $signature_alg = null) {}

/**
 * Seal (encrypt) data
 * @link http://www.php.net/manual/en/function.openssl-seal.php
 * @param string $data The data to seal.
 * @param string $sealed_data The sealed data.
 * @param array $env_keys Array of encrypted keys.
 * @param array $pub_key_ids Array of public key resource identifiers.
 * @param string $method [optional] The cipher method.
 * @param string $iv [optional] The initialization vector.
 * @return int the length of the sealed data on success, or false on error.
 * If successful the sealed data is returned in
 * sealed_data, and the envelope keys in
 * env_keys.
 */
function openssl_seal (string $data, string &$sealed_data, array &$env_keys, array $pub_key_ids, string $method = null, string &$iv = null) {}

/**
 * Open sealed data
 * @link http://www.php.net/manual/en/function.openssl-open.php
 * @param string $sealed_data 
 * @param string $open_data If the call is successful the opened data is returned in this
 * parameter.
 * @param string $env_key 
 * @param mixed $priv_key_id 
 * @param string $method [optional] The cipher method.
 * @param string $iv [optional] The initialization vector.
 * @return bool true on success or false on failure
 */
function openssl_open (string $sealed_data, string &$open_data, string $env_key, $priv_key_id, string $method = null, string $iv = null) {}

/**
 * Generates a PKCS5 v2 PBKDF2 string
 * @link http://www.php.net/manual/en/function.openssl-pbkdf2.php
 * @param string $password Password from which the derived key is generated.
 * @param string $salt PBKDF2 recommends a crytographic salt of at least 64 bits (8 bytes).
 * @param int $key_length Length of desired output key.
 * @param int $iterations The number of iterations desired. NIST 
 * recommends at least 10,000.
 * @param string $digest_algorithm [optional] Optional hash or digest algorithm from openssl_get_md_methods. Defaults to SHA-1.
 * @return string raw binary string or false on failure.
 */
function openssl_pbkdf2 (string $password, string $salt, int $key_length, int $iterations, string $digest_algorithm = null) {}

/**
 * Verifies the signature of an S/MIME signed message
 * @link http://www.php.net/manual/en/function.openssl-pkcs7-verify.php
 * @param string $filename Path to the message.
 * @param int $flags flags can be used to affect how the signature is
 * verified - see PKCS7 constants
 * for more information.
 * @param string $outfilename [optional] If the outfilename is specified, it should be a
 * string holding the name of a file into which the certificates of the
 * persons that signed the messages will be stored in PEM format.
 * @param array $cainfo [optional] If the cainfo is specified, it should hold
 * information about the trusted CA certificates to use in the verification
 * process - see certificate
 * verification for more information about this parameter.
 * @param string $extracerts [optional] If the extracerts is specified, it is the filename
 * of a file containing a bunch of certificates to use as untrusted CAs.
 * @param string $content [optional] You can specify a filename with content that will
 * be filled with the verified data, but with the signature information
 * stripped.
 * @param string $p7bfilename [optional] 
 * @return mixed true if the signature is verified, false if it is not correct
 * (the message has been tampered with, or the signing certificate is invalid),
 * or -1 on error.
 */
function openssl_pkcs7_verify (string $filename, int $flags, string $outfilename = null, array $cainfo = null, string $extracerts = null, string $content = null, string $p7bfilename = null) {}

/**
 * Decrypts an S/MIME encrypted message
 * @link http://www.php.net/manual/en/function.openssl-pkcs7-decrypt.php
 * @param string $infilename 
 * @param string $outfilename The decrypted message is written to the file specified by
 * outfilename.
 * @param mixed $recipcert 
 * @param mixed $recipkey [optional] 
 * @return bool true on success or false on failure
 */
function openssl_pkcs7_decrypt (string $infilename, string $outfilename, $recipcert, $recipkey = null) {}

/**
 * Sign an S/MIME message
 * @link http://www.php.net/manual/en/function.openssl-pkcs7-sign.php
 * @param string $infilename The input file you are intending to digitally sign.
 * @param string $outfilename The file which the digital signature will be written to.
 * @param mixed $signcert The X.509 certificate used to digitally sign infilename.
 * See Key/Certificate parameters for a list of valid values.
 * @param mixed $privkey privkey is the private key corresponding to signcert.
 * See Public/Private Key parameters for a list of valid values.
 * @param array $headers headers is an array of headers that
 * will be prepended to the data after it has been signed (see
 * openssl_pkcs7_encrypt for more information about
 * the format of this parameter).
 * @param int $flags [optional] flags can be used to alter the output - see PKCS7 constants.
 * @param string $extracerts [optional] extracerts specifies the name of a file containing
 * a bunch of extra certificates to include in the signature which can for
 * example be used to help the recipient to verify the certificate that you used.
 * @return bool true on success or false on failure
 */
function openssl_pkcs7_sign (string $infilename, string $outfilename, $signcert, $privkey, array $headers, int $flags = null, string $extracerts = null) {}

/**
 * Encrypt an S/MIME message
 * @link http://www.php.net/manual/en/function.openssl-pkcs7-encrypt.php
 * @param string $infile 
 * @param string $outfile 
 * @param mixed $recipcerts Either a lone X.509 certificate, or an array of X.509 certificates.
 * @param array $headers <p>
 * headers is an array of headers that
 * will be prepended to the data after it has been encrypted.
 * </p>
 * <p>
 * headers can be either an associative array
 * keyed by header name, or an indexed array, where each element contains
 * a single header line.
 * </p>
 * @param int $flags [optional] flags can be used to specify options that affect
 * the encoding process - see PKCS7
 * constants.
 * @param int $cipherid [optional] One of cipher constants.
 * @return bool true on success or false on failure
 */
function openssl_pkcs7_encrypt (string $infile, string $outfile, $recipcerts, array $headers, int $flags = null, int $cipherid = null) {}

/**
 * Export the PKCS7 file to an array of PEM certificates
 * @link http://www.php.net/manual/en/function.openssl-pkcs7-read.php
 * @param string $infilename 
 * @param array $certs 
 * @return bool true on success or false on failure
 */
function openssl_pkcs7_read (string $infilename, array &$certs) {}

/**
 * Encrypts data with private key
 * @link http://www.php.net/manual/en/function.openssl-private-encrypt.php
 * @param string $data 
 * @param string $crypted 
 * @param mixed $key 
 * @param int $padding [optional] padding can be one of
 * OPENSSL_PKCS1_PADDING,
 * OPENSSL_NO_PADDING.
 * @return bool true on success or false on failure
 */
function openssl_private_encrypt (string $data, string &$crypted, $key, int $padding = null) {}

/**
 * Decrypts data with private key
 * @link http://www.php.net/manual/en/function.openssl-private-decrypt.php
 * @param string $data 
 * @param string $decrypted 
 * @param mixed $key key must be the private key corresponding that
 * was used to encrypt the data.
 * @param int $padding [optional] padding can be one of
 * OPENSSL_PKCS1_PADDING,
 * OPENSSL_SSLV23_PADDING,
 * OPENSSL_PKCS1_OAEP_PADDING,
 * OPENSSL_NO_PADDING.
 * @return bool true on success or false on failure
 */
function openssl_private_decrypt (string $data, string &$decrypted, $key, int $padding = null) {}

/**
 * Encrypts data with public key
 * @link http://www.php.net/manual/en/function.openssl-public-encrypt.php
 * @param string $data 
 * @param string $crypted This will hold the result of the encryption.
 * @param mixed $key The public key.
 * @param int $padding [optional] padding can be one of
 * OPENSSL_PKCS1_PADDING,
 * OPENSSL_SSLV23_PADDING,
 * OPENSSL_PKCS1_OAEP_PADDING,
 * OPENSSL_NO_PADDING.
 * @return bool true on success or false on failure
 */
function openssl_public_encrypt (string $data, string &$crypted, $key, int $padding = null) {}

/**
 * Decrypts data with public key
 * @link http://www.php.net/manual/en/function.openssl-public-decrypt.php
 * @param string $data 
 * @param string $decrypted 
 * @param mixed $key key must be the public key corresponding that
 * was used to encrypt the data.
 * @param int $padding [optional] padding can be one of
 * OPENSSL_PKCS1_PADDING,
 * OPENSSL_NO_PADDING.
 * @return bool true on success or false on failure
 */
function openssl_public_decrypt (string $data, string &$decrypted, $key, int $padding = null) {}

/**
 * Gets available digest methods
 * @link http://www.php.net/manual/en/function.openssl-get-md-methods.php
 * @param bool $aliases [optional] Set to true if digest aliases should be included within the
 * returned array.
 * @return array An array of available digest methods.
 */
function openssl_get_md_methods (bool $aliases = null) {}

/**
 * Gets available cipher methods
 * @link http://www.php.net/manual/en/function.openssl-get-cipher-methods.php
 * @param bool $aliases [optional] Set to true if cipher aliases should be included within the
 * returned array.
 * @return array An array of available cipher methods.
 */
function openssl_get_cipher_methods (bool $aliases = null) {}

/**
 * Gets list of available curve names for ECC
 * @link http://www.php.net/manual/en/function.openssl-get-curve-names.php
 * @return array An array of available curve names.
 */
function openssl_get_curve_names () {}

/**
 * Computes shared secret for public value of remote DH public key and local DH key
 * @link http://www.php.net/manual/en/function.openssl-dh-compute-key.php
 * @param string $pub_key DH Public key of the remote party.
 * @param resource $dh_key A local DH private key, corresponding to the public key to be shared with the remote party.
 * @return string shared secret on success or false on failure.
 */
function openssl_dh_compute_key (string $pub_key, $dh_key) {}

/**
 * @param mixed $peer_pub_key
 * @param mixed $priv_key
 * @param mixed $keylen [optional]
 */
function openssl_pkey_derive ($peer_pub_key, $priv_key, $keylen = null) {}

/**
 * Generate a pseudo-random string of bytes
 * @link http://www.php.net/manual/en/function.openssl-random-pseudo-bytes.php
 * @param int $length The length of the desired string of bytes. Must be a positive integer. PHP will
 * try to cast this parameter to a non-null integer to use it.
 * @param bool $crypto_strong [optional] If passed into the function, this will hold a boolean value that determines
 * if the algorithm used was "cryptographically strong", e.g., safe for usage with GPG, 
 * passwords, etc. true if it did, otherwise false
 * @return string the generated string of bytes on success, or false on failure.
 */
function openssl_random_pseudo_bytes (int $length, bool &$crypto_strong = null) {}

/**
 * Return openSSL error message
 * @link http://www.php.net/manual/en/function.openssl-error-string.php
 * @return string an error message string, or false if there are no more error
 * messages to return.
 */
function openssl_error_string () {}


/**
 * Added in PHP 5.2.0.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_VERSION_TEXT', "OpenSSL 1.1.1d  10 Sep 2019");

/**
 * Added in PHP 5.2.0.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_VERSION_NUMBER', 269488207);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('X509_PURPOSE_SSL_CLIENT', 1);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('X509_PURPOSE_SSL_SERVER', 2);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('X509_PURPOSE_NS_SSL_SERVER', 3);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('X509_PURPOSE_SMIME_SIGN', 4);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('X509_PURPOSE_SMIME_ENCRYPT', 5);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('X509_PURPOSE_CRL_SIGN', 6);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('X509_PURPOSE_ANY', 7);

/**
 * Used as default algorithm by openssl_sign and
 * openssl_verify.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_ALGO_SHA1', 1);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_ALGO_MD5', 2);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_ALGO_MD4', 3);

/**
 * Added in PHP 5.4.8.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_ALGO_SHA224', 6);

/**
 * Added in PHP 5.4.8.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_ALGO_SHA256', 7);

/**
 * Added in PHP 5.4.8.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_ALGO_SHA384', 8);

/**
 * Added in PHP 5.4.8.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_ALGO_SHA512', 9);

/**
 * Added in PHP 5.4.8.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_ALGO_RMD160', 10);

/**
 * When signing a message, use cleartext signing with the MIME
 * type "multipart/signed". This is the default
 * if you do not specify any flags to
 * openssl_pkcs7_sign.
 * If you turn this option off, the message will be signed using
 * opaque signing, which is more resistant to translation by mail relays
 * but cannot be read by mail agents that do not support S/MIME.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('PKCS7_DETACHED', 64);

/**
 * Adds text/plain content type headers to encrypted/signed
 * message. If decrypting or verifying, it strips those headers from
 * the output - if the decrypted or verified message is not of MIME type
 * text/plain then an error will occur.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('PKCS7_TEXT', 1);

/**
 * When verifying a message, certificates (if
 * any) included in the message are normally searched for the
 * signing certificate. With this option only the
 * certificates specified in the extracerts
 * parameter of openssl_pkcs7_verify are
 * used. The supplied certificates can still be used as
 * untrusted CAs however.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('PKCS7_NOINTERN', 16);

/**
 * Do not verify the signers certificate of a signed
 * message.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('PKCS7_NOVERIFY', 32);

/**
 * Do not chain verification of signers certificates: that is
 * don't use the certificates in the signed message as untrusted CAs.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('PKCS7_NOCHAIN', 8);

/**
 * When signing a message the signer's certificate is normally
 * included - with this option it is excluded. This will reduce the
 * size of the signed message but the verifier must have a copy of the
 * signers certificate available locally (passed using the
 * extracerts to
 * openssl_pkcs7_verify for example).
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('PKCS7_NOCERTS', 2);

/**
 * Normally when a message is signed, a set of attributes are
 * included which include the signing time and the supported symmetric
 * algorithms. With this option they are not included.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('PKCS7_NOATTR', 256);

/**
 * Normally the input message is converted to "canonical" format
 * which is effectively using CR and LF
 * as end of line: as required by the S/MIME specification. When this
 * option is present, no translation occurs. This is useful when
 * handling binary data which may not be in MIME format.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('PKCS7_BINARY', 128);

/**
 * Don't try and verify the signatures on a message
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('PKCS7_NOSIGS', 4);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_PKCS1_PADDING', 1);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_SSLV23_PADDING', 2);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_NO_PADDING', 3);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_PKCS1_OAEP_PADDING', 4);
define ('OPENSSL_DEFAULT_STREAM_CIPHERS', "ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-AES256-GCM-SHA384:DHE-RSA-AES128-GCM-SHA256:DHE-DSS-AES128-GCM-SHA256:kEDH+AESGCM:ECDHE-RSA-AES128-SHA256:ECDHE-ECDSA-AES128-SHA256:ECDHE-RSA-AES128-SHA:ECDHE-ECDSA-AES128-SHA:ECDHE-RSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES256-SHA:ECDHE-ECDSA-AES256-SHA:DHE-RSA-AES128-SHA256:DHE-RSA-AES128-SHA:DHE-DSS-AES128-SHA256:DHE-RSA-AES256-SHA256:DHE-DSS-AES256-SHA:DHE-RSA-AES256-SHA:AES128-GCM-SHA256:AES256-GCM-SHA384:AES128:AES256:HIGH:!SSLv2:!aNULL:!eNULL:!EXPORT:!DES:!MD5:!RC4:!ADH");

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_CIPHER_RC2_40', 0);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_CIPHER_RC2_128', 1);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_CIPHER_RC2_64', 2);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_CIPHER_DES', 3);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_CIPHER_3DES', 4);

/**
 * Added in PHP 5.4.0.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_CIPHER_AES_128_CBC', 5);

/**
 * Added in PHP 5.4.0.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_CIPHER_AES_192_CBC', 6);

/**
 * Added in PHP 5.4.0.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_CIPHER_AES_256_CBC', 7);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_KEYTYPE_RSA', 0);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_KEYTYPE_DSA', 1);

/**
 * 
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_KEYTYPE_DH', 2);

/**
 * This constant is only available when PHP is compiled with OpenSSL 0.9.8+.
 * Added in PHP 5.2.0.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_KEYTYPE_EC', 3);
define ('OPENSSL_RAW_DATA', 1);
define ('OPENSSL_ZERO_PADDING', 2);
define ('OPENSSL_DONT_ZERO_PAD_KEY', 4);

/**
 * Whether SNI support is available or not.
 * @link http://www.php.net/manual/en/openssl.constants.php
 */
define ('OPENSSL_TLSEXT_SERVER_NAME', 1);

// End of openssl v.7.4.0
