/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.internal.ui.navigator.ProjectFragmentContainer;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.ui.IWorkingSet;

public class DLTKStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "DLTK";
    private final StandardModelElementContentProvider modelContentProvider = new StandardModelElementContentProvider(true);

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Object getAdaptedParent(Object object) {
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            return DLTKCore.create((IResource)file.getParent());
        }
        return super.getAdaptedParent(object);
    }

    public String getParentHandle(String handle) {
        IModelElement javaElement = (IModelElement)this.getObjectForHandle(handle);
        if (javaElement != null && this.modelContentProvider.getParent((Object)javaElement) != null) {
            return this.getHandleIdentifier(this.modelContentProvider.getParent((Object)javaElement));
        }
        return null;
    }

    public List<String> getChildHandles(String handle) {
        IModelElement element;
        Object object = this.getObjectForHandle(handle);
        if (object instanceof IModelElement && (element = (IModelElement)object) instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                List resourceChildren;
                Object[] children = this.modelContentProvider.getExtendedChildren((Object)element, (Object[])parent.getChildren());
                ArrayList<String> childHandles = new ArrayList<String>();
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element2 = objectArray[n2];
                    String childHandle = this.getHandleIdentifier(element2);
                    if (childHandle != null) {
                        childHandles.add(childHandle);
                    }
                    ++n2;
                }
                AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
                if (parentBridge != null && "resource".equals(parentBridge.getContentType()) && element.getElementType() < 7 && !(resourceChildren = parentBridge.getChildHandles(handle)).isEmpty()) {
                    childHandles.addAll(resourceChildren);
                }
                return childHandles;
            }
            catch (ModelException e) {
                AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)"resource");
                return parentBridge.getChildHandles(handle);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Could not get children", (Throwable)e));
            }
        }
        return Collections.emptyList();
    }

    public Object getObjectForHandle(String handle) {
        try {
            return DLTKCore.create((String)handle);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.dltk.mylyn", "Could not create java element for handle: " + handle, t));
            return null;
        }
    }

    public String getHandleIdentifier(Object object) {
        Object adapter;
        if (object instanceof IModelElement) {
            return ((IModelElement)object).getHandleIdentifier();
        }
        if (object instanceof IAdaptable && (adapter = ((IAdaptable)object).getAdapter(IModelElement.class)) instanceof IModelElement) {
            return ((IModelElement)adapter).getHandleIdentifier();
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof IModelElement) {
            return ((IModelElement)object).getElementName();
        }
        return "";
    }

    public boolean canBeLandmark(String handle) {
        IModelElement element = (IModelElement)this.getObjectForHandle(handle);
        return (element instanceof IMember || element instanceof IType) && element.exists();
    }

    public boolean acceptsObject(Object object) {
        if (object instanceof IResource) {
            IModelElement adapter = (IModelElement)((IResource)object).getAdapter(IModelElement.class);
            return adapter != null;
        }
        boolean accepts = object instanceof IModelElement || object instanceof ProjectFragmentContainer || object instanceof IProjectFragment;
        return accepts;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean canFilter(Object object) {
        if (object instanceof BuildPathContainer.RequiredProjectWrapper) {
            return true;
        }
        if (object instanceof ProjectFragmentContainer) {
            IAdaptable[] children;
            ProjectFragmentContainer container = (ProjectFragmentContainer)object;
            IAdaptable[] iAdaptableArray = children = container.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable element2 = iAdaptableArray[n2];
                if (element2 instanceof ProjectFragment) {
                    ProjectFragment element = (ProjectFragment)element2;
                    IInteractionElement node = ContextCore.getContextManager().getElement(element.getHandleIdentifier());
                    if (node != null && node.getInterest().isInteresting()) {
                        return false;
                    }
                }
                ++n2;
            }
        } else if (object instanceof IWorkingSet) {
            try {
                IAdaptable[] elements;
                IWorkingSet workingSet = (IWorkingSet)object;
                IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
                int n = elements.length;
                int n3 = 0;
                while (n3 < n) {
                    IAdaptable adaptable = iAdaptableArray[n3];
                    IInteractionElement interactionElement = ContextCore.getContextManager().getElement(this.getHandleIdentifier(adaptable));
                    if (interactionElement != null && interactionElement.getInterest().isInteresting()) {
                        return false;
                    }
                    ++n3;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean isDocument(String handle) {
        return this.getObjectForHandle(handle) instanceof ISourceModule;
    }

    public String getHandleForOffsetInObject(Object object, int offset) {
        ISourceModule compilationUnit;
        IMarker marker;
        block12: {
            if (!(object instanceof IMarker)) {
                return null;
            }
            marker = (IMarker)object;
            compilationUnit = null;
            IResource resource = marker.getResource();
            if (!(resource instanceof IFile)) break block12;
            IFile file = (IFile)resource;
            if (file.getFileExtension().equals("java")) {
                compilationUnit = DLTKCore.createSourceModuleFrom((IFile)file);
                break block12;
            }
            return null;
        }
        try {
            if (compilationUnit != null) {
                int attribute = marker.getAttribute("charStart", 0);
                int charStart = attribute;
                IModelElement javaElement = null;
                if (charStart != -1) {
                    javaElement = compilationUnit.getElementAt(charStart);
                } else {
                    Integer lineNumberAttribute = marker.getAttribute("lineNumber", 0);
                    int lineNumber = lineNumberAttribute;
                    if (lineNumber != -1) {
                        javaElement = compilationUnit;
                    }
                }
                if (javaElement != null) {
                    return javaElement.getHandleIdentifier();
                }
                return null;
            }
            return null;
        }
        catch (ModelException ex) {
            if (!ex.isDoesNotExist()) {
                ExceptionHandler.handle((CoreException)((Object)ex), (String)"error", (String)"could not find java element");
            }
            return null;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Could not find element for: " + marker, t));
            return null;
        }
    }

    public String getContentType(String elementHandle) {
        return this.getContentType();
    }

    public boolean containsProblem(IInteractionElement node) {
        try {
            IModelElement element = (IModelElement)this.getObjectForHandle(node.getHandleIdentifier());
            switch (element.getElementType()) {
                case 2: 
                case 3: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 2, null);
                }
                case 4: 
                case 5: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    ISourceModule cu = (ISourceModule)element.getAncestor(1);
                    if (cu != null) {
                        return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                    }
                    break;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private boolean getErrorTicksFromMarkers(IResource res, int depth, ISourceReference sourceElement) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return false;
        }
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                int priority;
                IMarker curr = iMarkerArray[n2];
                if (sourceElement == null && (priority = curr.getAttribute("severity", -1)) == 2) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

