/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ant.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.tools.ant.BuildException;
import org.eclipse.mylyn.wikitext.ant.internal.MarkupToHtmlTask;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.splitter.SplitOutlineItem;
import org.eclipse.mylyn.wikitext.splitter.SplittingMarkupToEclipseToc;

public class MarkupToEclipseHelpTask
extends MarkupToHtmlTask {
    private String xmlFilenameFormat = "$1-toc.xml";
    private String helpPrefix;
    private int tocAnchorLevel = 0;

    @Override
    void processed(String markupContent, SplitOutlineItem item, File baseDir, File source) {
        File tocOutputFile;
        super.processed(markupContent, item, baseDir, source);
        String name = source.getName();
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (!(tocOutputFile = this.computeTocFile(source, name)).exists() || this.overwrite || tocOutputFile.lastModified() < source.lastModified()) {
            File htmlOutputFile = this.computeHtmlFile(source, name);
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tocOutputFile)), StandardCharsets.UTF_8);){
                    SplittingMarkupToEclipseToc toEclipseToc = new SplittingMarkupToEclipseToc();
                    toEclipseToc.setHelpPrefix(this.helpPrefix);
                    toEclipseToc.setAnchorLevel(this.tocAnchorLevel);
                    System.out.println("Help: " + String.valueOf(baseDir) + " " + String.valueOf(htmlOutputFile));
                    toEclipseToc.setBookTitle(this.title == null ? name : this.title);
                    toEclipseToc.setCopyrightNotice(this.getCopyrightNotice());
                    String basePath = baseDir.getAbsolutePath().replace('\\', '/');
                    String outputFilePath = htmlOutputFile.getAbsolutePath().replace('\\', '/');
                    if (outputFilePath.startsWith(basePath)) {
                        String filePath = outputFilePath.substring(basePath.length());
                        if (filePath.startsWith("/")) {
                            filePath = filePath.substring(1);
                        }
                        if (filePath.lastIndexOf(47) != -1) {
                            String relativePart = filePath.substring(0, filePath.lastIndexOf(47));
                            toEclipseToc.setHelpPrefix((String)(this.helpPrefix == null ? relativePart : this.helpPrefix + "/" + relativePart));
                        }
                    }
                    toEclipseToc.setHtmlFile(htmlOutputFile.getName());
                    String tocXml = toEclipseToc.createToc((OutlineItem)item);
                    try {
                        writer.write(tocXml);
                    }
                    catch (Exception e) {
                        throw new BuildException(String.format("Cannot write to file '%s': %s", tocXml, e.getMessage()), (Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new BuildException(String.format("Cannot write to file '%s': %s", tocOutputFile, e.getMessage()), (Throwable)e);
            }
        }
    }

    private File computeTocFile(File source, String name) {
        return new File(source.getParentFile(), this.xmlFilenameFormat.replace("$1", name));
    }

    public String getXmlFilenameFormat() {
        return this.xmlFilenameFormat;
    }

    public void setXmlFilenameFormat(String xmlFilenameFormat) {
        this.xmlFilenameFormat = xmlFilenameFormat;
    }

    public String getHelpPrefix() {
        return this.helpPrefix;
    }

    public void setHelpPrefix(String helpPrefix) {
        this.helpPrefix = helpPrefix;
    }

    public int getTocAnchorLevel() {
        return this.tocAnchorLevel;
    }

    public void setTocAnchorLevel(int tocAnchorLevel) {
        this.tocAnchorLevel = tocAnchorLevel;
    }
}

