"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
var defaultConfiguration = {
    tags: ['styled', 'css', 'extend', 'injectGlobal', 'createGlobalStyle'],
    validate: true,
    lint: {
        emptyRules: 'ignore',
    },
    emmet: {},
};
exports.loadConfiguration = function (config) {
    var lint = Object.assign({}, defaultConfiguration.lint, config.lint || {});
    return {
        tags: config.tags || defaultConfiguration.tags,
        validate: typeof config.validate !== 'undefined' ? config.validate : defaultConfiguration.validate,
        lint: lint,
        emmet: config.emmet || defaultConfiguration.emmet,
    };
};
