/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter;

import org.eclipse.dltk.formatter.FormatterBlockNode;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterWriter;

public class FormatterIndentedBlockNode
extends FormatterBlockNode {
    private final boolean indenting;

    public FormatterIndentedBlockNode(IFormatterDocument document, boolean indenting) {
        super(document);
        this.indenting = indenting;
    }

    @Override
    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        if (this.isIndenting()) {
            context.incIndent();
        }
        super.accept(context, visitor);
        if (this.isIndenting()) {
            context.decIndent();
        }
    }

    protected boolean isIndenting() {
        return this.indenting;
    }
}

