/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;

public class ConditionalExpressionEvaluator
extends GoalEvaluator {
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public ConditionalExpressionEvaluator(IGoal goal) {
        super(goal);
    }

    public Object produceResult() {
        if (!this.evaluated.isEmpty()) {
            return PHPTypeInferenceUtils.combineTypes(this.evaluated);
        }
        return null;
    }

    public IGoal[] init() {
        ExpressionTypeGoal typedGoal = (ExpressionTypeGoal)this.goal;
        ConditionalExpression conditionalExpression = (ConditionalExpression)typedGoal.getExpression();
        ArrayList<ExpressionTypeGoal> result = new ArrayList<ExpressionTypeGoal>();
        if (conditionalExpression.getIfTrue() != null) {
            result.add(new ExpressionTypeGoal(this.goal.getContext(), (ASTNode)conditionalExpression.getIfTrue()));
        }
        if (conditionalExpression.getIfFalse() != null) {
            result.add(new ExpressionTypeGoal(this.goal.getContext(), (ASTNode)conditionalExpression.getIfFalse()));
        }
        return result.toArray(new IGoal[result.size()]);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }
}

