/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.refactoring.descriptors;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.WorkingCopyOwner;

public class RefactoringDescriptorUtil {
    private static final String LOWER_CASE_FALSE = Boolean.FALSE.toString().toLowerCase();
    private static final String LOWER_CASE_TRUE = Boolean.TRUE.toString().toLowerCase();

    public static String elementToHandle(String project, IModelElement element) {
        IScriptProject javaProject;
        String handle = element.getHandleIdentifier();
        if (project != null && !(element instanceof IScriptProject) && project.equals((javaProject = element.getScriptProject()).getElementName())) {
            String id = javaProject.getHandleIdentifier();
            return handle.substring(id.length());
        }
        return handle;
    }

    public static String resourcePathToHandle(String project, IPath resourcePath) {
        if (project != null && !"".equals(project) && resourcePath.segmentCount() != 1 && resourcePath.segment(0).equals(project)) {
            return resourcePath.removeFirstSegments(1).toPortableString();
        }
        return resourcePath.toPortableString();
    }

    public static IModelElement handleToElement(WorkingCopyOwner owner, String project, String handle, boolean check) {
        IMethod method;
        IMethod[] methods;
        IModelElement element = null;
        element = owner != null ? DLTKCore.create((String)handle, (WorkingCopyOwner)owner) : DLTKCore.create((String)handle);
        if (element == null && project != null) {
            IScriptProject javaProject = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getScriptProject(project);
            String identifier = javaProject.getHandleIdentifier();
            element = owner != null ? DLTKCore.create((String)(identifier + handle), (WorkingCopyOwner)owner) : DLTKCore.create((String)(identifier + handle));
        }
        if (check && element instanceof IMethod && (methods = (method = (IMethod)element).getDeclaringType().findMethods(method)) != null && methods.length > 0) {
            element = methods[0];
        }
        if (element != null && (!check || element.exists())) {
            return element;
        }
        return null;
    }

    public static IResource handleToResource(String project, String handle) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if ("".equals(handle)) {
            return null;
        }
        IPath path = Path.fromPortableString((String)handle);
        if (path == null) {
            return null;
        }
        if (project != null && !"".equals(project)) {
            return root.getProject(project).findMember(path);
        }
        return root.findMember(path);
    }

    public static IPath handleToResourcePath(String project, String handle) {
        IPath path = Path.fromPortableString((String)handle);
        if (project != null && !"".equals(project) && !path.isAbsolute()) {
            return new Path(project).append(path).makeAbsolute();
        }
        return path;
    }

    public static String getString(Map<String, String> map, String attribute, boolean allowNull) throws IllegalArgumentException {
        String object = map.get(attribute);
        if (object == null) {
            if (allowNull) {
                return null;
            }
            throw new IllegalArgumentException("The map does not contain the attribute '" + attribute + "'");
        }
        if (object instanceof String) {
            String value = object;
            return value;
        }
        throw new IllegalArgumentException("The provided map does not contain a string for attribute '" + attribute + "'");
    }

    public static String getString(Map<String, String> map, String attribute) throws IllegalArgumentException {
        return RefactoringDescriptorUtil.getString(map, attribute, false);
    }

    public static String[] getStringArray(Map<String, String> map, String countAttribute, String arrayAttribute, int offset) throws IllegalArgumentException {
        int count = RefactoringDescriptorUtil.getInt(map, countAttribute);
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = RefactoringDescriptorUtil.getString(map, RefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset));
            ++i;
        }
        return result;
    }

    public static int getInt(Map<String, String> map, String attribute) throws IllegalArgumentException {
        String value = RefactoringDescriptorUtil.getString(map, attribute);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The attribute '" + attribute + "' does not contain a valid int '" + value + "'");
        }
    }

    public static int getInt(Map<String, String> map, String attribute, int defaultValue) throws IllegalArgumentException {
        String value = RefactoringDescriptorUtil.getString(map, attribute, true);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The attribute '" + attribute + "' does not contain a valid int '" + value + "'");
        }
    }

    public static int[] getIntArray(Map<String, String> map, String countAttribute, String arrayAttribute) throws IllegalArgumentException {
        int count = RefactoringDescriptorUtil.getInt(map, countAttribute);
        int[] result = new int[count];
        int i = 0;
        while (i < count) {
            result[i] = RefactoringDescriptorUtil.getInt(map, RefactoringDescriptorUtil.getAttributeName(arrayAttribute, i));
            ++i;
        }
        return result;
    }

    public static String getAttributeName(String attribute, int index) {
        return attribute + index;
    }

    public static IModelElement getModelElement(Map<String, String> map, String attribute, String project) throws IllegalArgumentException {
        return RefactoringDescriptorUtil.getModelElement(map, attribute, project, false);
    }

    public static IModelElement getModelElement(Map<String, String> map, String attribute, String project, boolean allowNull) throws IllegalArgumentException {
        String handle = RefactoringDescriptorUtil.getString(map, attribute, allowNull);
        if (handle != null) {
            return RefactoringDescriptorUtil.handleToElement(null, project, handle, false);
        }
        return null;
    }

    public static <T> IModelElement[] getModelElementArray(Map<String, String> map, String countAttribute, String arrayAttribute, int offset, String project, Class<T> arrayClass) throws IllegalArgumentException {
        if (countAttribute != null) {
            int count = RefactoringDescriptorUtil.getInt(map, countAttribute);
            IModelElement[] result = (IModelElement[])Array.newInstance(arrayClass, count);
            int i = 0;
            while (i < count) {
                result[i] = RefactoringDescriptorUtil.getModelElement(map, RefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset), project);
                ++i;
            }
            return result;
        }
        ArrayList<IModelElement> result = new ArrayList<IModelElement>();
        IModelElement element = null;
        while ((element = RefactoringDescriptorUtil.getModelElement(map, arrayAttribute, project, true)) != null) {
            result.add(element);
        }
        return result.toArray((IModelElement[])Array.newInstance(arrayClass, result.size()));
    }

    public static IPath getResourcePath(Map<String, String> map, String attribute, String project) throws IllegalArgumentException {
        String handle = RefactoringDescriptorUtil.getString(map, attribute);
        return RefactoringDescriptorUtil.handleToResourcePath(project, handle);
    }

    public static IPath[] getResourcePathArray(Map<String, String> map, String countAttribute, String arrayAttribute, int offset, String project) throws IllegalArgumentException {
        int count = RefactoringDescriptorUtil.getInt(map, countAttribute);
        IPath[] result = new IPath[count];
        int i = 0;
        while (i < count) {
            result[i] = RefactoringDescriptorUtil.getResourcePath(map, RefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset), project);
            ++i;
        }
        return result;
    }

    public static boolean[] getBooleanArray(Map<String, String> map, String countAttribute, String arrayAttribute, int offset) throws IllegalArgumentException {
        int count = RefactoringDescriptorUtil.getInt(map, countAttribute);
        boolean[] result = new boolean[count];
        int i = 0;
        while (i < count) {
            result[i] = RefactoringDescriptorUtil.getBoolean(map, RefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset));
            ++i;
        }
        return result;
    }

    public static boolean getBoolean(Map<String, String> map, String attribute) throws IllegalArgumentException {
        String value = RefactoringDescriptorUtil.getString(map, attribute).toLowerCase();
        if (LOWER_CASE_TRUE.equals(value)) {
            return true;
        }
        if (LOWER_CASE_FALSE.equals(value)) {
            return false;
        }
        throw new IllegalArgumentException("The attribute '" + attribute + "' does not contain a valid boolean: '" + value + "'");
    }

    public static boolean hasBoolean(Map<String, String> map, String attribute) throws IllegalArgumentException {
        String string = RefactoringDescriptorUtil.getString(map, attribute, true);
        if (string == null) {
            return false;
        }
        String value = string.toLowerCase();
        if (LOWER_CASE_TRUE.equals(value)) {
            return true;
        }
        if (LOWER_CASE_FALSE.equals(value)) {
            return true;
        }
        throw new IllegalArgumentException("The attribute '" + attribute + "' does not contain a valid boolean: '" + value + "'");
    }

    public static boolean getBoolean(Map<String, String> map, String attribute, boolean defaultValue) throws IllegalArgumentException {
        String value = RefactoringDescriptorUtil.getString(map, attribute, true);
        if (value == null) {
            return defaultValue;
        }
        if (LOWER_CASE_TRUE.equals(value = value.toLowerCase())) {
            return true;
        }
        if (LOWER_CASE_FALSE.equals(value)) {
            return false;
        }
        throw new IllegalArgumentException("The attribute '" + attribute + "' does not contain a valid boolean: '" + value + "'");
    }

    public static void setModelElement(Map<String, String> arguments, String attribute, String project, IModelElement element) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("The element for attribute '" + attribute + "' may not be null");
        }
        RefactoringDescriptorUtil.setString(arguments, attribute, RefactoringDescriptorUtil.elementToHandle(project, element));
    }

    public static void setResourcePath(Map<String, String> arguments, String attribute, String project, IPath resourcePath) throws IllegalArgumentException {
        if (resourcePath == null) {
            throw new IllegalArgumentException("The resource for attribute '" + attribute + "' may not be null");
        }
        RefactoringDescriptorUtil.setString(arguments, attribute, RefactoringDescriptorUtil.resourcePathToHandle(project, resourcePath));
    }

    public static void setInt(Map<String, String> arguments, String attribute, int value) throws IllegalArgumentException {
        RefactoringDescriptorUtil.setString(arguments, attribute, Integer.toString(value));
    }

    public static void setBoolean(Map<String, String> arguments, String attribute, boolean value) throws IllegalArgumentException {
        RefactoringDescriptorUtil.setString(arguments, attribute, value ? LOWER_CASE_TRUE : LOWER_CASE_FALSE);
    }

    public static void setBooleanArray(Map<String, String> arguments, String countAttribute, String arrayAttribute, boolean[] value, int offset) {
        if (value == null) {
            throw new IllegalArgumentException("The values for arrayAttribute '" + arrayAttribute + "' may not be null");
        }
        if (countAttribute != null) {
            RefactoringDescriptorUtil.setInt(arguments, countAttribute, value.length);
        }
        int i = 0;
        while (i < value.length) {
            RefactoringDescriptorUtil.setBoolean(arguments, RefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset), value[i]);
            ++i;
        }
    }

    public static void setString(Map<String, String> arguments, String attribute, String value) throws IllegalArgumentException {
        if (attribute == null || "".equals(attribute) || attribute.indexOf(32) != -1) {
            throw new IllegalArgumentException("Attribute '" + attribute + "' is not valid: '" + value + "'");
        }
        if (value != null) {
            arguments.put(attribute, value);
        } else {
            arguments.remove(attribute);
        }
    }

    public static void setStringArray(Map<String, String> arguments, String countAttribute, String arrayAttribute, String[] value, int offset) {
        if (value == null) {
            throw new IllegalArgumentException("The values for arrayAttribute '" + arrayAttribute + "' may not be null");
        }
        if (countAttribute != null) {
            RefactoringDescriptorUtil.setInt(arguments, countAttribute, value.length);
        }
        int i = 0;
        while (i < value.length) {
            String string = value[i];
            RefactoringDescriptorUtil.setString(arguments, RefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset), string);
            ++i;
        }
    }

    public static void setSelection(Map<String, String> arguments, String attribute, int offset, int length) throws IllegalArgumentException {
        String value = Integer.toString(offset) + " " + Integer.toString(length);
        RefactoringDescriptorUtil.setString(arguments, attribute, value);
    }

    public static void setResourcePathArray(Map<String, String> arguments, String countAttribute, String arrayAttribute, String project, IPath[] resourcePaths, int offset) throws IllegalArgumentException {
        if (resourcePaths == null) {
            throw new IllegalArgumentException("The resources for arrayAttribute '" + arrayAttribute + "' may not be null");
        }
        if (countAttribute != null) {
            RefactoringDescriptorUtil.setInt(arguments, countAttribute, resourcePaths.length);
        }
        int i = 0;
        while (i < resourcePaths.length) {
            IPath resourcePath = resourcePaths[i];
            RefactoringDescriptorUtil.setResourcePath(arguments, RefactoringDescriptorUtil.getAttributeName(arrayAttribute, offset + i), project, resourcePath);
            ++i;
        }
    }

    public static void setModelElementArray(Map<String, String> arguments, String countAttribute, String arrayAttributePrefix, String project, IModelElement[] elements, int offset) throws IllegalArgumentException {
        if (elements == null) {
            throw new IllegalArgumentException("The elements for arrayAttribute '" + arrayAttributePrefix + "' may not be null");
        }
        if (countAttribute != null) {
            RefactoringDescriptorUtil.setInt(arguments, countAttribute, elements.length);
        }
        int i = 0;
        while (i < elements.length) {
            IModelElement element = elements[i];
            RefactoringDescriptorUtil.setModelElement(arguments, RefactoringDescriptorUtil.getAttributeName(arrayAttributePrefix, offset + i), project, element);
            ++i;
        }
    }
}

