/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import org.eclipse.emf.cdo.CDOLock;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.util.LockTimeoutException;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public class CDOLockImpl
implements CDOLock {
    public static final CDOLock NOOP = new NOOPLockImpl();
    private static final Set<CDOLockOwner> NO_OWNERS = Collections.emptySet();
    private final InternalCDOObject object;
    private final IRWLockManager.LockType type;

    public CDOLockImpl(InternalCDOObject object, IRWLockManager.LockType type) {
        this.object = object;
        this.type = type;
    }

    @Override
    public InternalCDOObject getObject() {
        return this.object;
    }

    @Override
    public IRWLockManager.LockType getType() {
        return this.type;
    }

    @Override
    public Set<CDOLockOwner> getOwners() {
        CDOLockState lockState = this.object.cdoLockState();
        switch (this.type) {
            case READ: {
                return lockState.getReadLockOwners();
            }
            case WRITE: {
                CDOLockOwner writeLockOwner = lockState.getWriteLockOwner();
                return writeLockOwner == null ? NO_OWNERS : Collections.singleton(writeLockOwner);
            }
            case OPTION: {
                CDOLockOwner writeOptionOwner = lockState.getWriteOptionOwner();
                return writeOptionOwner == null ? NO_OWNERS : Collections.singleton(writeOptionOwner);
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean isLocked() {
        return this.isLocked(false);
    }

    @Override
    public boolean isLockedByOthers() {
        return this.isLocked(true);
    }

    @Override
    public CDOLock.CDOAcquiredLock acquire(long time, TimeUnit unit, boolean recursive) throws TimeoutException {
        this.lock(time, unit, recursive);
        return new CDOAcquiredLockImpl(this, recursive);
    }

    @Override
    public void lock(long time, TimeUnit unit, boolean recursive) throws TimeoutException {
        try {
            if (!this.tryLock(time, unit, recursive)) {
                throw new TimeoutException();
            }
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    @Override
    public void lock(long time, TimeUnit unit) throws TimeoutException {
        this.lock(time, unit, false);
    }

    @Override
    public void lock(long millis) throws TimeoutException {
        this.lock(millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void lock() {
        try {
            this.lock(-1L);
        }
        catch (TimeoutException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit, boolean recursive) throws InterruptedException {
        try {
            InternalCDOView view = this.object.cdoView();
            view.lockObjects(Collections.singletonList(this.object), this.type, unit.toMillis(time), recursive);
            return true;
        }
        catch (LockTimeoutException ex) {
            return false;
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.tryLock(time, unit, false);
    }

    @Override
    public boolean tryLock(long millis) throws InterruptedException {
        return this.tryLock(millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(-1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    @Override
    public void unlock(boolean recursive) {
        InternalCDOView view = this.object.cdoView();
        view.unlockObjects(Collections.singletonList(this.object), this.type, recursive);
    }

    @Override
    public void unlock() {
        this.unlock(false);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return MessageFormat.format("CDOLock[object={0}, type={1}]", this.object, this.type);
    }

    private boolean isLocked(boolean others) {
        InternalCDOView view = this.object.cdoView();
        return view.isObjectLocked(this.object, this.type, others);
    }

    private static final class CDOAcquiredLockImpl
    implements CDOLock.CDOAcquiredLock {
        private final CDOLock lock;
        private final boolean recursive;

        public CDOAcquiredLockImpl(CDOLock lock, boolean recursive) {
            this.lock = lock;
            this.recursive = recursive;
        }

        @Override
        public CDOLock getLock() {
            return this.lock;
        }

        @Override
        public CDOObject getObject() {
            return this.lock.getObject();
        }

        @Override
        public IRWLockManager.LockType getType() {
            return this.lock.getType();
        }

        @Override
        public Set<CDOLockOwner> getOwners() {
            return this.lock.getOwners();
        }

        @Override
        public boolean isLocked() {
            return this.lock.isLocked();
        }

        @Override
        public boolean isLockedByOthers() {
            return this.lock.isLockedByOthers();
        }

        @Override
        public boolean isRecursive() {
            return this.recursive;
        }

        @Override
        public void close() {
            this.lock.unlock(this.recursive);
        }
    }

    public static final class NOOPLockImpl
    implements CDOLock {
        private NOOPLockImpl() {
        }

        @Override
        public CDOObject getObject() {
            return null;
        }

        @Override
        public IRWLockManager.LockType getType() {
            return null;
        }

        @Override
        public boolean isLocked() {
            return false;
        }

        @Override
        public boolean isLockedByOthers() {
            return false;
        }

        @Override
        public Set<CDOLockOwner> getOwners() {
            return NO_OWNERS;
        }

        @Override
        public CDOLock.CDOAcquiredLock acquire(long time, TimeUnit unit, boolean recursive) throws TimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void lock(long time, TimeUnit unit, boolean recursive) throws TimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void lock(long time, TimeUnit unit) throws TimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void lock(long millis) throws TimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void lock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit, boolean recursive) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long millis) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock(boolean recursive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

