/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.util;

import java.util.Objects;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.lm.reviews.Authorable;
import org.eclipse.emf.cdo.lm.reviews.Comment;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.Topic;
import org.eclipse.emf.cdo.lm.reviews.util.ReviewsOperations;
import org.eclipse.emf.cdo.lm.util.LMOperationAuthorizer;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.ContextOperationAuthorization;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.security.operations.AuthorizableOperation;

public abstract class ReviewsOperationAuthorizer
extends LMOperationAuthorizer
implements ReviewsOperations {
    protected Object authorizeAuthor(CDOSession session, AuthorizableOperation operation) {
        EObject context = ContextOperationAuthorization.getContext((AuthorizableOperation)operation);
        if (context instanceof Authorable) {
            String author = ((Authorable)context).getAuthor();
            return Objects.equals(author, session.getUserID()) ? GRANTED : "Not the author";
        }
        return null;
    }

    public static Review getContextReview(AuthorizableOperation operation) {
        EObject object = ContextOperationAuthorization.getContext((AuthorizableOperation)operation);
        return (Review)EMFUtil.getNearestObject((EObject)object, Review.class);
    }

    public static Topic getContextTopic(AuthorizableOperation operation) {
        EObject object = ContextOperationAuthorization.getContext((AuthorizableOperation)operation);
        return (Topic)EMFUtil.getNearestObject((EObject)object, Topic.class);
    }

    public static Comment getContextComment(AuthorizableOperation operation) {
        EObject object = ContextOperationAuthorization.getContext((AuthorizableOperation)operation);
        return (Comment)EMFUtil.getNearestObject((EObject)object, Comment.class);
    }
}

