/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.migrator;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.commons.notifications.feed.ServiceMessage;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TaskListBackupManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteAction;
import org.eclipse.mylyn.internal.tasks.ui.migrator.CompleteConnectorMigrationWizard;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrationWizard;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrator;
import org.eclipse.mylyn.internal.tasks.ui.migrator.Messages;
import org.eclipse.mylyn.internal.tasks.ui.migrator.TaskPredicates;
import org.eclipse.mylyn.internal.tasks.ui.migrator.TasksState;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDataSnapshotOperation;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConnectorMigrationUi {
    private static final String MIGRATE = "migrate";
    private static final String COMLETE_MIGRATION = "complete-migration";
    private final TaskListView taskListView;
    private final TaskListBackupManager backupManager;
    private final TasksState tasksState;

    public ConnectorMigrationUi(TaskListView taskListView, TaskListBackupManager backupManager, TasksState tasksState) {
        this.taskListView = taskListView;
        this.backupManager = backupManager;
        this.tasksState = tasksState;
    }

    public void promptToMigrate(final ConnectorMigrator migrator) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.taskListView != null && this.taskListView.getServiceMessageControl() != null) {
                ServiceMessage message = new ServiceMessage(""){

                    public boolean openLink(String link) {
                        if (link.equals(ConnectorMigrationUi.MIGRATE) && ConnectorMigrationUi.this.createMigrationWizard(migrator).open() == 0) {
                            ConnectorMigrationUi.this.createPromptToCompleteMigrationJob(migrator).schedule();
                            return true;
                        }
                        return false;
                    }
                };
                message.setTitle(Messages.ConnectorMigrationUi_End_of_Connector_Support);
                message.setDescription(NLS.bind((String)Messages.ConnectorMigrator_complete_migration_prompt_message, (Object)MIGRATE));
                message.setImage("dialog_messasge_info_image");
                this.taskListView.getServiceMessageControl().setMessage(message);
            }
        });
    }

    protected Job createPromptToCompleteMigrationJob(ConnectorMigrator migrator) {
        CompleteMigrationJob job = new CompleteMigrationJob(Messages.ConnectorMigrationUi_Complete_Connector_Migration_Prompt, migrator);
        job.setUser(false);
        job.setSystem(true);
        return job;
    }

    protected WizardDialog createMigrationWizard(ConnectorMigrator migrator) {
        return this.createWizardDialog(new ConnectorMigrationWizard(migrator));
    }

    protected WizardDialog createCompleteMigrationWizard(ConnectorMigrator migrator) {
        return this.createWizardDialog(new CompleteConnectorMigrationWizard(migrator));
    }

    protected WizardDialog createWizardDialog(Wizard wizard) {
        WizardDialog dialog = new WizardDialog(WorkbenchUtil.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        return dialog;
    }

    protected int getCompletionPromptFrequency() {
        return 5;
    }

    public void warnOfValidationFailure(List<TaskRepository> failedValidation) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            String repositoryList = failedValidation.stream().map(ConnectorMigrationUi.repositoryToLabel()).collect(Collectors.joining("\n"));
            MessageDialog.openWarning((Shell)WorkbenchUtil.getShell(), (String)Messages.ConnectorMigrationUi_Validation_Failed, (String)NLS.bind((String)Messages.ConnectorMigrationWizard_validation_failed, (Object)repositoryList));
        });
    }

    private static Function<TaskRepository, String> repositoryToLabel() {
        return TaskRepository::getRepositoryLabel;
    }

    protected void backupTaskList(IProgressMonitor monitor) throws IOException {
        try {
            monitor.subTask(Messages.ConnectorMigrationUi_Backing_up_task_list);
            String backupFolder = TasksUiPlugin.getDefault().getBackupFolderPath();
            new File(backupFolder).mkdirs();
            String fileName = this.getBackupFileName(new Date());
            new TaskDataSnapshotOperation(backupFolder, fileName).run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> this.backupManager.backupNow(true));
            monitor.worked(1);
        }
        catch (InvocationTargetException e) {
            throw (IOException)e.getCause();
        }
    }

    protected String getBackupFileName(Date date) {
        return "connector-migration-" + new SimpleDateFormat("yyyy_MM_dd_HHmmss").format(date) + ".zip";
    }

    protected void delete(Set<ITask> tasks, TaskRepository repository, TaskRepository newRepository, IProgressMonitor monitor) {
        Set queries = this.tasksState.getTaskList().getQueries().stream().filter(TaskPredicates.isQueryForRepository(repository)).collect(Collectors.toUnmodifiableSet());
        UnsubmittedTaskContainer unsubmitted = this.tasksState.getTaskList().getUnsubmittedContainer(repository.getRepositoryUrl());
        try {
            monitor.subTask(Messages.ConnectorMigrationUi_Deleting_old_repository_tasks_and_queries);
            try {
                DeleteAction.prepareDeletion(tasks);
                if (unsubmitted != null) {
                    DeleteAction.prepareDeletion(unsubmitted.getChildren());
                }
                DeleteAction.prepareDeletion(queries);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e));
            }
            this.tasksState.getTaskList().run(monitor1 -> {
                for (ITask task : tasks) {
                    this.delete(task);
                }
                if (unsubmitted != null) {
                    for (ITask task : unsubmitted.getChildren()) {
                        this.delete(task);
                    }
                }
                DeleteAction.performDeletion(queries);
                HashMap<AuthenticationType, AuthenticationCredentials> credentialsMap = new HashMap<AuthenticationType, AuthenticationCredentials>();
                AuthenticationType[] authenticationTypeArray = AuthenticationType.values();
                int n = authenticationTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AuthenticationType type = authenticationTypeArray[n2];
                    AuthenticationCredentials credentials = repository.getCredentials(type);
                    if (credentials != null) {
                        credentialsMap.put(type, credentials);
                    }
                    ++n2;
                }
                this.tasksState.getRepositoryManager().removeRepository(repository);
                for (AuthenticationType type : credentialsMap.keySet()) {
                    newRepository.setCredentials(type, (AuthenticationCredentials)credentialsMap.get(type), newRepository.getSavePassword(type));
                }
            }, monitor);
            this.tasksState.getRepositoryModel().clear();
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.ConnectorMigrationUi_Error_deleting_task, (Throwable)e));
        }
    }

    protected void delete(ITask task) {
        this.tasksState.getTaskList().deleteTask(task);
        try {
            this.tasksState.getTaskDataManager().deleteTaskData(task);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to delete task data", (Throwable)e));
        }
    }

    public void notifyMigrationComplete() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openInformation((Shell)WorkbenchUtil.getShell(), (String)Messages.ConnectorMigrationUi_Connector_Migration_Complete, (String)Messages.ConnectorMigrationUi_Connector_migration_completed_successfully_You_may_resume_using_the_task_list));
    }

    protected class CompleteMigrationJob
    extends Job {
        private boolean finishedCompleteMigrationWizard;
        private final ConnectorMigrator migrator;

        private CompleteMigrationJob(String name, ConnectorMigrator migrator) {
            super(name);
            this.migrator = migrator;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!this.finishedCompleteMigrationWizard) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    if (ConnectorMigrationUi.this.taskListView != null && ConnectorMigrationUi.this.taskListView.getServiceMessageControl() != null) {
                        ServiceMessage message = new ServiceMessage(""){

                            public boolean openLink(String link) {
                                if (link.equals(ConnectorMigrationUi.COMLETE_MIGRATION) && ConnectorMigrationUi.this.createCompleteMigrationWizard(CompleteMigrationJob.this.migrator).open() == 0) {
                                    CompleteMigrationJob.this.finishedCompleteMigrationWizard = true;
                                    return true;
                                }
                                return false;
                            }
                        };
                        message.setTitle(Messages.ConnectorMigrationUi_Connector_Migration);
                        message.setDescription(NLS.bind((String)Messages.ConnectorMigrator_complete_migration_prompt_title, (Object)ConnectorMigrationUi.COMLETE_MIGRATION));
                        message.setImage("dialog_messasge_warning_image");
                        ConnectorMigrationUi.this.taskListView.getServiceMessageControl().setMessage(message);
                    }
                });
                this.schedule(TimeUnit.MILLISECONDS.convert(ConnectorMigrationUi.this.getCompletionPromptFrequency(), TimeUnit.SECONDS));
            }
            return Status.OK_STATUS;
        }

        public void dispose() {
            this.finishedCompleteMigrationWizard = true;
        }
    }
}

