/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.etypes.provider.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.edit.CDOEditPlugin;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.etypes.AnnotationValidator;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.etypes.provider.AnnotationItemProvider;
import org.eclipse.emf.cdo.etypes.provider.EtypesItemProviderAdapterFactory;
import org.eclipse.emf.cdo.etypes.provider.StringToStringMapEntryItemProvider;
import org.eclipse.emf.cdo.etypes.util.BasicAnnotationValidator;
import org.eclipse.emf.cdo.etypes.util.EtypesSwitch;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.net4j.util.container.IPluginContainer;

public abstract class AnnotationItemProviderAdapterFactory
extends AdapterFactoryImpl
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.edit.annotationItemProviderAdapterFactories";
    protected final IChangeNotifier changeNotifier = new ChangeNotifier();
    protected final Collection<Object> supportedTypes = new ArrayList<Object>();
    protected final Disposable disposable = new Disposable();
    protected final EtypesSwitch<Adapter> modelSwitch = new EtypesSwitch<Adapter>(){

        public Adapter caseAnnotation(Annotation object) {
            return AnnotationItemProviderAdapterFactory.this.createAnnotationAdapter();
        }

        public Adapter caseStringToStringMapEntry(Map.Entry<String, String> object) {
            return AnnotationItemProviderAdapterFactory.this.createStringToStringMapEntryAdapter();
        }
    };
    protected final BasicAnnotationValidator.Assistant assistant;
    protected final ResourceLocator resourceLocator;
    protected EtypesItemProviderAdapterFactory etypesItemProviderAdapterFactory;
    protected Adapter annotationItemProvider;
    protected Adapter stringToStringMapEntryItemProvider;

    public AnnotationItemProviderAdapterFactory(ResourceLocator resourceLocator, BasicAnnotationValidator.Assistant assistant) {
        this.resourceLocator = resourceLocator;
        this.assistant = assistant;
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public BasicAnnotationValidator.Assistant getAssistant() {
        return this.assistant;
    }

    public boolean isShowInstances(Annotation annotation) {
        return this.assistant.getPropertyClasses(annotation.getModelElement()).size() > 1;
    }

    public Adapter createAnnotationAdapter() {
        if (this.annotationItemProvider == null) {
            this.annotationItemProvider = this.doCreateAnnotationAdapter();
        }
        return this.annotationItemProvider;
    }

    protected Adapter doCreateAnnotationAdapter() {
        return new AnnotationItemProvider((AdapterFactory)this);
    }

    public Adapter createStringToStringMapEntryAdapter() {
        if (this.stringToStringMapEntryItemProvider == null) {
            this.stringToStringMapEntryItemProvider = this.doCreateStringToStringMapEntryAdapter();
        }
        return this.stringToStringMapEntryItemProvider;
    }

    protected Adapter doCreateStringToStringMapEntryAdapter() {
        return new StringToStringMapEntryItemProvider((AdapterFactory)this);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.etypesItemProviderAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        throw new UnsupportedOperationException("This factory must not be directly a child in a composed adapter factory");
    }

    public void setParentAdapterFactory(EtypesItemProviderAdapterFactory etypesItemProviderAdapterFactory) {
        this.etypesItemProviderAdapterFactory = etypesItemProviderAdapterFactory;
    }

    public ResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || type == EtypesPackage.eINSTANCE;
    }

    protected Adapter createAdapter(Notifier target) {
        return (Adapter)this.modelSwitch.doSwitch((EObject)target);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    protected void associate(Adapter adapter, Notifier target) {
        super.associate(adapter, target);
        if (adapter instanceof IDisposable) {
            this.disposable.add((Object)adapter);
        }
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        this.etypesItemProviderAdapterFactory.fireNotifyChanged(notification);
    }

    public void dispose() {
        this.disposable.dispose();
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(EObject eObject, Annotation annotation, ResourceLocator resourceLocator) {
        ArrayList<DecategorizingItemPropertyDescritorDecorator> result = new ArrayList<DecategorizingItemPropertyDescritorDecorator>();
        EClass eClass = eObject.eClass();
        Map properties = this.assistant.getApplicableProperties(eObject, annotation);
        EList eAllStructuralFeatures = eClass.getEAllStructuralFeatures();
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)annotation);
        for (Map.Entry entry : properties.entrySet()) {
            IItemPropertyDescriptor propertyDescriptor;
            String key = (String)entry.getKey();
            EStructuralFeature eStructuralFeature = (EStructuralFeature)entry.getValue();
            if (!eAllStructuralFeatures.contains((Object)eStructuralFeature) || (propertyDescriptor = this.getPropertyDescriptor(eObject, key, eStructuralFeature, annotation, resourceLocator)) == null) continue;
            IItemPropertyDescriptor decoratedPropertyDescriptor = this.createPropertyDescriptorDecorator(propertyDescriptor, eObject, key, eStructuralFeature, annotation, resourceLocator, domain);
            result.add(new DecategorizingItemPropertyDescritorDecorator(eObject, decoratedPropertyDescriptor));
        }
        return Collections.unmodifiableList(result);
    }

    public IItemPropertyDescriptor getPropertyDescriptor(EObject eObject, String key, EStructuralFeature eStructuralFeature, Annotation annotation, ResourceLocator resourceLocator) {
        IItemPropertySource itemPropertySource = (IItemPropertySource)this.getRootAdapterFactory().adapt((Notifier)eObject, IItemPropertySource.class);
        return itemPropertySource == null ? null : itemPropertySource.getPropertyDescriptor((Object)eObject, (Object)eStructuralFeature);
    }

    public IItemPropertyDescriptor createPropertyDescriptorDecorator(IItemPropertyDescriptor propertyDescriptor, EObject eObject, String key, EStructuralFeature eStructuralFeature, Annotation annotation, ResourceLocator resourceLocator, EditingDomain domain) {
        return new ModeledItemPropertyDescriptorDecorator(propertyDescriptor, eObject, key, eStructuralFeature, annotation, resourceLocator, domain, this.getAssistant());
    }

    public String getGroupName(EObject instance) {
        String groupName = this.getResourceLocator().getString("_UI_" + instance.eClass().getName() + "_type");
        return groupName;
    }

    public static AnnotationItemProviderAdapterFactory create(String annotationSoure) {
        return (AnnotationItemProviderAdapterFactory)((Object)IPluginContainer.INSTANCE.getElementOrNull(PRODUCT_GROUP, annotationSoure));
    }

    public static final class DecategorizingItemPropertyDescritorDecorator
    extends ItemPropertyDescriptorDecorator {
        public DecategorizingItemPropertyDescritorDecorator(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            super(object, itemPropertyDescriptor);
        }

        public String getCategory(Object thisObject) {
            return null;
        }

        public String getCategory() {
            return super.getCategory(this.object);
        }
    }

    public static final class Group
    implements IItemPropertySource {
        protected Object propertyValue;
        protected final List<IItemPropertyDescriptor> itemPropertyDescriptors = new ArrayList<IItemPropertyDescriptor>();

        public Group(Object propertyValue) {
            this.propertyValue = propertyValue;
        }

        public void add(IItemPropertyDescriptor propertyDescriptor) {
            this.itemPropertyDescriptors.add(propertyDescriptor);
        }

        public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
            return this.itemPropertyDescriptors;
        }

        public List<IItemPropertyDescriptor> getPropertyDescriptors() {
            return this.itemPropertyDescriptors;
        }

        public IItemPropertyDescriptor getPropertyDescriptor(Object object, Object propertyID) {
            for (IItemPropertyDescriptor itemPropertyDescriptor : this.getPropertyDescriptors(object)) {
                if (!propertyID.equals(itemPropertyDescriptor.getId(object)) && !propertyID.equals(itemPropertyDescriptor.getFeature(object))) continue;
                return itemPropertyDescriptor;
            }
            return null;
        }

        public Object getEditableValue(Object object) {
            return this.propertyValue;
        }

        public String toString() {
            return this.propertyValue == null ? "null" : this.propertyValue.toString();
        }
    }

    public static class ModeledItemPropertyDescriptorDecorator
    extends ItemPropertyDescriptorDecorator {
        protected final String key;
        protected final EStructuralFeature eStructuralFeature;
        protected final Annotation annotation;
        protected final EditingDomain domain;
        protected final BasicAnnotationValidator.Assistant assistant;

        public ModeledItemPropertyDescriptorDecorator(IItemPropertyDescriptor propertyDescriptor, EObject eObject, String key, EStructuralFeature eStructuralFeature, Annotation annotation, ResourceLocator resourceLocator, EditingDomain domain, BasicAnnotationValidator.Assistant assistant) {
            super((Object)eObject, propertyDescriptor);
            this.key = key;
            this.eStructuralFeature = eStructuralFeature;
            this.annotation = annotation;
            this.domain = domain;
            this.assistant = assistant;
        }

        public boolean canSetProperty(Object object) {
            Resource resource = this.annotation.eResource();
            return resource != null && !this.domain.isReadOnly(resource);
        }

        public boolean isPropertySet(Object thisObject) {
            EMap details = this.annotation.getDetails();
            return details.get((Object)this.key) != null;
        }

        public boolean isPropertyUnsettable(Object object) {
            EMap details = this.annotation.getDetails();
            return details.get((Object)this.key) == null && this.getPropertyValue(object) != null;
        }

        public void resetPropertyValue(Object thisObject) {
            EMap details = this.annotation.getDetails();
            for (Map.Entry entry : details) {
                if (!this.key.equals(entry.getKey())) continue;
                this.domain.getCommandStack().execute(RemoveCommand.create((EditingDomain)this.domain, (Object)this.annotation, (Object)EtypesPackage.Literals.ANNOTATION__DETAILS, (Object)entry));
                return;
            }
        }

        public void setPropertyValue(Object object, Object value) {
            Object entry2;
            String literal = this.assistant.convertPropertyValueToLiteral((EObject)this.object, this.eStructuralFeature, value);
            EMap details = this.annotation.getDetails();
            for (Object entry2 : details) {
                if (!this.key.equals(entry2.getKey())) continue;
                String entryValue = (String)entry2.getValue();
                if (entryValue == null ? literal != null : !entryValue.equals(literal)) {
                    this.domain.getCommandStack().execute(SetCommand.create((EditingDomain)this.domain, (Object)entry2, (Object)EtypesPackage.Literals.STRING_TO_STRING_MAP_ENTRY__VALUE, (Object)literal));
                }
                return;
            }
            entry2 = EcoreUtil.create((EClass)EtypesPackage.Literals.STRING_TO_STRING_MAP_ENTRY);
            entry2.eSet((EStructuralFeature)EtypesPackage.Literals.STRING_TO_STRING_MAP_ENTRY__KEY, (Object)this.key);
            entry2.eSet((EStructuralFeature)EtypesPackage.Literals.STRING_TO_STRING_MAP_ENTRY__VALUE, (Object)literal);
            this.domain.getCommandStack().execute(AddCommand.create((EditingDomain)this.domain, (Object)this.annotation, (Object)EtypesPackage.Literals.ANNOTATION__DETAILS, (Object)entry2));
        }
    }

    public static class Reflective
    extends AnnotationItemProviderAdapterFactory {
        private static BasicAnnotationValidator.Assistant getAssistant(String annotationSource) {
            AnnotationValidator eAnnotationValidator = AnnotationValidator.Registry.INSTANCE.getAnnotationValidator(annotationSource);
            if (eAnnotationValidator instanceof BasicAnnotationValidator) {
                return ((BasicAnnotationValidator)eAnnotationValidator).getAssistant();
            }
            throw new RuntimeException("There is no BasicAnnotationValidator validator registered for " + annotationSource);
        }

        public Reflective(String annotationSource) {
            super((ResourceLocator)CDOEditPlugin.INSTANCE, Reflective.getAssistant(annotationSource));
        }

        @Override
        public String getGroupName(EObject instance) {
            return NameHelper.INSTANCE.getTypeText(instance);
        }

        private static class NameHelper
        extends ReflectiveItemProvider {
            private static final NameHelper INSTANCE = new NameHelper();

            private NameHelper() {
                super(null);
            }

            public String getTypeText(Object object) {
                return super.getTypeText(object);
            }
        }
    }
}

