/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.distribute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.requests.DistributeRequest;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public class DistributeAction
extends DiagramAction {
    public static final int GAPS_HORIZONTALLY = 0;
    public static final int CENTERS_HORIZONTALLY = 1;
    public static final int GAPS_VERTICALLY = 2;
    public static final int CENTERS_VERTICALLY = 3;
    private int distributeType;

    protected DistributeAction(IWorkbenchPage workbenchPage, int distributeType, boolean isToolbarItem) {
        super(workbenchPage);
        this.distributeType = distributeType;
        this.setText(DistributeAction.getLabel(distributeType, isToolbarItem));
        this.setToolTipText(DistributeAction.getTooltip(distributeType));
    }

    public static String getLabel(int distributeType, boolean isToolbarItem) {
        String label = "";
        switch (distributeType) {
            case 0: {
                label = Messages.DistributeAction_gapsHorizontallyLabel;
                break;
            }
            case 1: {
                label = Messages.DistributeAction_centersHorizontallyLabel;
                break;
            }
            case 2: {
                label = Messages.DistributeAction_gapsVerticallyLabel;
                break;
            }
            case 3: {
                label = Messages.DistributeAction_centersVerticallyLabel;
                break;
            }
        }
        if (isToolbarItem && !"".equals(label)) {
            switch (distributeType) {
                case 0: {
                    label = Messages.DistributeAction_distributeGapsHorizontallyLabel;
                    break;
                }
                case 1: {
                    label = Messages.DistributeAction_distributeCentersHorizontallyLabel;
                    break;
                }
                case 2: {
                    label = Messages.DistributeAction_distributeGapsVerticallyLabel;
                    break;
                }
                case 3: {
                    label = Messages.DistributeAction_distributeCentersVerticallyLabel;
                    break;
                }
            }
        }
        return label;
    }

    public static String getTooltip(int distributeType) {
        String tooltip = "";
        switch (distributeType) {
            case 0: {
                tooltip = Messages.DistributeAction_distributeGapsHorizontallyTooltip;
                break;
            }
            case 1: {
                tooltip = Messages.DistributeAction_distributeCentersHorizontallyTooltip;
                break;
            }
            case 2: {
                tooltip = Messages.DistributeAction_distributeGapsVerticallyTooltip;
                break;
            }
            case 3: {
                tooltip = Messages.DistributeAction_distributeCentersVerticallyTooltip;
                break;
            }
        }
        return tooltip;
    }

    public static DistributeAction createDistributeHorizontallyWithUniformGapsAction(IWorkbenchPage workbenchPage, boolean isToolbarItem) {
        DistributeAction action = new DistributeAction(workbenchPage, 0, isToolbarItem);
        action.setId("distributeGapsHorizontally");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/distributeWithUniformGapHorizontal.gif");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static DistributeAction createDistributeCentersHorizontallyAction(IWorkbenchPage workbenchPage, boolean isToolbarItem) {
        DistributeAction action = new DistributeAction(workbenchPage, 1, isToolbarItem);
        action.setId("distributeCentersHorizontally");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/distributeCentersHorizontal.gif");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static DistributeAction createDistributeVerticallyWithUniformGapsAction(IWorkbenchPage workbenchPage, boolean isToolbarItem) {
        DistributeAction action = new DistributeAction(workbenchPage, 2, isToolbarItem);
        action.setId("distributeGapsVertically");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/distributeWithUniformGapVertical.gif");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static DistributeAction createDistributeCentersVerticallyAction(IWorkbenchPage workbenchPage, boolean isToolbarItem) {
        DistributeAction action = new DistributeAction(workbenchPage, 3, isToolbarItem);
        action.setId("distributeCentersVertically");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/distributeCentersVertical.gif");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    protected Request createTargetRequest() {
        DistributeRequest distributionRequest = new DistributeRequest();
        distributionRequest.setDistributeType(this.distributeType);
        return distributionRequest;
    }

    protected void updateTargetRequest() {
        DistributeRequest distributionRequest = (DistributeRequest)this.getTargetRequest();
        distributionRequest.setDistributeType(this.distributeType);
        distributionRequest.setEditParts(this.getOperationSet());
    }

    protected Command getCommand() {
        EditPart targetEP;
        Command cmd = null;
        List operationSet = this.getOperationSet();
        if (!operationSet.isEmpty() && (targetEP = this.getTargetEditPartForDistributeSelection(operationSet)) != null) {
            cmd = targetEP.getCommand(this.getTargetRequest());
        }
        return cmd;
    }

    protected List<?> createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            selection = Collections.EMPTY_LIST;
        } else {
            selection = ToolUtilities.getSelectionWithoutDependants(selection.stream().filter(EditPart.class::isInstance).map(EditPart.class::cast).toList());
            if ((selection = Lists.newArrayList((Iterable)Iterables.filter((Iterable)selection, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(ConnectionEditPart.class))))).size() < 3) {
                selection = Collections.EMPTY_LIST;
            } else {
                EditPart parent = ((EditPart)selection.get(0)).getParent();
                int sideOfFirstSelection = 0;
                boolean isEdgeLabel = false;
                if (selection.get(0) instanceof IBorderItemEditPart) {
                    sideOfFirstSelection = ((IBorderItemEditPart)selection.get(0)).getBorderItemLocator().getCurrentSideOfParent();
                    if (!this.isHorizontalAxisAuthorizedForBorderNode(sideOfFirstSelection) && !this.isVerticalAxisAuthorizedForBorderNode(sideOfFirstSelection)) {
                        selection = Collections.EMPTY_LIST;
                    }
                } else if (selection.get(0) instanceof AbstractDEdgeNameEditPart) {
                    isEdgeLabel = true;
                }
                int i = 1;
                while (i < selection.size()) {
                    EditPart part = (EditPart)selection.get(i);
                    if (isEdgeLabel) {
                        if (!(part instanceof AbstractDEdgeNameEditPart)) {
                            selection = Collections.EMPTY_LIST;
                            break;
                        }
                    } else {
                        EditPartQuery containerLayoutQuery;
                        if (part instanceof AbstractDEdgeNameEditPart) {
                            selection = Collections.EMPTY_LIST;
                            break;
                        }
                        if (part.getParent() != parent) {
                            selection = Collections.EMPTY_LIST;
                            break;
                        }
                        if (sideOfFirstSelection != 0 && !this.isABorderNodeOnSameAxis(part, sideOfFirstSelection)) {
                            selection = Collections.EMPTY_LIST;
                            break;
                        }
                        if (part instanceof IGraphicalEditPart && !(containerLayoutQuery = new EditPartQuery((IGraphicalEditPart)part)).isFreeFormContainerChildrenPresentation()) {
                            selection = Collections.EMPTY_LIST;
                            break;
                        }
                    }
                    ++i;
                }
            }
        }
        return selection;
    }

    private boolean isHorizontalAxisAuthorizedForBorderNode(int side) {
        return this.isOnHorizontalAxis(side) && (this.distributeType == 0 || this.distributeType == 1);
    }

    private boolean isVerticalAxisAuthorizedForBorderNode(int side) {
        return this.isOnVerticalAxis(side) && (this.distributeType == 2 || this.distributeType == 3);
    }

    private boolean isABorderNodeOnSameAxis(EditPart part, int expectedSide) {
        boolean result = false;
        if (part instanceof IBorderItemEditPart) {
            int currentSide = ((IBorderItemEditPart)part).getBorderItemLocator().getCurrentSideOfParent();
            if (this.isOnHorizontalAxis(expectedSide) && this.isOnHorizontalAxis(currentSide) || this.isOnVerticalAxis(expectedSide) && this.isOnVerticalAxis(currentSide)) {
                result = true;
            }
        }
        return result;
    }

    private boolean isOnHorizontalAxis(int side) {
        return side == 1 || side == 4;
    }

    private boolean isOnVerticalAxis(int side) {
        return side == 16 || side == 8;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected boolean isOperationHistoryListener() {
        return true;
    }

    private EditPart getTargetEditPartForDistributeSelection(List<?> editparts) {
        EditPart result = null;
        EditPart firstEditPart = (EditPart)editparts.get(0);
        if (firstEditPart instanceof AbstractDEdgeNameEditPart) {
            IEditorPart activeEditor;
            if (this.getDiagramGraphicalViewer() != null && (activeEditor = this.getWorkbenchPage().getActiveEditor()) instanceof SiriusDiagramEditor) {
                result = ((SiriusDiagramEditor)activeEditor).getDiagramEditPart();
            }
        } else {
            result = firstEditPart.getParent();
            int i = 1;
            while (i < editparts.size() && result != null) {
                EditPart part = (EditPart)editparts.get(i);
                if (part.getParent() != result) {
                    result = null;
                }
                ++i;
            }
        }
        return result;
    }
}

