/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.operations;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.spi.GetBuildsRequest;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.operations.AbstractElementOperation;
import org.eclipse.mylyn.builds.internal.core.operations.BuildJob;
import org.eclipse.mylyn.builds.internal.core.operations.IOperationService;
import org.eclipse.mylyn.builds.internal.core.operations.Messages;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.osgi.util.NLS;

public class GetBuildsOperation
extends AbstractElementOperation<IBuildPlan> {
    private List<IBuild> builds;
    private final GetBuildsRequest request;
    private final BuildServer server;

    public GetBuildsOperation(IOperationService service, GetBuildsRequest request) {
        super(service);
        Assert.isNotNull((Object)request);
        Assert.isNotNull((Object)request.getPlan());
        Assert.isNotNull((Object)request.getPlan().getServer());
        this.request = request;
        this.server = (BuildServer)request.getPlan().getServer();
    }

    @Override
    protected BuildJob doCreateJob(IBuildPlan element) {
        return new BuildJob(NLS.bind((String)Messages.GetBuildsOperation_buildFor, (Object)element.getLabel())){

            @Override
            protected IStatus doExecute(IOperationMonitor progress) {
                MultiStatus result = new MultiStatus("org.eclipse.mylyn.builds.core", 0, Messages.GetBuildsOperation_retrieveFailed, null);
                try {
                    GetBuildsOperation.this.builds = GetBuildsOperation.this.server.getBehaviour().getBuilds(GetBuildsOperation.this.request, progress);
                }
                catch (CoreException e) {
                    result.add((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", NLS.bind((String)Messages.GetBuildsOperation_buildRetrieveFailed, (Object)GetBuildsOperation.this.request.getPlan().getName()), (Throwable)e));
                }
                catch (OperationCanceledException e) {
                    return Status.CANCEL_STATUS;
                }
                this.setStatus((IStatus)result);
                return Status.OK_STATUS;
            }
        };
    }

    @Override
    protected List<IBuildPlan> doSyncInitInput() {
        return Collections.singletonList(this.request.getPlan());
    }

    public List<IBuild> getBuilds() {
        return this.builds;
    }
}

