/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures.GeoShapePolygonFigure;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PrecisionPointList;

public class GeoShapePentagonFigure
extends GeoShapePolygonFigure {
    private static final double WIDTH_FACTOR = 2.0 * Math.sin(1.2566370614359172) / (1.0 + Math.cos(0.6283185307179586));
    private static final double BOTTOM_OFFSET_FACTOR = 1.0 / (4.0 * Math.cos(0.6283185307179586));
    private static final double SIDE_OFFSET_FACTOR = (1.0 - Math.cos(1.2566370614359172)) / (1.0 + Math.cos(0.6283185307179586));

    public GeoShapePentagonFigure(int width, int height, int spacing) {
        super(width, height, spacing);
    }

    public GeoShapePentagonFigure(int height, int spacing) {
        this((int)Math.round(WIDTH_FACTOR * (double)height), height, spacing);
    }

    @Override
    protected PointList calculatePoints(Rectangle rect) {
        PrecisionPointList points = new PrecisionPointList();
        PrecisionPoint p1 = new PrecisionPoint(rect.preciseX() + rect.preciseWidth() / 2.0, rect.preciseY());
        PrecisionPoint p2 = new PrecisionPoint(rect.preciseX() + rect.preciseWidth() - 1.0, rect.preciseY() + rect.preciseHeight() * SIDE_OFFSET_FACTOR);
        PrecisionPoint p3 = new PrecisionPoint(rect.preciseX() + rect.preciseWidth() * (0.5 + BOTTOM_OFFSET_FACTOR), rect.preciseY() + rect.preciseHeight() - 1.0);
        PrecisionPoint p4 = new PrecisionPoint(rect.preciseX() + rect.preciseWidth() * (0.5 - BOTTOM_OFFSET_FACTOR), p3.preciseY());
        PrecisionPoint p5 = new PrecisionPoint(rect.preciseX(), p2.preciseY());
        points.addPoint((Point)p1);
        points.addPoint((Point)p2);
        points.addPoint((Point)p3);
        points.addPoint((Point)p4);
        points.addPoint((Point)p5);
        points.addPoint((Point)p1);
        return points;
    }
}

