/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.views;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.ui.actions.RefreshAction;
import org.eclipse.emf.ecoretools.ui.actions.ToggleSynchronizeAction;
import org.eclipse.emf.ecoretools.ui.views.EcoreToolsViewsDragTargetAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class AnalysisView
extends ViewPart
implements ISelectionListener {
    private static final Transfer TRANSFER = LocalSelectionTransfer.getTransfer();
    private EObject lastValidObject;
    private EObject analyzedObject;
    private boolean isSynchronized = false;
    private ToggleSynchronizeAction toggleSynchroAction;
    private RefreshAction refreshAction;

    public AnalysisView() {
        ISelectionService selService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        selService.addSelectionListener((ISelectionListener)this);
        this.toggleSynchroAction = new ToggleSynchronizeAction(this);
        this.refreshAction = new RefreshAction(this);
    }

    public void dispose() {
        ISelectionService selService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        selService.removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    protected EObject getAnalyzedObject() {
        return this.analyzedObject;
    }

    public void setAnalyzedObject(EObject obj) {
        if (obj != null) {
            this.analyzedObject = obj;
            this.refresh(this.analyzedObject);
        }
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(boolean synchro) {
        this.isSynchronized = synchro;
    }

    protected EObject getActiveSelection() {
        ISelectionService selService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        if (selService.getSelection() instanceof IStructuredSelection) {
            return this.getSelection((IStructuredSelection)selService.getSelection());
        }
        return null;
    }

    protected EObject getSelection(IStructuredSelection selection) {
        Object selectedObject = selection.getFirstElement();
        if (selectedObject != null) {
            Object adaptedObj;
            Object adaptedObj2;
            if (selectedObject instanceof EObject) {
                return (EObject)selectedObject;
            }
            if (selectedObject instanceof IAdaptable && (adaptedObj2 = ((IAdaptable)selectedObject).getAdapter(EObject.class)) instanceof EObject) {
                return (EObject)adaptedObj2;
            }
            IAdapterManager adapterManager = Platform.getAdapterManager();
            if (adapterManager.hasAdapter(selectedObject, EObject.class.getName()) && (adaptedObj = adapterManager.loadAdapter(selectedObject, EObject.class.getName())) instanceof EObject) {
                return (EObject)adaptedObj;
            }
        }
        return null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            EObject selectedObject = this.getSelection((IStructuredSelection)selection);
            if (selectedObject != null) {
                this.lastValidObject = selectedObject;
            }
            if (this.isSynchronized()) {
                this.setAnalyzedObject(selectedObject);
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.fillActionBars();
    }

    public void setFocus() {
    }

    protected void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.setGlobalActionHandlers(actionBars);
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    protected void setGlobalActionHandlers(IActionBars actionBars) {
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        toolBar.add((IAction)this.toggleSynchroAction);
        toolBar.add((IAction)this.refreshAction);
    }

    protected void fillViewMenu(IMenuManager menu) {
    }

    public void refresh() {
        this.setAnalyzedObject(this.lastValidObject);
    }

    protected static void prepareViewerForDragToSirius(TreeViewer viewer) {
        Transfer[] transfers = new Transfer[]{TRANSFER};
        int dndOperations = 7;
        viewer.addDragSupport(7, transfers, (DragSourceListener)new EcoreToolsViewsDragTargetAdapter((ISelectionProvider)viewer));
    }

    protected abstract void refresh(EObject var1);
}

