/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestSource;

@API(status=API.Status.STABLE, since="1.0")
public final class MethodSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final String methodName;
    private final @Nullable String methodParameterTypes;
    private @Nullable Class<?> javaClass;
    private transient @Nullable Method javaMethod;

    public static MethodSource from(String className, String methodName) {
        return new MethodSource(className, methodName);
    }

    public static MethodSource from(String className, String methodName, String methodParameterTypes) {
        return new MethodSource(className, methodName, methodParameterTypes);
    }

    @API(status=API.Status.STABLE, since="1.5")
    public static MethodSource from(String className, String methodName, Class<?> ... methodParameterTypes) {
        return new MethodSource(className, methodName, ClassUtils.nullSafeToString((Class[])methodParameterTypes));
    }

    public static MethodSource from(Method testMethod) {
        return new MethodSource(testMethod);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public static MethodSource from(Class<?> testClass, Method testMethod) {
        return new MethodSource(testClass, testMethod);
    }

    private MethodSource(String className, String methodName) {
        this(className, methodName, null);
    }

    private MethodSource(String className, String methodName, @Nullable String methodParameterTypes) {
        Preconditions.notBlank((String)className, (String)"Class name must not be null or blank");
        Preconditions.notBlank((String)methodName, (String)"Method name must not be null or blank");
        this.className = className;
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
    }

    private MethodSource(Method testMethod) {
        this(((Method)Preconditions.notNull((Object)testMethod, (String)"Method must not be null")).getDeclaringClass(), testMethod);
    }

    private MethodSource(Class<?> testClass, Method testMethod) {
        Preconditions.notNull(testClass, (String)"Class must not be null");
        Preconditions.notNull((Object)testMethod, (String)"Method must not be null");
        this.className = testClass.getName();
        this.methodName = testMethod.getName();
        this.methodParameterTypes = ClassUtils.nullSafeToString((Class[])testMethod.getParameterTypes());
        this.javaClass = testClass;
        this.javaMethod = testMethod;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public @Nullable String getMethodParameterTypes() {
        return this.methodParameterTypes;
    }

    @API(status=API.Status.STABLE, since="1.7")
    public Class<?> getJavaClass() {
        return this.lazyLoadJavaClass();
    }

    @API(status=API.Status.STABLE, since="1.7")
    public Method getJavaMethod() {
        return this.lazyLoadJavaMethod();
    }

    private Class<?> lazyLoadJavaClass() {
        if (this.javaClass == null) {
            this.javaClass = (Class)ReflectionSupport.tryToLoadClass((String)this.className).getNonNullOrThrow(cause -> new PreconditionViolationException("Could not load class with name: " + this.className, (Throwable)cause));
        }
        return this.javaClass;
    }

    private Method lazyLoadJavaMethod() {
        if (this.javaMethod == null) {
            Class<?> javaClass = this.getJavaClass();
            this.javaMethod = StringUtils.isNotBlank((String)this.methodParameterTypes) ? (Method)ReflectionSupport.findMethod(javaClass, (String)this.methodName, (String)this.methodParameterTypes).orElseThrow(() -> new PreconditionViolationException("Could not find method with name [%s] and parameter types [%s] in class [%s].".formatted(this.methodName, this.methodParameterTypes, javaClass.getName()))) : (Method)ReflectionSupport.findMethod(javaClass, (String)this.methodName, (Class[])new Class[0]).orElseThrow(() -> new PreconditionViolationException("Could not find method with name [%s] in class [%s].".formatted(this.methodName, javaClass.getName())));
        }
        return this.javaMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSource that = (MethodSource)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.methodParameterTypes, that.methodParameterTypes);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.methodParameterTypes);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("className", (Object)this.className).append("methodName", (Object)this.methodName).append("methodParameterTypes", (Object)this.methodParameterTypes).toString();
    }
}

