/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ecore.dependencies.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.ecore.dependencies.DependenciesPackage;
import org.eclipse.emf.cdo.ecore.dependencies.Model;
import org.eclipse.emf.cdo.ecore.dependencies.bundle.DependenciesPlugin;
import org.eclipse.emf.cdo.ecore.dependencies.provider.URIStyler;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.om.pref.OMPreference;
import org.eclipse.net4j.util.om.pref.OMPreferencesChangeEvent;

public class ModelItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemStyledLabelProvider {
    private final IListener prefsListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof OMPreferencesChangeEvent) {
                OMPreference preference = ((OMPreferencesChangeEvent)event).getPreference();
                ModelItemProvider.this.preferenceChanged(preference);
            }
        }
    };

    public ModelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
        DependenciesPlugin.PREFS.addListener(this.prefsListener);
    }

    public void dispose() {
        DependenciesPlugin.PREFS.removeListener(this.prefsListener);
        super.dispose();
    }

    protected void preferenceChanged(OMPreference<?> preference) {
        if (preference == DependenciesPlugin.PREF_SHOW_CALLERS || preference == DependenciesPlugin.PREF_SHOW_FLAT || preference == DependenciesPlugin.PREF_SORT_BY_DEPENDENCIES) {
            this.resetChildren();
        }
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addUriPropertyDescriptor(object);
            this.addFilePropertyDescriptor(object);
            this.addWorkspacePropertyDescriptor(object);
            this.addExistsPropertyDescriptor(object);
            this.addNsURIPropertyDescriptor(object);
            this.addNamePropertyDescriptor(object);
            this.addOutgoingLinksPropertyDescriptor(object);
            this.addIncomingLinksPropertyDescriptor(object);
            this.addBrokenLinksPropertyDescriptor(object);
            this.addDependingModelsPropertyDescriptor(object);
            this.addFlatDependenciesPropertyDescriptor(object);
            this.addFlatDependingModelsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addUriPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Addressable_uri_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Addressable_uri_feature", "_UI_Addressable_type"), (EStructuralFeature)DependenciesPackage.Literals.ADDRESSABLE__URI, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addFilePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Model_file_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Model_file_feature", "_UI_Model_type"), (EStructuralFeature)DependenciesPackage.Literals.MODEL__FILE, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addWorkspacePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Model_workspace_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Model_workspace_feature", "_UI_Model_type"), (EStructuralFeature)DependenciesPackage.Literals.MODEL__WORKSPACE, false, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addExistsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Model_exists_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Model_exists_feature", "_UI_Model_type"), (EStructuralFeature)DependenciesPackage.Literals.MODEL__EXISTS, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addNsURIPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Model_nsURI_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Model_nsURI_feature", "_UI_Model_type"), (EStructuralFeature)DependenciesPackage.Literals.MODEL__NS_URI, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Model_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Model_name_feature", "_UI_Model_type"), (EStructuralFeature)DependenciesPackage.Literals.MODEL__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addOutgoingLinksPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Model_outgoingLinks_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Model_outgoingLinks_feature", "_UI_Model_type"), (EStructuralFeature)DependenciesPackage.Literals.MODEL__OUTGOING_LINKS, false, false, false, null, null, null));
    }

    protected void addIncomingLinksPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Model_incomingLinks_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Model_incomingLinks_feature", "_UI_Model_type"), (EStructuralFeature)DependenciesPackage.Literals.MODEL__INCOMING_LINKS, false, false, false, null, null, null));
    }

    protected void addBrokenLinksPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Model_brokenLinks_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Model_brokenLinks_feature", "_UI_Model_type"), (EStructuralFeature)DependenciesPackage.Literals.MODEL__BROKEN_LINKS, false, false, false, null, null, null));
    }

    protected void addDependingModelsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Model_dependingModels_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Model_dependingModels_feature", "_UI_Model_type"), (EStructuralFeature)DependenciesPackage.Literals.MODEL__DEPENDING_MODELS, true, false, true, null, null, null));
    }

    protected void addFlatDependenciesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Model_flatDependencies_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Model_flatDependencies_feature", "_UI_Model_type"), (EStructuralFeature)DependenciesPackage.Literals.MODEL__FLAT_DEPENDENCIES, false, false, false, null, null, null));
    }

    protected void addFlatDependingModelsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Model_flatDependingModels_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Model_flatDependingModels_feature", "_UI_Model_type"), (EStructuralFeature)DependenciesPackage.Literals.MODEL__FLAT_DEPENDING_MODELS, false, false, false, null, null, null));
    }

    protected final void resetChildren() {
        this.childrenFeatures = null;
        this.childrenStoreMap = null;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(this.getChildrenFeature());
        }
        return this.childrenFeatures;
    }

    protected EReference getChildrenFeature() {
        boolean showCallers = (Boolean)DependenciesPlugin.PREF_SHOW_CALLERS.getValue();
        boolean showFlat = (Boolean)DependenciesPlugin.PREF_SHOW_FLAT.getValue();
        if (showCallers) {
            if (showFlat) {
                return DependenciesPackage.Literals.MODEL__FLAT_DEPENDING_MODELS;
            }
            return DependenciesPackage.Literals.MODEL__DEPENDING_MODELS;
        }
        if (showFlat) {
            return DependenciesPackage.Literals.MODEL__FLAT_DEPENDENCIES;
        }
        return DependenciesPackage.Literals.MODEL__DEPENDENCIES;
    }

    protected Object getValue(EObject eObject, EStructuralFeature eStructuralFeature) {
        Object value = super.getValue(eObject, eStructuralFeature);
        if (eStructuralFeature == this.getChildrenFeature()) {
            ArrayList<Model> models = new ArrayList<Model>((List)value);
            return Model.sortModels(models, (Boolean)DependenciesPlugin.PREF_SORT_BY_DEPENDENCIES.getValue());
        }
        return value;
    }

    public Object getImage(Object object) {
        Model model = (Model)object;
        String key = "Model";
        if (((Boolean)DependenciesPlugin.PREF_SHOW_CALLERS.getValue()).booleanValue()) {
            if (!model.getDependingModels().isEmpty()) {
                key = "Callers";
            }
        } else if (!model.getDependencies().isEmpty()) {
            key = "Callees";
        }
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/" + key + ".gif"));
    }

    protected Object overlayImage(Object object, Object image) {
        image = super.overlayImage(object, image);
        Model model = (Model)object;
        if (!model.isExists() || model.hasBrokenLinks()) {
            ArrayList<Object> images = new ArrayList<Object>(2);
            images.add(image);
            images.add(this.getResourceLocator().getImage("full/ovr16/Error.gif"));
            image = new ComposedImage(images);
        }
        return image;
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String label = ((Model)object).getUri().toString();
        return label == null || label.length() == 0 ? this.getString("_UI_Model_type") : label;
    }

    public Object getStyledText(Object object) {
        Model model = (Model)object;
        int colorIndex = !model.isExists() ? 2 : (!model.isWorkspace() ? 1 : 0);
        return URIStyler.getEMFStyledURI(model.getUri(), colorIndex);
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Model.class)) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return DependenciesPlugin.INSTANCE;
    }
}

