/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDTypeDefinitionAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.actions.SetInputToGraphView;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ITreeElement;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDEnumerationFacetAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.SetBaseTypeAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.DeleteCommand;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.util.XSDConstants;

public class XSDSimpleTypeDefinitionAdapter
extends XSDTypeDefinitionAdapter {
    protected boolean readOnly;
    protected boolean changeReadOnlyField = false;
    protected HashMap deletedTypes = new HashMap();

    public Image getImage() {
        if (this.isReadOnly()) {
            return XSDEditorPlugin.getPlugin().getIcon("obj16/simpletypedis_obj.gif");
        }
        return XSDEditorPlugin.getPlugin().getIcon("obj16/simpletype_obj.gif");
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getText() {
        return this.getText(true);
    }

    public String getText(boolean showType) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.target;
        StringBuffer result = new StringBuffer();
        result.append(xsdSimpleTypeDefinition.getName() == null ? Messages._UI_LABEL_LOCAL_TYPE : xsdSimpleTypeDefinition.getName());
        if (showType) {
            XSDSimpleTypeDefinition baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
            if (baseTypeDefinition != null && XSDVariety.ATOMIC_LITERAL == xsdSimpleTypeDefinition.getVariety()) {
                if (baseTypeDefinition.getName() != null && !xsdSimpleTypeDefinition.getContents().contains((Object)baseTypeDefinition) && !XSDConstants.isAnySimpleType((XSDTypeDefinition)baseTypeDefinition)) {
                    try {
                        String qName = baseTypeDefinition.getQName((XSDConcreteComponent)xsdSimpleTypeDefinition);
                        result.append(" : ");
                        result.append(qName);
                    }
                    catch (Exception exception) {}
                }
            } else {
                XSDSimpleTypeDefinition itemTypeDefinition = xsdSimpleTypeDefinition.getItemTypeDefinition();
                if (itemTypeDefinition != null) {
                    if (itemTypeDefinition.getName() != null) {
                        result.append(" : ");
                        result.append(itemTypeDefinition.getQName((XSDConcreteComponent)xsdSimpleTypeDefinition));
                    }
                } else {
                    EList memberTypeDefinitions = xsdSimpleTypeDefinition.getMemberTypeDefinitions();
                    if (!memberTypeDefinitions.isEmpty()) {
                        boolean first = true;
                        Iterator members = memberTypeDefinitions.iterator();
                        while (members.hasNext()) {
                            XSDSimpleTypeDefinition memberTypeDefinition = (XSDSimpleTypeDefinition)members.next();
                            if (memberTypeDefinition.getName() != null) {
                                if (first) {
                                    result.append(" : ");
                                    first = false;
                                } else {
                                    result.append(" | ");
                                }
                                result.append(memberTypeDefinition.getQName((XSDConcreteComponent)xsdSimpleTypeDefinition));
                                continue;
                            }
                            break;
                        }
                    } else if (result.length() == 0) {
                        result.append(Messages._UI_LABEL_ABSENT);
                    }
                }
            }
        }
        return result.toString();
    }

    public boolean hasChildren() {
        return true;
    }

    public boolean isComplexType() {
        return false;
    }

    public boolean isFocusAllowed() {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.target;
        if ("http://www.w3.org/2001/XMLSchema".equals(xsdSimpleTypeDefinition.getTargetNamespace())) {
            return false;
        }
        if (xsdSimpleTypeDefinition.getName() == null) {
            return this.isAnonymous();
        }
        return true;
    }

    public String[] getActions(Object object) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(AddXSDEnumerationFacetAction.ID);
        list.add("org.eclipse.jface.action.Separator");
        list.add(SetBaseTypeAction.ID);
        list.add("org.eclipse.jface.action.Separator");
        list.add("org.eclipse.wst.xsd.ui.internal.editor.DeleteAction");
        list.add("org.eclipse.jface.action.Separator");
        Object schema = this.getEditorSchema();
        XSDTypeDefinition typeDefinition = this.getXSDTypeDefinition();
        if (typeDefinition.getSchema() == schema) {
            XSDConcreteComponent container = typeDefinition.getContainer();
            if (container == schema || container instanceof XSDRedefine) {
                list.add(SetInputToGraphView.ID);
            }
        } else {
            list.add("OpenInNewEditor");
        }
        list.add("org.eclipse.jface.action.Separator");
        list.add("org.eclipse.wst.xsd.ui.internal.adt.actions.ShowPropertiesViewAction");
        return list.toArray(new String[0]);
    }

    public boolean isAnonymous() {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.target;
        EObject eContainer = xsdSimpleTypeDefinition.eContainer();
        return !(eContainer instanceof XSDSchema) && !(eContainer instanceof XSDRedefine);
    }

    public IADTObject getTopContainer() {
        return this;
    }

    public Command getDeleteCommand() {
        return new DeleteCommand((XSDConcreteComponent)this.getXSDTypeDefinition());
    }

    public IModel getModel() {
        Adapter adapter = XSDAdapterFactory.getInstance().adapt((Notifier)this.getXSDTypeDefinition().getSchema());
        return (IModel)adapter;
    }

    public ITreeElement[] getChildren() {
        ArrayList adapterList = new ArrayList();
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.target;
        EList list = xsdSimpleTypeDefinition.getEnumerationFacets();
        this.populateAdapterList((List)list, adapterList);
        return adapterList.toArray(new ITreeElement[0]);
    }

    public boolean isReadOnly() {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.target;
        if (this.hasSetReadOnlyField()) {
            this.deletedTypes.put(xsdSimpleTypeDefinition.getName(), new Boolean(true));
            this.changeReadOnlyField = false;
            return this.readOnly;
        }
        if (this.deletedTypes != null) {
            Boolean deleted = (Boolean)this.deletedTypes.get(xsdSimpleTypeDefinition.getName());
            if (deleted != null && deleted.booleanValue()) {
                return true;
            }
            return super.isReadOnly();
        }
        return super.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean hasSetReadOnlyField() {
        return this.changeReadOnlyField;
    }

    public void setChangeReadOnlyField(boolean setReadOnlyField) {
        this.changeReadOnlyField = setReadOnlyField;
    }

    public void updateDeletedMap(String addComponent) {
        if (this.deletedTypes.get(addComponent) != null) {
            this.deletedTypes.clear();
        }
    }
}

