/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.annotate.util;

import org.eclipse.jpt.jpa.annotate.util.AnnotateMappingUtil;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;

public class DefaultTableUtil {
    public static Table findTable(Schema schema, String javaClassName, PersistenceUnit persistenceUnit) {
        if (schema == null || javaClassName == null || persistenceUnit == null) {
            return null;
        }
        Table table = null;
        Entity entity = persistenceUnit.getEntity(javaClassName);
        if (entity != null) {
            String tableName = entity.getTable().getName();
            table = schema.getTableNamed(tableName);
        }
        if (table == null) {
            table = DefaultTableUtil.findTable(schema, javaClassName);
        }
        return table;
    }

    public static Table findTable(Schema schema, String javaClassName) {
        if (schema == null || javaClassName == null) {
            return null;
        }
        String simpleClassName = AnnotateMappingUtil.getClassName(javaClassName);
        Table table = DefaultTableUtil.findTableCaseInsensitive(schema, simpleClassName);
        if (table == null) {
            simpleClassName = AnnotateMappingUtil.pluralise(simpleClassName);
            table = DefaultTableUtil.findTableCaseInsensitive(schema, simpleClassName);
        }
        if (table == null) {
            simpleClassName = AnnotateMappingUtil.singularise(simpleClassName);
            table = DefaultTableUtil.findTableCaseInsensitive(schema, simpleClassName);
        }
        if (table == null) {
            for (Table table2 : schema.getTables()) {
                String tableName2 = AnnotateMappingUtil.dbNameToJavaName(table2.getName());
                if (!tableName2.equalsIgnoreCase(simpleClassName)) continue;
                table = table2;
                break;
            }
        }
        return table;
    }

    private static Table findTableCaseInsensitive(Schema schema, String tableName) {
        String tableName2 = tableName;
        Table table = null;
        if (schema != null) {
            table = schema.getTableNamed(tableName2);
            if (table == null) {
                tableName2 = tableName2.toUpperCase();
                table = schema.getTableNamed(tableName2);
            }
            if (table == null) {
                tableName2 = tableName2.toLowerCase();
                table = schema.getTableNamed(tableName2);
            }
        }
        return table;
    }
}

