/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.collection.Bag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SubListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELClassMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELXmlJoinNode;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELXmlJoinNodesMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlJoinNode;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlJoinNodeAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.validation.JptJaxbEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class ELJavaXmlJoinNodesMapping
extends AbstractJavaAttributeMapping
implements ELXmlJoinNodesMapping {
    protected final AbstractJaxbNode.ContextListContainer<ELJavaXmlJoinNode, XmlJoinNodeAnnotation> xmlJoinNodeContainer = this.buildXmlJoinNodeContainer();

    public ELJavaXmlJoinNodesMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    public String getKey() {
        return "xml-join-nodes";
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.oxm.annotations.XmlJoinNodes";
    }

    public Annotation getAnnotation() {
        return this.getJavaResourceAttribute().getContainerAnnotation(this.getAnnotationName());
    }

    protected boolean buildDefault() {
        return this.getAnnotation() == null && IterableTools.isEmpty((Iterable)this.getPersistentAttribute().getJavaResourceAttribute().getAnnotations("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.xmlJoinNodeContainer.synchronizeWithResourceModel();
    }

    public void update() {
        super.update();
        this.xmlJoinNodeContainer.update();
    }

    @Override
    public ListIterable<ELXmlJoinNode> getXmlJoinNodes() {
        return new SuperListIterableWrapper(this.xmlJoinNodeContainer.getContextElements());
    }

    @Override
    public int getXmlJoinNodesSize() {
        return this.xmlJoinNodeContainer.getContextElementsSize();
    }

    @Override
    public ELXmlJoinNode addXmlJoinNode(int index) {
        XmlJoinNodeAnnotation annotation = (XmlJoinNodeAnnotation)this.getJavaResourceAttribute().addAnnotation(index, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        return (ELXmlJoinNode)this.xmlJoinNodeContainer.addContextElement(index, (Object)annotation);
    }

    @Override
    public void removeXmlJoinNode(int index) {
        this.getJavaResourceAttribute().removeAnnotation(index, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        this.xmlJoinNodeContainer.removeContextElement(index);
    }

    @Override
    public void moveXmlJoinNode(int targetIndex, int sourceIndex) {
        this.getJavaResourceAttribute().moveAnnotation(targetIndex, sourceIndex, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        this.xmlJoinNodeContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected ELJavaXmlJoinNode buildXmlJoinNode(XmlJoinNodeAnnotation xmlJoinNodeAnnotation) {
        return new ELJavaXmlJoinNode((JaxbContextNode)this, new XmlJoinNodeContext(xmlJoinNodeAnnotation));
    }

    protected AbstractJaxbNode.ContextListContainer<ELJavaXmlJoinNode, XmlJoinNodeAnnotation> buildXmlJoinNodeContainer() {
        XmlJoinNodeContainer container = new XmlJoinNodeContainer();
        container.initialize();
        return container;
    }

    protected ListIterable<XmlJoinNodeAnnotation> getXmlJoinNodeAnnotations() {
        return new SubListIterableWrapper(this.getJavaResourceAttribute().getAnnotations("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
    }

    @Override
    public ELClassMapping getReferencedClassMapping() {
        String valueType = this.getValueTypeName();
        if (StringTools.isBlank((String)valueType)) {
            return null;
        }
        return (ELClassMapping)this.getContextRoot().getClassMapping(valueType);
    }

    @Override
    public XsdTypeDefinition getReferencedXsdTypeDefinition() {
        ELClassMapping classMapping = this.getReferencedClassMapping();
        return classMapping == null ? null : classMapping.getXsdTypeDefinition();
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty((Iterable)result)) {
            return result;
        }
        for (ELJavaXmlJoinNode xmlJoinNode : this.xmlJoinNodeContainer.getContextElements()) {
            result = xmlJoinNode.getCompletionProposals(pos);
            if (IterableTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        ELClassMapping referencedClass = this.getReferencedClassMapping();
        if (referencedClass == null) {
            messages.add(this.buildValidationMessage((JaxbNode)this, this.getValidationTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XML_JOIN_NODES__INVALID_REFERENCED_CLASS, new Object[]{this.getValueTypeName()}));
        }
        this.validateDuplicateXmlPaths(messages, reporter);
        for (ELJavaXmlJoinNode xmlJoinNode : this.xmlJoinNodeContainer.getContextElements()) {
            xmlJoinNode.validate(messages, reporter);
        }
    }

    protected void validateDuplicateXmlPaths(List<IMessage> messages, IReporter reporter) {
        HashBag xmlPaths = new HashBag();
        HashBag referencedXmlPaths = new HashBag();
        for (ELJavaXmlJoinNode joinNode : this.xmlJoinNodeContainer.getContextElements()) {
            String referencedXmlPath;
            String xmlPath = joinNode.getXmlPath();
            if (StringTools.isNotBlank((String)xmlPath)) {
                xmlPaths.add((Object)xmlPath);
            }
            if (!StringTools.isNotBlank((String)(referencedXmlPath = joinNode.getReferencedXmlPath()))) continue;
            referencedXmlPaths.add((Object)referencedXmlPath);
        }
        for (ELJavaXmlJoinNode joinNode : this.xmlJoinNodeContainer.getContextElements()) {
            this.validateDuplicateXmlPath(joinNode, (Bag<String>)xmlPaths, messages);
            this.validateDuplicateReferencedXmlPath(joinNode, (Bag<String>)referencedXmlPaths, messages);
        }
    }

    protected void validateDuplicateXmlPath(ELJavaXmlJoinNode joinNode, Bag<String> xmlPaths, List<IMessage> messages) {
        String xmlPath = joinNode.getXmlPath();
        if (xmlPaths.count((Object)xmlPath) > 1) {
            messages.add(this.buildValidationMessage((JaxbNode)joinNode, joinNode.getXmlPathTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XML_JOIN_NODES__DUPLICATE_XML_PATH, new Object[]{xmlPath}));
        }
    }

    protected void validateDuplicateReferencedXmlPath(ELJavaXmlJoinNode joinNode, Bag<String> referencedXmlPaths, List<IMessage> messages) {
        String referencedXmlPath = joinNode.getReferencedXmlPath();
        if (referencedXmlPaths.count((Object)referencedXmlPath) > 1) {
            messages.add(this.buildValidationMessage((JaxbNode)joinNode, joinNode.getReferencedXmlPathTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XML_JOIN_NODES__DUPLICATE_REFERENCED_XML_PATH, new Object[]{referencedXmlPath}));
        }
    }

    public TextRange getValidationTextRange() {
        Annotation annotation = this.getAnnotation();
        if (annotation == null) {
            annotation = this.getJavaResourceAttribute().getAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        }
        return annotation.getTextRange();
    }

    protected class XmlJoinNodeContainer
    extends AbstractJaxbNode.ContextListContainer<ELJavaXmlJoinNode, XmlJoinNodeAnnotation> {
        protected XmlJoinNodeContainer() {
            super((AbstractJaxbNode)ELJavaXmlJoinNodesMapping.this);
        }

        protected String getContextElementsPropertyName() {
            return "xmlPaths";
        }

        protected ELJavaXmlJoinNode buildContextElement(XmlJoinNodeAnnotation resourceElement) {
            return ELJavaXmlJoinNodesMapping.this.buildXmlJoinNode(resourceElement);
        }

        protected ListIterable<XmlJoinNodeAnnotation> getResourceElements() {
            return ELJavaXmlJoinNodesMapping.this.getXmlJoinNodeAnnotations();
        }

        protected XmlJoinNodeAnnotation getResourceElement(ELJavaXmlJoinNode contextElement) {
            return contextElement.getAnnotation();
        }
    }

    protected class XmlJoinNodeContext
    implements ELJavaXmlJoinNode.Context {
        protected XmlJoinNodeAnnotation annotation;

        protected XmlJoinNodeContext(XmlJoinNodeAnnotation annotation) {
            this.annotation = annotation;
        }

        @Override
        public XmlJoinNodeAnnotation getAnnotation() {
            return this.annotation;
        }

        @Override
        public ELXmlJoinNodesMapping getAttributeMapping() {
            return ELJavaXmlJoinNodesMapping.this;
        }
    }
}

