/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views;

import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntProjectNodeProxy;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;

public class AntViewDropAdapter
extends DropTargetAdapter {
    private final AntView view;

    public AntViewDropAdapter(AntView view) {
        this.view = view;
    }

    public void drop(DropTargetEvent event) {
        Object data = event.data;
        if (data instanceof String[]) {
            BusyIndicator.showWhile(null, () -> {
                String[] stringArray = (String[])data;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    this.processString(string);
                    ++n2;
                }
            });
        }
    }

    private void processString(String buildFileName) {
        IFile buildFile = AntUtil.getFileForLocation(buildFileName, null);
        if (!AntUtil.isKnownAntFile((IResource)buildFile)) {
            return;
        }
        String name = buildFile.getFullPath().toString();
        AntProjectNode[] antProjectNodeArray = this.view.getProjects();
        int n = antProjectNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AntProjectNode node = antProjectNodeArray[n2];
            AntProjectNodeProxy existingProject = (AntProjectNodeProxy)node;
            if (existingProject.getBuildFileName().equals(name)) {
                return;
            }
            ++n2;
        }
        AntProjectNodeProxy project = new AntProjectNodeProxy(name);
        this.view.addProject(project);
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
        super.dragEnter(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = 1;
        super.dragOperationChanged(event);
    }
}

