/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.details;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.ui.internal.widgets.ValidatingDialog;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticListValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.ui.details.JptJpaEclipseLinkUiDetailsMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkConverterStateObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EclipseLinkConverterDialog
extends ValidatingDialog<EclipseLinkConverterStateObject> {
    EclipseLinkConverterContainer converterContainer;

    public EclipseLinkConverterDialog(Shell parentShell, ResourceManager resourceManager, EclipseLinkConverterContainer converterContainer) {
        super(parentShell, resourceManager, JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTER_DIALOG_ADD_CONVERTER);
        this.converterContainer = converterContainer;
    }

    protected EclipseLinkConverterStateObject buildStateObject() {
        return new EclipseLinkConverterStateObject(this.converterContainer);
    }

    protected String getDescriptionTitle() {
        return JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTER_DIALOG_ADD_CONVERTER_DESCRIPTION_TITLE;
    }

    protected String getDescription() {
        return JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTER_DIALOG_ADD_CONVERTER_DESCRIPTION;
    }

    protected DialogPane<EclipseLinkConverterStateObject> buildLayout(Composite container) {
        return new ConversionValueDialogPane((PropertyValueModel<EclipseLinkConverterStateObject>)this.getSubjectHolder(), container, this.resourceManager);
    }

    public void create() {
        super.create();
        ConversionValueDialogPane pane = (ConversionValueDialogPane)this.getPane();
        pane.selectAll();
        this.getButton(0).setEnabled(false);
    }

    public String getName() {
        return ((EclipseLinkConverterStateObject)this.getSubject()).getName();
    }

    public Class<? extends EclipseLinkConverter> getConverterType() {
        return ((EclipseLinkConverterStateObject)this.getSubject()).getConverterType();
    }

    static class ConversionValueDialogPane
    extends DialogPane<EclipseLinkConverterStateObject> {
        private Text nameText;
        private static final Class<? extends EclipseLinkConverter>[] CONVERTER_TYPES = new Class[]{EclipseLinkCustomConverter.class, EclipseLinkObjectTypeConverter.class, EclipseLinkStructConverter.class, EclipseLinkTypeConverter.class};

        ConversionValueDialogPane(PropertyValueModel<EclipseLinkConverterStateObject> subjectModel, Composite parentComposite, ResourceManager resourceManager) {
            super(subjectModel, parentComposite, resourceManager);
        }

        protected Composite addComposite(Composite container) {
            return this.addSubPane(container, 2, 0, 0, 0, 0);
        }

        protected void initializeLayout(Composite container) {
            this.addLabel(container, JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTER_DIALOG_NAME);
            this.nameText = this.addText(container, this.buildNameHolder());
            this.addLabel(container, JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTER_DIALOG_CONVERTER_TYPE);
            this.addCombo(container, this.buildConverterTypeListHolder(), this.buildConverterTypeHolder(), this.buildConverterTypeLabelTransformer(), null);
        }

        protected ListValueModel<Class<? extends EclipseLinkConverter>> buildConverterTypeListHolder() {
            return new StaticListValueModel((Object[])CONVERTER_TYPES);
        }

        private Transformer<Class<? extends EclipseLinkConverter>, String> buildConverterTypeLabelTransformer() {
            return new ConverterTypeLabelTransformer();
        }

        private ModifiablePropertyValueModel<String> buildNameHolder() {
            return new PropertyAspectAdapter<EclipseLinkConverterStateObject, String>(this.getSubjectHolder(), new String[]{"name"}){

                protected String buildValue_() {
                    return ((EclipseLinkConverterStateObject)((Object)this.subject)).getName();
                }

                protected void setValue_(String value) {
                    ((EclipseLinkConverterStateObject)((Object)this.subject)).setName(value);
                }
            };
        }

        private ModifiablePropertyValueModel<Class<? extends EclipseLinkConverter>> buildConverterTypeHolder() {
            return new PropertyAspectAdapter<EclipseLinkConverterStateObject, Class<? extends EclipseLinkConverter>>(this.getSubjectHolder(), new String[]{"converterType"}){

                protected Class<? extends EclipseLinkConverter> buildValue_() {
                    return ((EclipseLinkConverterStateObject)((Object)this.subject)).getConverterType();
                }

                protected void setValue_(Class<? extends EclipseLinkConverter> value) {
                    ((EclipseLinkConverterStateObject)((Object)this.subject)).setConverterType(value);
                }
            };
        }

        void selectAll() {
            this.nameText.selectAll();
        }

        static class ConverterTypeLabelTransformer
        extends AbstractTransformer<Class<? extends EclipseLinkConverter>, String> {
            ConverterTypeLabelTransformer() {
            }

            public String transform_(Class<? extends EclipseLinkConverter> value) {
                if (value == EclipseLinkCustomConverter.class) {
                    return JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTERS_COMPOSITE_CUSTOM_CONVERTER;
                }
                if (value == EclipseLinkObjectTypeConverter.class) {
                    return JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTERS_COMPOSITE_OBJECT_TYPE_CONVERTER;
                }
                if (value == EclipseLinkStructConverter.class) {
                    return JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTERS_COMPOSITE_STRUCT_CONVERTER;
                }
                if (value == EclipseLinkTypeConverter.class) {
                    return JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTERS_COMPOSITE_TYPE_CONVERTER;
                }
                return value.getSimpleName();
            }
        }
    }
}

