/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.bundle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.text.bundle.CompositeManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ExecutionEnvironment;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.eclipse.pde.internal.core.util.VMUtil;

public class RequiredExecutionEnvironmentHeader
extends CompositeManifestHeader {
    private static final long serialVersionUID = 1L;

    public RequiredExecutionEnvironmentHeader(String name, String value, IBundle bundle, String lineDelimiter) {
        super(name, value, bundle, lineDelimiter, VMUtil.ASCENDING_EE_JAVA_VERSION);
    }

    @Override
    protected PDEManifestElement createElement(ManifestElement element) {
        return new ExecutionEnvironment((ManifestHeader)this, element.getValue());
    }

    public void addExecutionEnvironment(String eeId) {
        this.addManifestElement(new ExecutionEnvironment((ManifestHeader)this, eeId));
    }

    public void addExecutionEnvironment(ExecutionEnvironment environment, int index) {
        this.addManifestElement(environment, index, true);
    }

    public void addExecutionEnvironments(List<String> eeIDs) {
        ArrayList<ExecutionEnvironment> list = new ArrayList<ExecutionEnvironment>(eeIDs.size());
        for (String eeID : eeIDs) {
            if (this.hasElement(eeID)) continue;
            list.add(new ExecutionEnvironment((ManifestHeader)this, eeID));
        }
        if (!list.isEmpty()) {
            this.addManifestElements(list);
        }
    }

    public ExecutionEnvironment removeExecutionEnvironment(String eeId) {
        return (ExecutionEnvironment)this.removeManifestElement(eeId);
    }

    public List<String> getEnvironments() {
        PDEManifestElement[] elements = this.getElements();
        return Arrays.stream(elements).map(PDEManifestElement::getValue).toList();
    }
}

