/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.markdown.internal.token;

import org.eclipse.mylyn.wikitext.markdown.internal.LinkDefinition;
import org.eclipse.mylyn.wikitext.markdown.internal.MarkdownContentState;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class ReferenceStyleLinkReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "(\\[\\s*(.*?)\\s*\\]\\s*\\[\\s*(.*?)\\s*\\])";
    }

    protected int getPatternGroupCount() {
        return 3;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new ReferenceStyleLinkReplacementTokenProcessor();
    }

    private static class ReferenceStyleLinkReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private ReferenceStyleLinkReplacementTokenProcessor() {
        }

        public void emit() {
            MarkdownContentState mdContentState;
            LinkDefinition linkDefinition;
            String text = this.group(2);
            String refid = this.group(3);
            if (refid.isEmpty()) {
                refid = text;
            }
            if ((linkDefinition = (mdContentState = (MarkdownContentState)this.getState()).getLinkDefinition(refid)) != null) {
                String href = linkDefinition.getUrl();
                String title = linkDefinition.getTitle();
                LinkAttributes attributes = new LinkAttributes();
                if (title != null) {
                    attributes.setTitle(title);
                }
                this.builder.link((Attributes)attributes, href, text);
            } else {
                this.builder.characters(this.group(1));
            }
        }
    }
}

