/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.provider.AnnotationItemProvider;
import org.eclipse.oomph.base.provider.BaseItemProviderAdapterFactory;
import org.eclipse.oomph.setup.Configuration;

class ExtendedBaseItemProviderAdapterFactory
extends BaseItemProviderAdapterFactory {
    ExtendedBaseItemProviderAdapterFactory() {
    }

    public Adapter createAnnotationAdapter() {
        if (this.annotationItemProvider == null) {
            this.annotationItemProvider = new AnnotationItemProvider((AdapterFactory)this){

                protected Collection<?> filterChoices(Collection<?> choices, EStructuralFeature feature, Object object) {
                    Annotation annotation;
                    Collection result = super.filterChoices(choices, feature, object);
                    if (feature == BasePackage.Literals.ANNOTATION__REFERENCES && "http://www.eclipse.org/oomph/setup/ConfigurationReference".equals((annotation = (Annotation)object).getSource())) {
                        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
                        for (Object choice : choices) {
                            if (!(choice instanceof Configuration)) continue;
                            configurations.add((Configuration)choice);
                        }
                        return configurations;
                    }
                    return result;
                }

                public String getText(Object object) {
                    EList references;
                    String result = super.getText(object);
                    Annotation annotation = (Annotation)object;
                    if ("http://www.eclipse.org/oomph/setup/ConfigurationReference".equals(annotation.getSource()) && !(references = annotation.getReferences()).isEmpty()) {
                        StringBuilder text = new StringBuilder(result);
                        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator(this.getRootAdapterFactory());
                        for (EObject reference : references) {
                            text.append(" - ").append(adapterFactoryItemDelegator.getText((Object)reference));
                            if (text.length() <= 500) continue;
                            text.append("...");
                            break;
                        }
                        return text.toString();
                    }
                    return result;
                }

                protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
                    if (feature == BasePackage.Literals.ANNOTATION__CONTENTS) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    return super.createAddCommand(domain, owner, feature, collection, index);
                }

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                    switch (notification.getFeatureID(Annotation.class)) {
                        case 5: {
                            this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                            return;
                        }
                    }
                }
            };
        }
        return this.annotationItemProvider;
    }
}

