/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.connector.process.internal;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.connector.InMemorySettingsStore;
import org.eclipse.terminal.connector.TerminalConnectorExtension;
import org.eclipse.terminal.connector.process.ProcessSettings;
import org.eclipse.terminal.view.core.ITerminalServiceOutputStreamMonitorListener;
import org.eclipse.terminal.view.ui.launcher.AbstractLauncherDelegate;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanel;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanelContainer;

public class ProcessLauncherDelegate
extends AbstractLauncherDelegate {
    public boolean needsUserConfiguration() {
        return false;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return null;
    }

    public CompletableFuture<?> execute(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        try {
            return this.getTerminalService().openConsole(properties);
        }
        catch (RuntimeException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) throws CoreException {
        boolean bl;
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.terminal.connector.process.ProcessConnector";
        }
        String image = (String)properties.get("process.path");
        String arguments = (String)properties.get("process.args");
        Process process = (Process)properties.get("process");
        PTY pty = (PTY)properties.get("pty");
        Object value = properties.get("localEcho");
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            bl = b;
        } else {
            bl = false;
        }
        boolean localEcho = bl;
        String lineSeparator = (String)properties.get("lineSeparator");
        ITerminalServiceOutputStreamMonitorListener[] stdoutListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stdoutListeners");
        ITerminalServiceOutputStreamMonitorListener[] stderrListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stderrListeners");
        String workingDir = (String)properties.get("process.working_dir");
        String[] envp = null;
        if (properties.containsKey("process.environment") && properties.get("process.environment") != null && properties.get("process.environment") instanceof String[]) {
            envp = (String[])properties.get("process.environment");
        }
        Assert.isTrue((image != null || process != null ? 1 : 0) != 0);
        InMemorySettingsStore store = new InMemorySettingsStore();
        ProcessSettings processSettings = new ProcessSettings();
        processSettings.setImage(image);
        processSettings.setArguments(arguments);
        processSettings.setProcess(process);
        processSettings.setPTY(pty);
        processSettings.setLocalEcho(localEcho);
        processSettings.setLineSeparator(lineSeparator);
        processSettings.setStdOutListeners(stdoutListeners);
        processSettings.setStdErrListeners(stderrListeners);
        processSettings.setWorkingDir(workingDir);
        processSettings.setEnvironment(envp);
        if (properties.containsKey("process.environment.merge")) {
            boolean bl2;
            value = properties.get("process.environment.merge");
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                bl2 = b;
            } else {
                bl2 = false;
            }
            processSettings.setMergeWithNativeEnvironment(bl2);
        }
        processSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        connector.setDefaultSettings();
        connector.load((ISettingsStore)store);
        return connector;
    }
}

