/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCoreMessages;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.parser.XMLLineTokenizer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.validation.AnnotationMsg;

public class StreamingMarkupValidator
extends AbstractValidator
implements IValidator {
    private static final String ANNOTATIONMSG = AnnotationMsg.class.getName();
    private static final int ERROR_THRESHOLD = 25;
    private IStructuredModel model;
    private IReporter fReporter;
    private Stack tagStack;
    private int tagErrorCount = 0;
    private IContentType xmlContentType;

    public void getAnnotationMsg(IReporter reporter, int problemId, LocalizedMessage message, Object attributeValueText, int len) {
        AnnotationMsg annotation = new AnnotationMsg(problemId, attributeValueText, len);
        message.setAttribute(ANNOTATIONMSG, (Object)annotation);
        reporter.addMessage((IValidator)this, (IMessage)message);
    }

    public void cleanup(IReporter reporter) {
        if (this.tagStack != null) {
            this.tagStack.clear();
            this.tagStack = null;
        }
        this.xmlContentType = null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] uris = helper.getURIs();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (uris.length > 0) {
            IFile currentFile = null;
            int i = 0;
            while (i < uris.length && !reporter.isCancelled()) {
                Path path = new Path(uris[i]);
                if (path.segmentCount() > 1) {
                    currentFile = root.getFile((IPath)path);
                    if (this.shouldValidate((IResource)currentFile, true)) {
                        this.validateFile(currentFile, reporter);
                    }
                } else if (uris.length == 1) {
                    this.validateProject(helper, reporter);
                }
                ++i;
            }
        } else {
            this.validateProject(helper, reporter);
        }
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        this.fReporter = result.getReporter(monitor);
        this.validateFile((IFile)resource, this.fReporter);
        return result;
    }

    public IReporter validate(IResource resource, int kind, ValidationState state) {
        this.validate(resource, kind, state, (IProgressMonitor)new NullProgressMonitor());
        return this.fReporter;
    }

    private int getLine(Token token) {
        return token.line + 1;
    }

    private void checkForSpaceBeforeName(Token token, List previousRegion, IReporter reporter) {
        if (previousRegion != null && previousRegion.size() == 1) {
            Token first = (Token)previousRegion.get(0);
            if ("XML_TAG_OPEN".equals(first.type) && token.text.trim().length() == 0) {
                String messageText = XMLCoreMessages.ReconcileStepForMarkup_2;
                int length = token.length;
                LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("whitespaceBeforeTagName"), messageText);
                message.setOffset(token.offset);
                message.setLength(length);
                message.setLineNo(this.getLine(token));
                this.getAnnotationMsg(reporter, 6, message, null, length);
            }
        }
    }

    private void checkForTagClose(List previousRegion, IReporter reporter) {
        if (previousRegion != null && previousRegion.size() > 0) {
            Token first = (Token)previousRegion.get(0);
            if (first.type == "XML_TAG_OPEN" || first.type == "XML_END_TAG_OPEN") {
                int length = previousRegion.size();
                boolean isClosed = false;
                int textLength = first.length;
                int i = 1;
                while (i < length) {
                    Token t = (Token)previousRegion.get(i);
                    if (t.type == "XML_EMPTY_TAG_CLOSE" && first.type == "XML_TAG_OPEN" || t.type == "XML_TAG_CLOSE") {
                        isClosed = true;
                        break;
                    }
                    if (t.type == "XML_TAG_NAME") {
                        textLength += t.length;
                    }
                    ++i;
                }
                if (!isClosed) {
                    String messageText = XMLCoreMessages.ReconcileStepForMarkup_6;
                    LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("missingClosingBracket"), messageText);
                    message.setOffset(first.offset);
                    message.setLength(textLength);
                    message.setLineNo(this.getLine(first));
                    this.getAnnotationMsg(reporter, 14, message, null, textLength);
                }
            }
        }
    }

    private void checkContentBeforeProcessingInstruction(List previousRegion, IReporter reporter) {
        if (previousRegion != null && previousRegion.size() > 0) {
            Token first = (Token)previousRegion.get(0);
            if (first.type == "XML_CONTENT" && first.offset == 0) {
                String messageText = XMLCoreMessages.ReconcileStepForMarkup_5;
                LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("whitespaceAtStart"), messageText);
                message.setOffset(first.offset);
                message.setLength(first.length);
                message.setLineNo(first.line + 1);
                this.getAnnotationMsg(reporter, 7, message, null, first.length);
            }
        }
    }

    private void checkNamespacesInProcessingInstruction(List region, IReporter reporter) {
        int regionLength = region.size();
        int i = 0;
        while (i < regionLength) {
            int index;
            Token t = (Token)region.get(i);
            if (t.type == "XML_TAG_NAME" && (index = t.text.indexOf(":")) != -1) {
                String messageText = XMLCoreMessages.ReconcileStepForMarkup_4;
                int start = t.offset + index;
                int length = t.text.trim().length() - index;
                LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("namespaceInPITarget"), messageText);
                message.setOffset(start);
                message.setLength(length);
                message.setLineNo(t.line + 1);
                this.getAnnotationMsg(reporter, 8, message, null, length);
                break;
            }
            ++i;
        }
    }

    private void checkEmptyTag(List region, IReporter reporter) {
        if (region.size() == 2) {
            Token first = (Token)region.get(0);
            if (first.type == "XML_TAG_OPEN") {
                String messageText = XMLCoreMessages.ReconcileStepForMarkup_3;
                int length = first.length + ((Token)region.get((int)1)).length;
                LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("missingTagName"), messageText);
                message.setOffset(first.offset);
                message.setLength(length);
                message.setLineNo(first.line + 1);
                this.getAnnotationMsg(reporter, 1, message, null, length);
            }
        }
    }

    private void checkAttributsInEndTag(Token first, List region, IReporter reporter) {
        int errors = 0;
        int start = first.offset;
        int end = first.offset;
        int regionLength = region.size();
        int i = 1;
        while (i < regionLength && errors < 25) {
            Token t = (Token)region.get(i);
            if (t.type == "XML_TAG_ATTRIBUTE_NAME" || t.type == "XML_TAG_ATTRIBUTE_EQUALS" || t.type == "XML_TAG_ATTRIBUTE_VALUE") {
                if (start == first.offset) {
                    start = t.offset;
                }
                end = t.offset + t.length;
                ++errors;
            }
            ++i;
        }
        if (errors > 0) {
            String messageText = XMLCoreMessages.End_tag_has_attributes;
            LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("endTagWithAttributes"), messageText);
            message.setOffset(start);
            message.setLength(end - start);
            message.setLineNo(first.line + 1);
            this.getAnnotationMsg(reporter, 3, message, null, end - start);
        }
    }

    private void checkAttributes(List region, IReporter reporter) {
        int attrState = 0;
        int errorCount = 0;
        int regionLength = region.size();
        int i = 1;
        while (i < regionLength && errorCount < 25) {
            Token t = (Token)region.get(i);
            if (t.type == "XML_TAG_ATTRIBUTE_NAME" || t.type == "XML_TAG_CLOSE" || t.type == "XML_EMPTY_TAG_CLOSE") {
                if (attrState == 2 && i >= 2) {
                    Token nameRegion = (Token)region.get(i - 2);
                    Object[] args = new Object[]{nameRegion.text};
                    String messageText = NLS.bind((String)XMLCoreMessages.Attribute__is_missing_a_value, (Object[])args);
                    int start = nameRegion.offset;
                    int end = start + nameRegion.length;
                    LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("attributeHasNoValue"), messageText);
                    message.setOffset(start);
                    message.setLength(nameRegion.length);
                    message.setLineNo(nameRegion.line + 1);
                    Token equalsRegion = (Token)region.get(i - 2 + 1);
                    int insertOffset = equalsRegion.offset + equalsRegion.length - end;
                    Object[] additionalFixInfo = new Object[]{nameRegion.text, new Integer(insertOffset)};
                    this.getAnnotationMsg(reporter, 4, message, additionalFixInfo, nameRegion.text.length());
                    ++errorCount;
                } else if (attrState == 1 && i >= 1) {
                    Token nameToken = (Token)region.get(i - 1);
                    Object[] args = new Object[]{nameToken.text};
                    String messageText = NLS.bind((String)XMLCoreMessages.Attribute__has_no_value, (Object[])args);
                    int start = nameToken.offset;
                    int textLength = nameToken.text.trim().length();
                    int lineNo = nameToken.line;
                    LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("attributeHasNoValue"), messageText);
                    message.setOffset(start);
                    message.setLength(textLength);
                    message.setLineNo(lineNo + 1);
                    this.getAnnotationMsg(reporter, 5, message, nameToken.text, textLength);
                    ++errorCount;
                }
                attrState = 1;
            } else if (t.type == "XML_TAG_ATTRIBUTE_EQUALS") {
                attrState = 2;
            } else if (t.type == "XML_TAG_ATTRIBUTE_VALUE") {
                attrState = 0;
                String trimmed = t.text.trim();
                if (trimmed.length() > 0) {
                    char q1 = trimmed.charAt(0);
                    char q2 = trimmed.charAt(trimmed.length() - 1);
                    if (!(q1 != '\'' && q1 != '\"' || q1 == q2 && trimmed.length() != 1)) {
                        String message = XMLCoreMessages.ReconcileStepForMarkup_0;
                        this.addAttributeError(message, t.text, t.offset, t.length, t.line, 0, reporter, this.getPluginPreference().getInt("missingClosingQuote"));
                        ++errorCount;
                    } else if (q1 != '\'' && q1 != '\"') {
                        String message = XMLCoreMessages.ReconcileStepForMarkup_1;
                        this.addAttributeError(message, t.text, t.offset, t.length, t.line, 13, reporter, this.getPluginPreference().getInt("missingClosingQuote"));
                        ++errorCount;
                    }
                }
            }
            ++i;
        }
    }

    private void createMissingTagError(Token token, boolean isStartTag, IReporter reporter) {
        Object[] args = new Object[]{token.text};
        String messageText = NLS.bind((String)(isStartTag ? XMLCoreMessages.Missing_end_tag_ : XMLCoreMessages.Missing_start_tag_), (Object[])args);
        LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("missingEndTag"), messageText);
        message.setOffset(token.offset);
        message.setLength(token.length);
        message.setLineNo(this.getLine(token));
        Object[] fixInfo = isStartTag ? this.getStartEndFixInfo(token.text, token) : token.text;
        this.getAnnotationMsg(reporter, isStartTag ? 2 : 15, message, fixInfo, token.length);
        if (++this.tagErrorCount > 25) {
            this.tagStack.clear();
            this.tagStack = null;
        }
    }

    private Object[] getStartEndFixInfo(String tagName, Token token) {
        IDOMNode xmlNode;
        Object[] additionalInfo = null;
        if (this.model != null && (xmlNode = (IDOMNode)this.model.getIndexedRegion(token.offset)) != null) {
            String tagClose = "/>";
            int tagCloseOffset = xmlNode.getFirstStructuredDocumentRegion().getEndOffset();
            ITextRegion last = xmlNode.getFirstStructuredDocumentRegion().getLastRegion();
            if (last != null && last.getType() == "XML_TAG_CLOSE") {
                tagClose = "/";
                --tagCloseOffset;
            }
            IDOMNode firstChild = (IDOMNode)xmlNode.getFirstChild();
            while (firstChild != null && firstChild.getNodeType() == 3) {
                firstChild = (IDOMNode)firstChild.getNextSibling();
            }
            int endOffset = xmlNode.getEndOffset();
            int firstChildStartOffset = firstChild == null ? endOffset : firstChild.getStartOffset();
            additionalInfo = new Object[]{tagName, tagClose, new Integer(tagCloseOffset), new Integer(xmlNode.getFirstStructuredDocumentRegion().getEndOffset()), new Integer(firstChildStartOffset), new Integer(endOffset)};
        }
        return additionalInfo != null ? additionalInfo : new Object[]{};
    }

    /*
     * Unable to fully structure code
     */
    private void checkTokens(XMLLineTokenizer tokenizer, IReporter reporter) throws IOException {
        previousRegion = null;
        type = null;
        region = null;
        isClosed = true;
        while ((type = this.getNextToken(tokenizer)) != null) {
            block18: {
                block19: {
                    block21: {
                        block20: {
                            block17: {
                                token = new Token(type, tokenizer.yytext(), tokenizer.getOffset(), tokenizer.yylength(), tokenizer.getLine());
                                isClosed = false;
                                if (type == "XML_CONTENT" || type == "XML_CHAR_REFERENCE" || type == "XML_ENTITY_REFERENCE" || type == "XML_PI_OPEN" || type == "XML_TAG_OPEN" || type == "XML_END_TAG_OPEN" || type == "XML_COMMENT_OPEN" || type == "XML_CDATA_OPEN" || type == "XML_DECLARATION_OPEN") {
                                    previousRegion = region;
                                    region = new ArrayList<Token>(0);
                                    region.add(token);
                                    if (type == "XML_PI_OPEN") {
                                        this.checkContentBeforeProcessingInstruction(previousRegion, reporter);
                                    } else if (type == "XML_CONTENT") {
                                        this.checkForSpaceBeforeName(token, previousRegion, reporter);
                                    }
                                    this.checkForTagClose(previousRegion, reporter);
                                    continue;
                                }
                                if (type == "XML_TAG_NAME" || type == "XML_TAG_ATTRIBUTE_NAME" || type == "XML_TAG_ATTRIBUTE_EQUALS" || type == "XML_TAG_ATTRIBUTE_VALUE" || type == "XML_COMMENT_TEXT" || type == "XML_PI_CONTENT" || type == "XML_DOCTYPE_INTERNAL_SUBSET") {
                                    region.add(token);
                                    continue;
                                }
                                if (type != "XML_PI_CLOSE" && type != "XML_TAG_CLOSE" && type != "XML_EMPTY_TAG_CLOSE" && type != "XML_COMMENT_CLOSE" && type != "XML_DECLARATION_CLOSE" && type != "XML_CDATA_CLOSE") continue;
                                region.add(token);
                                if (type != "XML_PI_CLOSE") break block17;
                                this.checkNamespacesInProcessingInstruction(region, reporter);
                                break block18;
                            }
                            if (type != "XML_TAG_CLOSE" && type != "XML_EMPTY_TAG_CLOSE") break block18;
                            this.checkEmptyTag(region, reporter);
                            regionLength = region.size();
                            if (regionLength <= 0) break block18;
                            first = (Token)region.get(0);
                            if (first.type != "XML_END_TAG_OPEN") break block19;
                            this.checkAttributsInEndTag(first, region, reporter);
                            if (first.type != "XML_END_TAG_OPEN" || this.tagStack == null || regionLength <= 1) break block18;
                            name = (Token)region.get(1);
                            if (!this.tagStack.isEmpty()) break block20;
                            this.createMissingTagError(name, false, reporter);
                            break block18;
                        }
                        if (((Token)this.tagStack.peek()).text.equals(name.text)) break block21;
                        wasFound = false;
                        stackSize = this.tagStack.size();
                        i = stackSize - 1;
                        block1: while (i >= 0) {
                            block22: {
                                pointer = (Token)this.tagStack.get(i);
                                if (!pointer.text.equals(name.text)) break block22;
                                wasFound = true;
                                top = null;
                                if (true) ** GOTO lbl56
                                do {
                                    this.createMissingTagError(top, true, reporter);
lbl56:
                                    // 2 sources

                                    if (this.tagStack.isEmpty()) break block1;
                                    top = (Token)this.tagStack.pop();
                                } while (!top.text.equals(pointer.text));
                                break;
                            }
                            --i;
                        }
                        if (!wasFound) {
                            this.createMissingTagError(name, false, reporter);
                        }
                        break block18;
                    }
                    this.tagStack.pop();
                    break block18;
                }
                if (first.type == "XML_TAG_OPEN") {
                    this.checkAttributes(region, reporter);
                    if (type == "XML_TAG_CLOSE" && this.tagStack != null && regionLength > 1) {
                        name = (Token)region.get(1);
                        if (name.type == "XML_TAG_NAME") {
                            this.tagStack.push(name);
                        }
                    }
                }
            }
            isClosed = true;
        }
        if (!isClosed && region != null && (regionLength = region.size()) > 0) {
            first = (Token)region.get(0);
            if (first.type == "XML_PI_OPEN") {
                this.checkNamespacesInProcessingInstruction(region, reporter);
            }
            if (first.type == "XML_TAG_OPEN") {
                this.checkForTagClose(region, reporter);
            }
        }
        if (this.tagStack != null) {
            while (!this.tagStack.isEmpty()) {
                this.createMissingTagError((Token)this.tagStack.pop(), true, reporter);
            }
        }
    }

    private String getNextToken(XMLLineTokenizer tokenizer) {
        String token = null;
        try {
            if (!tokenizer.isEOF()) {
                token = tokenizer.primGetNextToken();
            }
        }
        catch (IOException iOException) {}
        return token;
    }

    private void validateFile(IFile file, IReporter reporter) {
        LocalizedMessage message = new LocalizedMessage(4, file.getFullPath().toString().substring(1));
        reporter.displaySubtask((IValidator)this, (IMessage)message);
        XMLLineTokenizer tokenizer = null;
        try {
            this.tagStack = new Stack();
            this.model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
            try {
                tokenizer = this.model == null ? new XMLLineTokenizer(new BufferedReader(new InputStreamReader(file.getContents(true), this.getCharset(file)))) : new XMLLineTokenizer(new BufferedReader((Reader)new DocumentReader((IDocument)this.model.getStructuredDocument())));
                this.checkTokens(tokenizer, reporter);
            }
            finally {
                if (this.model != null) {
                    this.model.releaseFromRead();
                    this.model = null;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
    }

    private void validateProject(IValidationContext helper, final IReporter reporter) {
        if (helper instanceof IWorkbenchContext) {
            IProject project = ((IWorkbenchContext)helper).getProject();
            IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (StreamingMarkupValidator.this.shouldValidate(proxy)) {
                        StreamingMarkupValidator.this.validateFile((IFile)proxy.requestResource(), reporter);
                    }
                    return true;
                }
            };
            try {
                project.accept(visitor, 2);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    private String getCharset(IFile file) {
        if (file != null && file.isAccessible()) {
            try {
                return file.getCharset(true);
            }
            catch (CoreException coreException) {}
        }
        return ResourcesPlugin.getEncoding();
    }

    private Preferences getPluginPreference() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    private void addAttributeError(String messageText, String attributeValueText, int start, int length, int line, int problemId, IReporter reporter, int messageSeverity) {
        LocalizedMessage message = new LocalizedMessage(messageSeverity, messageText);
        message.setOffset(start);
        message.setLength(length);
        message.setLineNo(line + 1);
        this.getAnnotationMsg(reporter, problemId, message, attributeValueText, length);
    }

    private boolean shouldValidate(IResourceProxy proxy) {
        String name;
        if (proxy.getType() == 1 && (name = proxy.getName()).toLowerCase(Locale.US).endsWith(".xml")) {
            return true;
        }
        return this.shouldValidate(proxy.requestResource(), false);
    }

    private boolean shouldValidate(IResource file, boolean checkExtension) {
        String extension;
        if (file == null || !file.exists() || file.getType() != 1) {
            return false;
        }
        if (checkExtension && (extension = file.getFileExtension()) != null && "xml".endsWith(extension.toLowerCase(Locale.US))) {
            return true;
        }
        IContentDescription contentDescription = null;
        try {
            contentDescription = ((IFile)file).getContentDescription();
            if (contentDescription != null) {
                IContentType contentType = contentDescription.getContentType();
                return contentDescription != null && contentType.isKindOf(this.getXMLContentType());
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return false;
    }

    private IContentType getXMLContentType() {
        if (this.xmlContentType == null) {
            this.xmlContentType = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml");
        }
        return this.xmlContentType;
    }

    private static class Token {
        String type;
        int offset;
        int length;
        int line;
        String text;

        public Token(String type, String text, int offset, int length, int line) {
            this.type = type;
            this.text = text;
            this.offset = offset;
            this.length = length;
            this.line = line;
        }
    }
}

