/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.Arrays;
import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.core.resources.IResource;

public class BlacklistChecker
extends AbstractIndexAstChecker {
    public static final String ERR_ID = "org.eclipse.cdt.codan.internal.checkers.BlacklistProblem";
    public static final String PARAM_BLACKLIST = "blacklist";

    public void processAst(IASTTranslationUnit ast) {
        final Object[] list = (Object[])this.getPreference(this.getProblemById(ERR_ID, (IResource)this.getFile()), PARAM_BLACKLIST);
        if (list == null || list.length == 0) {
            return;
        }
        Arrays.sort(list);
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitNames = true;
            }

            public int visit(IASTName name) {
                IBinding binding = name.resolveBinding();
                String completeName = BlacklistChecker.this.getBindingQualifiedName(binding);
                if (completeName != null && Arrays.binarySearch(list, completeName) >= 0) {
                    BlacklistChecker.this.reportProblem(BlacklistChecker.ERR_ID, (IASTNode)name, new Object[]{completeName});
                }
                return 3;
            }
        });
    }

    private String getBindingQualifiedName(IBinding binding) {
        if (binding instanceof ICPPFunction) {
            ICPPFunction method = (ICPPFunction)binding;
            try {
                return String.join((CharSequence)"::", method.getQualifiedName());
            }
            catch (DOMException e) {
                CodanCheckersActivator.log(e);
            }
        } else if (binding instanceof IFunction) {
            return binding.getName();
        }
        return null;
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addListPreference(problem, PARAM_BLACKLIST, CheckersMessages.BlacklistChecker_list, CheckersMessages.BlacklistChecker_list_item);
    }
}

