/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.cdt.cmake.core.CMakeErrorParser;
import org.eclipse.cdt.cmake.core.CMakeExecutionMarkerFactory;
import org.eclipse.cdt.cmake.core.ICMakeBuildConfiguration;
import org.eclipse.cdt.cmake.core.ICMakeExecutionMarkerFactory;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.core.Messages;
import org.eclipse.cdt.cmake.core.ParsingConsoleOutputStream;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.cmake.core.internal.CMakeConsoleWrapper;
import org.eclipse.cdt.cmake.core.internal.CMakeUtils;
import org.eclipse.cdt.cmake.core.internal.CommandDescriptorBuilder;
import org.eclipse.cdt.cmake.core.properties.CMakeGenerator;
import org.eclipse.cdt.cmake.core.properties.CMakePropertiesFactory;
import org.eclipse.cdt.cmake.core.properties.ICMakeGenerator;
import org.eclipse.cdt.cmake.core.properties.ICMakeProperties;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.jsoncdb.core.CompileCommandsJsonParser;
import org.eclipse.cdt.jsoncdb.core.ISourceFileInfoConsumer;
import org.eclipse.cdt.jsoncdb.core.ParseRequest;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public class CMakeBuildConfiguration
extends CBuildConfiguration
implements ICMakeBuildConfiguration {
    private ICMakeToolChainFile toolChainFile;
    private Map<IResource, IScannerInfo> infoPerResource;
    private boolean cmakeListsModified;

    public CMakeBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
        ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
        this.toolChainFile = manager.getToolChainFileFor(this.getToolChain());
    }

    public CMakeBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, ICMakeToolChainFile toolChainFile, String launchMode, ILaunchTarget launchTarget) {
        super(config, name, toolChain, launchMode, launchTarget);
        this.toolChainFile = toolChainFile;
    }

    @Override
    public ICMakeProperties getCMakeProperties() {
        String buildType;
        String allTarget;
        String cleanTarget;
        ICMakeProperties cmakeProperties = CMakePropertiesFactory.createProperties();
        String useDefaultCMakeSettings = this.getProperty("cmake.use.default.cmake.settings");
        Map<String, String> properties = Boolean.parseBoolean(useDefaultCMakeSettings) ? this.getDefaultProperties() : this.getProperties();
        String cmakeGenerator = properties.get("cmake.generator");
        if (cmakeGenerator != null) {
            CMakeGenerator generator = CMakeGenerator.getGenerator(cmakeGenerator);
            if (generator == null) {
                cmakeProperties.setGenerator(new CustomCMakeGenerator(cmakeGenerator));
            } else {
                cmakeProperties.setGenerator(generator);
            }
        }
        String extraArgs = properties.get("cmake.arguments");
        List<String> extraArgsList = Arrays.asList(CommandLineUtil.argumentsToArray((String)extraArgs));
        cmakeProperties.setExtraArguments(extraArgsList);
        String buildCommand = properties.get("cmake.command.build");
        if (buildCommand != null && !buildCommand.isBlank()) {
            cmakeProperties.setCommand(buildCommand);
        }
        if ((cleanTarget = properties.get("cmake.target.clean")) != null && !cleanTarget.isBlank()) {
            cmakeProperties.setCleanTarget(cleanTarget);
        }
        if ((allTarget = properties.get("cmake.target.all")) != null && !allTarget.isBlank()) {
            cmakeProperties.setAllTarget(allTarget);
        }
        if ((buildType = properties.get("cmake.build.type")) == null || buildType.isBlank()) {
            buildType = this.getDefaultProperties().get("cmake.build.type");
        }
        cmakeProperties.setBuildType(buildType);
        return cmakeProperties;
    }

    public ICMakeToolChainFile getToolChainFile() {
        return this.toolChainFile;
    }

    private boolean isLocal() throws CoreException {
        IToolChain toolchain = this.getToolChain();
        return (Platform.getOS().equals(toolchain.getProperty("os")) || "linux-container".equals(toolchain.getProperty("os"))) && Platform.getOSArch().equals(toolchain.getProperty("arch"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
        try {
            ConsoleOutputStream infoStream = console.getInfoStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            boolean runCMake = this.cmakeListsModified;
            ICMakeProperties cmakeProperties = this.getCMakeProperties();
            if (!(runCMake |= !Files.exists(buildDir.resolve("CMakeCache.txt"), new LinkOption[0]))) {
                ICMakeGenerator generator = cmakeProperties.getGenerator();
                String makefileName = generator.getMakefileName();
                runCMake = makefileName == null ? true : (runCMake |= !Files.exists(buildDir.resolve(makefileName), new LinkOption[0]));
            }
            CommandDescriptorBuilder cmdBuilder = new CommandDescriptorBuilder(cmakeProperties);
            if (runCMake) {
                CMakeBuildConfiguration.deleteCMakeErrorMarkers(project);
                infoStream.write(String.format(Messages.CMakeBuildConfiguration_Configuring, buildDir));
                CommandDescriptorBuilder.CommandDescriptor command = cmdBuilder.makeCMakeCommandline(this.toolChainFile != null ? this.toolChainFile.getPath() : null);
                IProject srcFolder = project;
                command.getArguments().add(new File(srcFolder.getLocationURI()).getAbsolutePath());
                infoStream.write(String.join((CharSequence)" ", command.getArguments()) + "\n");
                Path workingDir = new Path(this.getBuildDirectory().toString());
                Throwable throwable = null;
                Object var15_19 = null;
                try (CMakeErrorParser errorParser = new CMakeErrorParser(new CMakeExecutionMarkerFactory((IContainer)srcFolder));){
                    ParsingConsoleOutputStream errStream = new ParsingConsoleOutputStream(console.getErrorStream(), errorParser);
                    CMakeConsoleWrapper errConsole = new CMakeConsoleWrapper(console, errStream);
                    Process p = this.startBuildProcess(command.getArguments(), new IEnvironmentVariable[0], (IPath)workingDir, errConsole, monitor);
                    String arg0 = command.getArguments().get(0);
                    if (p == null) {
                        String msg = String.format(Messages.CMakeBuildConfiguration_Failure, "");
                        this.addMarker(new ProblemMarkerInfo((IResource)srcFolder.getProject(), -1, msg, 3, null, (IPath)new Path(arg0)));
                        return null;
                    }
                    int exitValue = this.watchProcess(errConsole, monitor);
                    if (exitValue != 0) {
                        String msg = String.format(Messages.CMakeBuildConfiguration_ExitFailure, arg0, exitValue);
                        this.addMarker((IResource)srcFolder.getProject(), -1, msg, 3, null);
                        return null;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                this.cmakeListsModified = false;
            }
            this.getCompileCommandsFile().refreshLocal(0, monitor);
            this.processCompileCommandsFile(console, monitor);
            infoStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingIn, buildDir.toString()));
            Throwable throwable = null;
            Object var12_14 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                epm.setOutputStream((OutputStream)console.getOutputStream());
                String envStr = this.getProperty("cmake.environment");
                ArrayList<EnvironmentVariable> envVars = new ArrayList<EnvironmentVariable>();
                if (envStr != null) {
                    List<String> envList = CMakeUtils.stripEnvVars(envStr);
                    for (String s : envList) {
                        int index = s.indexOf("=");
                        if (index == -1) {
                            envVars.add(new EnvironmentVariable(s));
                            continue;
                        }
                        envVars.add(new EnvironmentVariable(s.substring(0, index), s.substring(index + 1)));
                    }
                }
                CommandDescriptorBuilder.CommandDescriptor commandDescr = cmdBuilder.makeCMakeBuildCommandline(cmakeProperties.getAllTarget());
                List<String> command = commandDescr.getArguments();
                infoStream.write(String.join((CharSequence)" ", command) + "\n");
                Path workingDir = new Path(this.getBuildDirectory().toString());
                Process p = this.startBuildProcess(command, envVars.toArray(new IEnvironmentVariable[0]), (IPath)workingDir, console, monitor);
                if (p == null) {
                    console.getErrorStream().write(String.format(Messages.CMakeBuildConfiguration_Failure, ""));
                    return null;
                }
                int exitValue = this.watchProcess(new IConsoleParser[]{epm}, monitor);
                if (exitValue != 0) {
                    String msg2 = String.format(Messages.CMakeBuildConfiguration_ExitFailure, command.get(0), exitValue);
                    this.addMarker((IResource)project, -1, msg2, 3, null);
                }
                project.refreshLocal(2, monitor);
                infoStream.write(String.format(Messages.CMakeBuildConfiguration_BuildingComplete, epm.getErrorCount(), epm.getWarningCount(), buildDir.toString()));
                return new IProject[]{project};
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_Building, project.getName()), e));
        }
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ICMakeProperties cmakeProperties = this.getCMakeProperties();
            CommandDescriptorBuilder cmdBuilder = new CommandDescriptorBuilder(cmakeProperties);
            CommandDescriptorBuilder.CommandDescriptor command = cmdBuilder.makeCMakeBuildCommandline(cmakeProperties.getCleanTarget());
            ConsoleOutputStream infoStream = console.getInfoStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            if (!Files.exists(buildDir.resolve("CMakeFiles"), new LinkOption[0])) {
                infoStream.write(Messages.CMakeBuildConfiguration_NotFound);
                return;
            }
            infoStream.write(String.join((CharSequence)" ", command.getArguments()) + "\n");
            Path workingDir = new Path(this.getBuildDirectory().toString());
            Process p = this.startBuildProcess(command.getArguments(), new IEnvironmentVariable[0], (IPath)workingDir, console, monitor);
            if (p == null) {
                String msg = String.format(Messages.CMakeBuildConfiguration_Failure, "");
                this.addMarker(new ProblemMarkerInfo((IResource)project, -1, msg, 3, null, (IPath)new Path(command.getArguments().get(0))));
                return;
            }
            int exitValue = this.watchProcess(console, monitor);
            if (exitValue != 0) {
                String msg = String.format(Messages.CMakeBuildConfiguration_ExitFailure, command.getArguments().get(0), exitValue);
                this.addMarker((IResource)project, -1, msg, 3, null);
            }
            infoStream.write(Messages.CMakeBuildConfiguration_BuildComplete);
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus(String.format(Messages.CMakeBuildConfiguration_Cleaning, project.getName()), e));
        }
    }

    private IFile getCompileCommandsFile() throws CoreException {
        return this.getBuildContainer().getFile((IPath)new Path("compile_commands.json"));
    }

    private void processCompileCommandsFile(IConsole console, IProgressMonitor monitor) throws CoreException {
        IFile file = this.getCompileCommandsFile();
        CompileCommandsJsonParser parser = new CompileCommandsJsonParser(new ParseRequest(file, (ISourceFileInfoConsumer)new CMakeIndexerInfoConsumer(this::setScannerInformation), CommandLauncherManager.getInstance().getCommandLauncher((ICBuildConfiguration)this), console));
        parser.parse(monitor);
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        if (this.infoPerResource == null) {
            try {
                this.processCompileCommandsFile(null, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return this.infoPerResource == null ? null : this.infoPerResource.get(resource);
    }

    private void setScannerInformation(Map<IResource, IScannerInfo> infoPerResource) {
        this.infoPerResource = infoPerResource;
    }

    public void elementChanged(ElementChangedEvent event) {
        super.elementChanged(event);
        if (event.getType() != 1) {
            return;
        }
        if (!this.cmakeListsModified) {
            this.processElementDelta(event.getDelta());
        }
    }

    private boolean processElementDelta(ICElementDelta delta) {
        int n;
        IResourceDelta[] resourceDeltas;
        if (delta == null) {
            return true;
        }
        if (delta.getKind() == 4 && (delta.getFlags() & 1) != 0 && (resourceDeltas = delta.getResourceDeltas()) != null) {
            IResourceDelta[] iResourceDeltaArray = resourceDeltas;
            int n2 = resourceDeltas.length;
            n = 0;
            while (n < n2) {
                IResourceDelta resourceDelta = iResourceDeltaArray[n];
                IResource resource = resourceDelta.getResource();
                if (resource.getType() == 1) {
                    String name = resource.getName();
                    if (!resource.isDerived(512) && (name.equals("CMakeLists.txt") || name.endsWith(".cmake"))) {
                        this.cmakeListsModified = true;
                        return false;
                    }
                }
                ++n;
            }
        }
        ICElementDelta[] iCElementDeltaArray = delta.getAffectedChildren();
        n = iCElementDeltaArray.length;
        int n3 = 0;
        while (n3 < n) {
            ICElementDelta child = iCElementDeltaArray[n3];
            if (!this.processElementDelta(child)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean processLine(String line) {
        return true;
    }

    public boolean processLine(String line, List<Job> jobsArray) {
        return true;
    }

    public void shutdown() {
    }

    private static void deleteCMakeErrorMarkers(IProject project) throws CoreException {
        project.deleteMarkers(ICMakeExecutionMarkerFactory.CMAKE_PROBLEM_MARKER_ID, false, 2);
    }

    public Map<String, String> getDefaultProperties() {
        return Map.of("cmake.generator", "Ninja", "cmake.use.default.cmake.settings", "true", "cmake.arguments", "", "cmake.command.build", "cmake", "cmake.target.all", "all", "cmake.target.clean", "clean", "cmake.build.type", "debug".equals(this.getLaunchMode()) ? "Debug" : "Release");
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.getDefaultProperties());
        map.putAll(super.getProperties());
        return map;
    }

    public String getProperty(String name) {
        return this.getSettings().get(name, this.getDefaultProperties().get(name));
    }

    private static class CMakeIndexerInfoConsumer
    implements ISourceFileInfoConsumer {
        private Map<IResource, IScannerInfo> infoPerResource = new HashMap<IResource, IScannerInfo>();
        private boolean haveUpdates;
        private final Consumer<Map<IResource, IScannerInfo>> resultSetter;

        public CMakeIndexerInfoConsumer(Consumer<Map<IResource, IScannerInfo>> resultSetter) {
            this.resultSetter = Objects.requireNonNull(resultSetter);
        }

        public void acceptSourceFileInfo(String sourceFileName, List<String> systemIncludePaths, Map<String, String> definedSymbols, List<String> includePaths, List<String> macroFiles, List<String> includeFiles) {
            IFile file = this.getFileForCMakePath(sourceFileName);
            if (file != null) {
                ExtendedScannerInfo info = new ExtendedScannerInfo(definedSymbols, (String[])systemIncludePaths.stream().toArray(String[]::new), (String[])macroFiles.stream().toArray(String[]::new), (String[])includeFiles.stream().toArray(String[]::new), (String[])includePaths.stream().toArray(String[]::new));
                this.infoPerResource.put((IResource)file, (IScannerInfo)info);
                this.haveUpdates = true;
            }
        }

        private IFile getFileForCMakePath(String sourceFileName) {
            Path path = new Path(sourceFileName);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            return file;
        }

        public void shutdown() {
            if (this.haveUpdates) {
                this.resultSetter.accept(this.infoPerResource);
                this.infoPerResource = null;
                this.haveUpdates = false;
            }
        }
    }

    private static final class CustomCMakeGenerator
    implements ICMakeGenerator {
        private final String cmakeGenerator;

        private CustomCMakeGenerator(String cmakeGenerator) {
            this.cmakeGenerator = cmakeGenerator;
        }

        @Override
        public String getMakefileName() {
            return null;
        }

        @Override
        public String getIgnoreErrOption() {
            return null;
        }

        @Override
        public String getCMakeName() {
            return this.cmakeGenerator;
        }
    }
}

