/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.ui.refactoring.rename.ASTManager;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringArgument;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringUtils;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameGlobalProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class CRenameMethodProcessor
extends CRenameGlobalProcessor {
    public CRenameMethodProcessor(CRenameProcessor processor, String kind, boolean isVirtual) {
        super(processor, kind);
        if (isVirtual) {
            this.setAvailableOptions(this.getAvailableOptions() | 0x80);
        }
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws OperationCanceledException, CoreException {
        CRefactoringArgument argument = this.getArgument();
        IBinding binding = argument.getBinding();
        if (binding instanceof ICPPConstructor) {
            return RefactoringStatus.createFatalErrorStatus((String)RenameMessages.CRenameMethodProcessor_fatalError_renameConstructor);
        }
        String identifier = argument.getName();
        if (identifier.startsWith("~")) {
            return RefactoringStatus.createFatalErrorStatus((String)RenameMessages.CRenameMethodProcessor_fatalError_renameDestructor);
        }
        if (identifier.startsWith("operator") && identifier.length() > 8 && !CRefactoringUtils.isIdentifierChar(identifier.charAt(8))) {
            return RefactoringStatus.createFatalErrorStatus((String)RenameMessages.CRenameMethodProcessor_fatalError_renameOperator);
        }
        return super.checkInitialConditions(pm);
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException, CoreException {
        IASTNode node;
        CRefactoringArgument argument = this.getArgument();
        RefactoringStatus result = new RefactoringStatus();
        IScope scope = argument.getScope();
        if (scope != null && (node = ASTInternal.getPhysicalNodeOfScope((IScope)scope)) instanceof IASTCompositeTypeSpecifier) {
            IASTCompositeTypeSpecifier se = (IASTCompositeTypeSpecifier)node;
            IASTName name = ASTManager.getSimpleName(se.getName());
            if (this.getReplacementText().equals(name.toString())) {
                return RefactoringStatus.createFatalErrorStatus((String)RenameMessages.CRenameMethodProcessor_fatalError_renameToConstructor);
            }
            if (this.getReplacementText().startsWith("~")) {
                return RefactoringStatus.createFatalErrorStatus((String)RenameMessages.CRenameMethodProcessor_fatalError_renameToDestructor);
            }
            if (!CRefactoringUtils.checkIdentifier(this.getReplacementText())) {
                result.merge(RefactoringStatus.createErrorStatus((String)RenameMessages.CRenameMethodProcessor_warning_illegalCharacters));
            }
        }
        if (argument.getArgumentKind() == 8 && (this.getSelectedOptions() & 0x80) == 0) {
            result.merge(RefactoringStatus.createWarningStatus((String)RenameMessages.CRenameMethodProcessor_warning_renameVirtual));
        }
        result.merge(super.checkFinalConditions(monitor, context));
        return result;
    }

    @Override
    protected IBinding[] getBindingsToBeRenamed(RefactoringStatus status) {
        ArrayList<Object> bindings;
        block8: {
            if ((this.getSelectedOptions() & 0x80) == 0) {
                return super.getBindingsToBeRenamed(status);
            }
            CRefactoringArgument argument = this.getArgument();
            IBinding binding = argument.getBinding();
            IASTNode node = ASTInternal.getPhysicalNodeOfScope((IScope)argument.getScope());
            bindings = new ArrayList<Object>();
            if (binding != null) {
                this.recordRename(binding);
                bindings.add(binding);
            }
            if (binding instanceof ICPPMethod) {
                ICPPMethod m = (ICPPMethod)binding;
                try {
                    try {
                        CPPSemantics.pushLookupPoint((IASTNode)node);
                        ICPPMethod[] bs = ClassTypeHelper.findOverridden((ICPPMethod)m);
                        bindings.addAll(Arrays.asList(bs));
                        bs = ClassTypeHelper.findOverriders((IIndex)this.getIndex(), (ICPPMethod)m);
                        bindings.addAll(Arrays.asList(bs));
                    }
                    catch (CoreException e) {
                        status.addError(e.getMessage());
                        CPPSemantics.popLookupPoint();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    CPPSemantics.popLookupPoint();
                    throw throwable;
                }
                CPPSemantics.popLookupPoint();
            }
        }
        return bindings.toArray(new IBinding[bindings.size()]);
    }
}

