/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.expressions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class CPropertyTester
extends PropertyTester {
    private static final String KEY_SRC = "isSource";
    private static final String KEY_PREF = "checkPreference";
    private static final Pattern PREFERENCE_PATTERN = Pattern.compile("(.*)[/:](.*)=(.*)");

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Matcher matcher;
        if (KEY_SRC.equals(property)) {
            if (receiver instanceof ITranslationUnit) {
                return ((ITranslationUnit)receiver).isSourceUnit();
            }
            if (receiver instanceof IFile) {
                IFile file = (IFile)receiver;
                return CoreModel.isValidSourceUnitName((IProject)file.getProject(), (String)file.getName());
            }
        } else if (KEY_PREF.equals(property) && expectedValue instanceof String && (matcher = PREFERENCE_PATTERN.matcher((String)expectedValue)).matches()) {
            String pluginId = matcher.group(1);
            String preference = matcher.group(2);
            String wantedValue = matcher.group(3);
            IPreferencesService preferences = Platform.getPreferencesService();
            String actualValue = preferences.getString(pluginId, preference, null, null);
            if (wantedValue != null) {
                return wantedValue.equals(actualValue) || actualValue == null && wantedValue.equals("false");
            }
            return actualValue != null;
        }
        return false;
    }
}

