/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupViewer;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NewLaunchConfigEditPage
extends WizardPage
implements IPageChangingListener {
    private ILaunchConfigurationWorkingCopy workingCopy;
    private LaunchConfigurationDialogExt launchConfigurationDialog = new LaunchConfigurationDialogExt();
    private LaunchConfigurationTabGroupViewerExt tabViewer;
    private ILaunchGroup launchGroup;
    private ILaunchConfigurationType launchConfigType;

    public NewLaunchConfigEditPage() {
        super(Messages.NewLaunchConfigEditPage_0);
        this.setTitle(Messages.NewLaunchConfigEditPage_1);
        this.setDescription(Messages.NewLaunchConfigEditPage_2);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)comp);
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog((ILaunchConfigurationDialog)this.launchConfigurationDialog);
        this.tabViewer = new LaunchConfigurationTabGroupViewerExt(comp, (ILaunchConfigurationDialog)this.launchConfigurationDialog);
        this.launchConfigurationDialog.setTabViewer(this.tabViewer);
        GridData data = new GridData(4, 1, true, false);
        data.heightHint = 500;
        this.tabViewer.getControl().setLayoutData((Object)data);
        parent.layout(true, true);
        this.validateFields();
    }

    public void setLaunchGroup(ILaunchGroup launchGroup) {
        this.launchGroup = launchGroup;
    }

    public void setLaunchConfigType(ILaunchConfigurationType type) {
        this.launchConfigType = type;
    }

    public ILaunchConfigurationWorkingCopy getWorkingCopy() {
        return this.workingCopy;
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (this.launchConfigType == null || event.getTargetPage() != this) {
            if (this.tabViewer != null) {
                this.tabViewer.setInput(null);
            }
            return;
        }
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog((ILaunchConfigurationDialog)this.launchConfigurationDialog);
        if (this.tabViewer != null) {
            try {
                String name = this.launchConfigurationDialog.generateName("launchConfiguration");
                this.workingCopy = this.launchConfigType.newInstance(null, name);
                this.launchConfigurationDialog.doSetDefaults(this.workingCopy);
                this.tabViewer.setInput(this.workingCopy);
                this.setTitle(String.format(Messages.NewLaunchConfigEditPage_7, this.launchConfigType.getName()));
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
    }

    public boolean performFinish() {
        if (this.workingCopy == null) {
            return false;
        }
        this.workingCopy.rename(this.tabViewer.getWorkingCopy().getName());
        this.tabViewer.getTabGroup().performApply(this.workingCopy);
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog(null);
        return true;
    }

    public void dispose() {
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog(null);
    }

    public void validateFields() {
        this.setPageComplete(false);
        if (this.workingCopy == null) {
            return;
        }
        String message = this.tabViewer.getErrorMesssage();
        this.setErrorMessage(message);
        if (this.getErrorMessage() != null) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    public LaunchGroupExtension getLaunchGroup() {
        if (this.workingCopy == null) {
            return null;
        }
        if (this.launchGroup == null) {
            return null;
        }
        LaunchGroupExtension groupExt = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(this.launchGroup.getIdentifier());
        return groupExt;
    }

    private class LaunchConfigurationDialogExt
    extends LaunchConfigurationDialog {
        public LaunchConfigurationDialogExt() {
            super(NewLaunchConfigEditPage.this.getShell(), null, null);
        }

        protected ILaunchConfiguration getLaunchConfiguration() {
            return NewLaunchConfigEditPage.this.workingCopy;
        }

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            if (this.getLaunchConfiguration() == null) {
                return;
            }
            super.launchConfigurationAdded(configuration);
        }

        public LaunchGroupExtension getLaunchGroup() {
            return NewLaunchConfigEditPage.this.getLaunchGroup();
        }

        public void updateMessage() {
            NewLaunchConfigEditPage.this.validateFields();
        }

        public void updateButtons() {
            this.getTabViewer().refresh();
        }

        public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        }

        public String generateName(String name) {
            if (name == null) {
                return "";
            }
            return DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(name);
        }

        public void doSetDefaults(ILaunchConfigurationWorkingCopy wc) {
            super.doSetDefaults(wc);
        }

        public void setTabViewer(LaunchConfigurationTabGroupViewer viewer) {
            super.setTabViewer(viewer);
        }

        public boolean isTreeSelectionEmpty() {
            return false;
        }
    }

    private class LaunchConfigurationTabGroupViewerExt
    extends LaunchConfigurationTabGroupViewer {
        public LaunchConfigurationTabGroupViewerExt(Composite parent, ILaunchConfigurationDialog dialog) {
            super(parent, dialog);
        }

        public ILaunchConfigurationWorkingCopy getWorkingCopy() {
            return super.getWorkingCopy();
        }

        protected void handleTabSelected() {
            super.handleTabSelected();
            NewLaunchConfigEditPage.this.setMessage(this.getWarningMessage(), 2);
        }
    }
}

