/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.IPath;
import org.eclipse.remote.internal.jsch.core.Activator;
import org.eclipse.remote.internal.jsch.core.JschFileStore;

public class JSchFileSystem
extends FileSystem {
    public static String getConnectionNameFor(URI uri) {
        return uri.getAuthority();
    }

    public static URI getURIFor(String connectionName, String path) {
        try {
            return new URI("ssh", connectionName, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public int attributes() {
        return 102;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public IFileStore getStore(IPath path) {
        return EFS.getNullFileSystem().getStore(path);
    }

    public IFileStore getStore(URI uri) {
        try {
            return JschFileStore.getInstance(uri);
        }
        catch (Exception e) {
            Activator.log(e);
            return EFS.getNullFileSystem().getStore(uri);
        }
    }
}

