/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.FactoryPluginManager;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPathUtil;
import org.eclipse.jdt.apt.core.util.IFactoryPath;

public class FactoryPath
implements IFactoryPath {
    private final Map<FactoryContainer, Attributes> _path = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public void addExternalJar(File jar) {
        FactoryContainer fc = FactoryPathUtil.newExtJarFactoryContainer(jar);
        Attributes a = new Attributes(true, false);
        this.internalAdd(fc, a);
    }

    @Override
    public void removeExternalJar(File jar) {
        FactoryContainer fc = FactoryPathUtil.newExtJarFactoryContainer(jar);
        this._path.remove(fc);
    }

    @Override
    public void addVarJar(IPath jarPath) {
        FactoryContainer fc = FactoryPathUtil.newVarJarFactoryContainer(jarPath);
        Attributes a = new Attributes(true, false);
        this.internalAdd(fc, a);
    }

    @Override
    public void removeVarJar(IPath jarPath) {
        FactoryContainer fc = FactoryPathUtil.newVarJarFactoryContainer(jarPath);
        this._path.remove(fc);
    }

    @Override
    public void addWkspJar(IPath jarPath) {
        FactoryContainer fc = FactoryPathUtil.newWkspJarFactoryContainer(jarPath);
        Attributes a = new Attributes(true, false);
        this.internalAdd(fc, a);
    }

    @Override
    public void removeWkspJar(IPath jarPath) {
        FactoryContainer fc = FactoryPathUtil.newWkspJarFactoryContainer(jarPath);
        this._path.remove(fc);
    }

    @Override
    public void enablePlugin(String pluginId) throws CoreException {
        FactoryContainer fc = FactoryPluginManager.getPluginFactoryContainer(pluginId);
        Attributes a = this._path.get(fc);
        if (a == null) {
            Status status = AptPlugin.createWarningStatus(new IllegalArgumentException(), "Specified plugin was not found, so it could not be added to the annotation processor factory path: " + pluginId);
            throw new CoreException((IStatus)status);
        }
        a.setEnabled(true);
        this.internalAdd(fc, a);
    }

    @Override
    public void disablePlugin(String pluginId) {
        FactoryContainer fc = FactoryPluginManager.getPluginFactoryContainer(pluginId);
        Attributes a = this._path.get(fc);
        if (a != null) {
            a.setEnabled(false);
        }
    }

    public void addEntryToHead(FactoryContainer fc, boolean enabled, boolean runInBatchMode) {
        Attributes a = new Attributes(enabled, runInBatchMode);
        this.internalAdd(fc, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainers(Map<FactoryContainer, Attributes> map) {
        Map<FactoryContainer, Attributes> map2 = this._path;
        synchronized (map2) {
            this._path.clear();
            for (Map.Entry<FactoryContainer, Attributes> entry : FactoryPath.getReversed(map.entrySet())) {
                this._path.put(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalAdd(FactoryContainer fc, Attributes a) {
        Map<FactoryContainer, Attributes> map = this._path;
        synchronized (map) {
            this._path.remove(fc);
            this._path.put(fc, a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<FactoryContainer, Attributes> getEnabledContainers() {
        LinkedHashMap<FactoryContainer, Attributes> map = new LinkedHashMap<FactoryContainer, Attributes>();
        Map<FactoryContainer, Attributes> map2 = this._path;
        synchronized (map2) {
            for (Map.Entry<FactoryContainer, Attributes> entry : FactoryPath.getReversed(this._path.entrySet())) {
                Attributes attr = entry.getValue();
                if (!attr.isEnabled()) continue;
                Attributes attrClone = new Attributes(attr);
                map.put(entry.getKey(), attrClone);
            }
        }
        return map;
    }

    private static <T> List<T> getReversed(Collection<T> collection) {
        ArrayList<T> result = new ArrayList<T>(collection);
        Collections.reverse(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<FactoryContainer, Attributes> getAllContainers() {
        LinkedHashMap<FactoryContainer, Attributes> map = new LinkedHashMap<FactoryContainer, Attributes>(this._path.size());
        Map<FactoryContainer, Attributes> map2 = this._path;
        synchronized (map2) {
            for (Map.Entry<FactoryContainer, Attributes> entry : FactoryPath.getReversed(this._path.entrySet())) {
                map.put(entry.getKey(), new Attributes(entry.getValue()));
            }
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FactoryPath)) {
            return false;
        }
        FactoryPath other = (FactoryPath)o;
        return this._path.equals(other._path);
    }

    public static class Attributes {
        private boolean _enabled;
        private boolean _runInBatchMode;

        public Attributes(boolean enabled, boolean runInBatchMode) {
            this._enabled = enabled;
            this._runInBatchMode = runInBatchMode;
        }

        public Attributes(Attributes attr) {
            this._enabled = attr._enabled;
            this._runInBatchMode = attr._runInBatchMode;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Attributes)) {
                return false;
            }
            Attributes oA = (Attributes)o;
            return this._enabled == oA._enabled && this._runInBatchMode == oA._runInBatchMode;
        }

        public int hashCode() {
            return (this._enabled ? 1 : 0) + (this._runInBatchMode ? 2 : 0);
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public boolean runInBatchMode() {
            return this._runInBatchMode;
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public void setRunInBatchMode(boolean runInBatchMode) {
            this._runInBatchMode = runInBatchMode;
        }
    }
}

