/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointContainer;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.ui.IBreakpointOrganizerDelegateExtension;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class BreakpointsViewer
extends CheckboxTreeViewer {
    public BreakpointsViewer(Tree tree) {
        super(tree);
    }

    public Item[] getSelectedItems() {
        return this.getSelection(this.getControl());
    }

    public Widget searchItem(Object element) {
        return this.findItem(element);
    }

    public void refreshItem(TreeItem item) {
        this.updateItem((Widget)item, item.getData());
    }

    public IBreakpoint[] getVisibleBreakpoints() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        ArrayList<IBreakpoint> list = new ArrayList<IBreakpoint>();
        Object[] objectArray = ((ITreeContentProvider)this.getContentProvider()).getElements((Object)manager);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            TreeItem item = (TreeItem)this.searchItem(element);
            if (item != null) {
                this.collectExpandedBreakpoints(item, list);
            }
            ++n2;
        }
        return list.toArray(new IBreakpoint[list.size()]);
    }

    private void collectExpandedBreakpoints(TreeItem item, List<IBreakpoint> list) {
        Object data = item.getData();
        if (data instanceof IBreakpoint) {
            list.add((IBreakpoint)data);
            return;
        }
        if (item.getExpanded()) {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem childItem = treeItemArray[n2];
                this.collectExpandedBreakpoints(childItem, list);
                ++n2;
            }
        }
    }

    protected void setSelection(TreeItem item) {
        this.getTree().setSelection(new TreeItem[]{item});
        this.updateSelection(this.getSelection());
    }

    public IBreakpointContainer getRemovableContainer(Item item) {
        TreePath path;
        if (item == null) {
            return null;
        }
        if (item.getData() instanceof IBreakpoint && (path = this.getTreePathFromItem(item)) != null) {
            IBreakpoint breakpoint = (IBreakpoint)path.getLastSegment();
            IBreakpointContainer container = null;
            int i = path.getSegmentCount() - 2;
            while (i > -1) {
                container = (IBreakpointContainer)path.getSegment(i);
                if (container.contains(breakpoint) && container.getOrganizer().canRemove(breakpoint, container.getCategory())) {
                    return container;
                }
                --i;
            }
        }
        return null;
    }

    public IBreakpointContainer getAddableContainer(Item item) {
        Object element;
        TreePath path = this.getTreePathFromItem(item);
        if (path != null && (element = path.getLastSegment()) instanceof IBreakpoint) {
            IBreakpoint breakpoint = (IBreakpoint)element;
            IBreakpointContainer container = null;
            int i = path.getSegmentCount() - 2;
            while (i > -1) {
                container = (IBreakpointContainer)path.getSegment(i);
                if (container.contains(breakpoint) && container.getOrganizer().canAdd(breakpoint, container.getCategory())) {
                    return container;
                }
                --i;
            }
        }
        return null;
    }

    public boolean canDrag(Item[] items) {
        if (items == null) {
            return false;
        }
        if (items.length == 0) {
            return false;
        }
        Item[] itemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (this.getRemovableContainer(item) == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void performDrag(Item[] items) {
        if (items == null) {
            return;
        }
        HashMap<IBreakpointContainer, ArrayList<IBreakpoint>> containersToBreakpoints = new HashMap<IBreakpointContainer, ArrayList<IBreakpoint>>();
        IBreakpointContainer container = null;
        IBreakpoint breakpoint = null;
        Item[] itemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (!item.isDisposed()) {
                breakpoint = (IBreakpoint)item.getData();
                container = this.getRemovableContainer(item);
                if (container != null) {
                    ArrayList<IBreakpoint> list = (ArrayList<IBreakpoint>)containersToBreakpoints.get(container);
                    if (list == null) {
                        list = new ArrayList<IBreakpoint>();
                        containersToBreakpoints.put(container, list);
                    }
                    list.add(breakpoint);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : containersToBreakpoints.entrySet()) {
            container = (IBreakpointContainer)entry.getKey();
            List list = (List)entry.getValue();
            IBreakpointOrganizer organizer = container.getOrganizer();
            IBreakpoint[] breakpoints = list.toArray(new IBreakpoint[list.size()]);
            if (organizer instanceof IBreakpointOrganizerDelegateExtension) {
                IBreakpointOrganizerDelegateExtension extension = (IBreakpointOrganizerDelegateExtension)((Object)organizer);
                extension.removeBreakpoints(breakpoints, container.getCategory());
                continue;
            }
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n3 = breakpoints.length;
            int n4 = 0;
            while (n4 < n3) {
                IBreakpoint bp = iBreakpointArray[n4];
                organizer.removeBreakpoint(bp, container.getCategory());
                ++n4;
            }
        }
    }

    public boolean canDrop(Item target, IStructuredSelection selection) {
        if (selection == null || target == null) {
            return false;
        }
        for (Object currentObject : selection) {
            if (currentObject instanceof IBreakpoint && this.checkAddableParentContainers(target, (IBreakpoint)currentObject)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAddableParentContainers(Item target, IBreakpoint breakpoint) {
        IBreakpointContainer container = null;
        TreePath path = this.getTreePathFromItem(target);
        if (path != null) {
            Object element = null;
            int i = path.getSegmentCount() - 1;
            while (i > -1) {
                element = path.getSegment(i);
                if (element instanceof IBreakpointContainer && ((container = (IBreakpointContainer)element).contains(breakpoint) || !container.getOrganizer().canAdd(breakpoint, container.getCategory()))) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    public boolean performDrop(Item target, IStructuredSelection selection) {
        IBreakpointContainer i;
        IBreakpointContainer container;
        if (target == null || selection == null) {
            return false;
        }
        IBreakpoint breakpoint2 = null;
        Object element = target.getData();
        IBreakpointContainer iBreakpointContainer = container = element instanceof IBreakpointContainer ? (i = (IBreakpointContainer)element) : this.getAddableContainer(target);
        if (container == null) {
            return false;
        }
        IBreakpointOrganizer organizer = container.getOrganizer();
        if (organizer instanceof IBreakpointOrganizerDelegateExtension) {
            IBreakpointOrganizerDelegateExtension extension = (IBreakpointOrganizerDelegateExtension)((Object)organizer);
            Object[] array = selection.toArray();
            IBreakpoint[] breakpoints = new IBreakpoint[array.length];
            System.arraycopy(array, 0, breakpoints, 0, array.length);
            extension.addBreakpoints(breakpoints, container.getCategory());
        } else {
            for (IBreakpoint breakpoint2 : selection) {
                organizer.addBreakpoint(breakpoint2, container.getCategory());
            }
        }
        this.expandToLevel(target.getData(), -1);
        return true;
    }

    public void refresh() {
        super.refresh();
        this.initializeCheckedState();
    }

    private void initializeCheckedState() {
        TreeItem[] treeItemArray = this.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.updateCheckedState(item);
            ++n2;
        }
    }

    public void updateCheckedState(Object element) {
        Widget[] widgetArray = this.searchItems(element);
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            if (widget != null) {
                this.updateCheckedState((TreeItem)widget);
            }
            ++n2;
        }
    }

    private Widget[] searchItems(Object element) {
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = this.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.findAllOccurrences(item, element, list);
            ++n2;
        }
        return list.toArray(new Widget[0]);
    }

    private void findAllOccurrences(TreeItem item, Object element, ArrayList<TreeItem> list) {
        if (element.equals(item.getData())) {
            list.add(item);
        }
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem childItem = treeItemArray[n2];
            this.findAllOccurrences(childItem, element, list);
            ++n2;
        }
    }

    public void updateCheckedState(TreeItem item) {
        Object element = item.getData();
        if (element instanceof IBreakpoint) {
            try {
                item.setChecked(((IBreakpoint)element).isEnabled());
                this.refreshItem(item);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        } else if (element instanceof IBreakpointContainer) {
            IBreakpoint[] breakpoints = ((IBreakpointContainer)element).getBreakpoints();
            int enabledChildren = 0;
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                try {
                    if (breakpoint.isEnabled()) {
                        ++enabledChildren;
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
                ++n2;
            }
            if (enabledChildren == 0) {
                item.setGrayed(false);
                item.setChecked(false);
            } else if (enabledChildren == breakpoints.length) {
                item.setGrayed(false);
                item.setChecked(true);
            } else {
                item.setGrayed(true);
                item.setChecked(true);
            }
            iBreakpointArray = item.getItems();
            n = iBreakpointArray.length;
            n2 = 0;
            while (n2 < n) {
                IBreakpoint childItem = iBreakpointArray[n2];
                this.updateCheckedState((TreeItem)childItem);
                ++n2;
            }
        }
    }
}

