/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ReferenceConnection;

public class CenteredIconFigure
extends RoundedRectangle {
    public static final int NORMAL = 0;
    public static final int SELECTED = 1;
    public static final int HOVER = 2;
    public Image image;
    protected Label toolTipLabel;
    protected int mode = 0;

    public CenteredIconFigure() {
        this.setFill(true);
        this.toolTipLabel = new Label();
        this.setCornerDimensions(new Dimension(5, 5));
    }

    public CenteredIconFigure(Image img) {
        this();
        this.image = img;
    }

    public void refresh() {
        this.repaint();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void outlineShape(Graphics graphics) {
        graphics.pushState();
        try {
            if (this.mode == 0) {
                graphics.setForegroundColor(ReferenceConnection.inactiveConnection);
            } else if (this.mode == 1) {
                boolean highContrast = false;
                try {
                    highContrast = Display.getDefault().getHighContrast();
                }
                catch (Exception exception) {}
                if (highContrast) {
                    graphics.setForegroundColor(Display.getDefault().getSystemColor(21));
                } else {
                    graphics.setForegroundColor(ColorConstants.black);
                }
            }
            super.outlineShape(graphics);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            graphics.popState();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        graphics.popState();
    }

    protected void fillShape(Graphics g) {
        super.fillShape(g);
        if (this.image != null) {
            Rectangle r = this.getBounds();
            Dimension imageSize = new Dimension(15, 15);
            g.drawImage(this.image, r.x + (r.width - imageSize.width) / 2, r.y + (r.height - imageSize.height) / 2 - 1);
        }
    }

    public Label getToolTipLabel() {
        return this.toolTipLabel;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setToolTipText(String text) {
        if (text.length() > 0) {
            this.setToolTip((IFigure)this.toolTipLabel);
            this.toolTipLabel.setText(text);
        } else {
            this.setToolTip(null);
        }
    }
}

