/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMultiDetach;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.IEnabledStateRequest;

public class GdbDisconnectCommand
implements IDisconnectHandler {
    private final DsfSession fSession;
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public GdbDisconnectCommand(DsfSession session) {
        this.fSession = session;
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length == 0) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.getContainerDMContexts(request.getElements(), new DataRequestMonitor<IRunControl.IContainerDMContext[]>((Executor)this.fExecutor, null){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    request.setEnabled(false);
                    request.done();
                } else {
                    GdbDisconnectCommand.this.canDisconnect((IRunControl.IContainerDMContext[])this.getData(), (DataRequestMonitor<Boolean>)new ImmediateDataRequestMonitor<Boolean>(){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                request.setEnabled(false);
                            } else {
                                request.setEnabled(((Boolean)this.getData()).booleanValue());
                            }
                            request.done();
                        }
                    });
                }
            }
        });
    }

    public boolean execute(final IDebugCommandRequest request) {
        if (request.getElements().length == 0) {
            request.done();
            return false;
        }
        this.getContainerDMContexts(request.getElements(), new DataRequestMonitor<IRunControl.IContainerDMContext[]>((Executor)this.fExecutor, null){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    request.setStatus(this.getStatus());
                    request.done();
                } else {
                    GdbDisconnectCommand.this.disconnect((IRunControl.IContainerDMContext[])this.getData(), (RequestMonitor)new ImmediateRequestMonitor(){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                request.setStatus(this.getStatus());
                                request.done();
                            } else {
                                GdbDisconnectCommand.this.waitForTermination(request);
                            }
                        }
                    });
                }
            }
        });
        return false;
    }

    private void waitForTermination(final IDebugCommandRequest request) {
        if (!DsfSession.isSessionActive((String)this.fSession.getId())) {
            request.done();
            return;
        }
        DsfSession.SessionEndedListener endedListener = new DsfSession.SessionEndedListener(){

            public void sessionEnded(DsfSession session) {
                if (GdbDisconnectCommand.this.fSession.equals((Object)session)) {
                    DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this);
                    request.done();
                }
            }
        };
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)endedListener);
        this.fExecutor.schedule(() -> {
            if (DsfSession.isSessionActive((String)this.fSession.getId())) {
                DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)endedListener);
                request.setStatus(Status.CANCEL_STATUS);
                request.done();
            }
        }, 1L, TimeUnit.MINUTES);
    }

    private void getContainerDMContexts(Object[] elements, final DataRequestMonitor<IRunControl.IContainerDMContext[]> rm) {
        GdbLaunch launch = null;
        final HashSet<IRunControl.IContainerDMContext> contDmcs = new HashSet<IRunControl.IContainerDMContext>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.IContainerDMContext contDmc;
            Object obj = objectArray[n2];
            if (obj instanceof GdbLaunch) {
                launch = (GdbLaunch)obj;
                break;
            }
            if (obj instanceof IDMVMContext && (contDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)obj).getDMContext(), IRunControl.IContainerDMContext.class)) != null) {
                contDmcs.add(contDmc);
            }
            ++n2;
        }
        if (launch == null) {
            rm.setData((Object)contDmcs.toArray(new IRunControl.IContainerDMContext[contDmcs.size()]));
            rm.done();
        } else {
            try {
                this.fExecutor.execute((Runnable)new DsfRunnable(){

                    public void run() {
                        ICommandControlService commandControl = (ICommandControlService)GdbDisconnectCommand.this.fTracker.getService(ICommandControlService.class);
                        IProcesses procService = (IProcesses)GdbDisconnectCommand.this.fTracker.getService(IProcesses.class);
                        if (commandControl != null && procService != null) {
                            procService.getProcessesBeingDebugged((IDMContext)commandControl.getContext(), (DataRequestMonitor)new ImmediateDataRequestMonitor<IDMContext[]>(){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        rm.setStatus(this.getStatus());
                                    } else {
                                        IDMContext[] iDMContextArray = (IDMContext[])this.getData();
                                        int n = iDMContextArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IDMContext ctx = iDMContextArray[n2];
                                            IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IRunControl.IContainerDMContext.class);
                                            if (contDmc != null) {
                                                contDmcs.add(contDmc);
                                            }
                                            ++n2;
                                        }
                                        rm.setData((Object)contDmcs.toArray(new IRunControl.IContainerDMContext[contDmcs.size()]));
                                    }
                                    rm.done();
                                }
                            });
                        } else {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", "Service is not available."));
                            rm.done();
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", e.getLocalizedMessage()));
                rm.done();
            }
        }
    }

    private void canDisconnect(IRunControl.IContainerDMContext[] contDmcs, DataRequestMonitor<Boolean> rm) {
        if (contDmcs.length == 0) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        IMultiDetach multiDetach = (IMultiDetach)this.fTracker.getService(IMultiDetach.class);
        if (multiDetach != null) {
            multiDetach.canDetachDebuggerFromSomeProcesses((IDMContext[])contDmcs, rm);
        } else {
            IProcesses procService = (IProcesses)this.fTracker.getService(IProcesses.class);
            if (procService != null && contDmcs.length == 1) {
                procService.canDetachDebuggerFromProcess((IDMContext)contDmcs[0], rm);
            } else {
                rm.setData((Object)false);
                rm.done();
            }
        }
    }

    private void disconnect(IRunControl.IContainerDMContext[] contDmcs, RequestMonitor rm) {
        if (contDmcs.length == 0) {
            rm.done();
            return;
        }
        IMultiDetach multiDetach = (IMultiDetach)this.fTracker.getService(IMultiDetach.class);
        if (multiDetach != null) {
            multiDetach.detachDebuggerFromProcesses((IDMContext[])contDmcs, rm);
        } else {
            IProcesses procService = (IProcesses)this.fTracker.getService(IProcesses.class);
            if (procService != null && contDmcs.length == 1) {
                procService.detachDebuggerFromProcess((IDMContext)contDmcs[0], rm);
            } else {
                rm.done();
            }
        }
    }
}

