/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexChangeEvent;
import org.eclipse.cdt.core.index.IIndexChangeListener;
import org.eclipse.cdt.core.index.IIndexerStateEvent;
import org.eclipse.cdt.core.index.IIndexerStateListener;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.text.CCompositeReconcilingStrategy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class CReconciler
extends MonoReconciler {
    private ITextEditor fTextEditor;
    private IPartListener2 fPartListener;
    private ShellListener fActivationListener;
    private IElementChangedListener fCElementChangedListener;
    private IndexerListener fIndexerListener;
    private volatile boolean fHasCModelChanged;
    private volatile boolean fIsEditorActive = true;
    private volatile boolean fIsReconciling;
    private boolean fInitialProcessDone;
    private Job fTriggerReconcilerJob;

    public CReconciler(ITextEditor editor, CCompositeReconcilingStrategy strategy) {
        super((IReconcilingStrategy)strategy, false);
        this.fTextEditor = editor;
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fPartListener = new PartListener();
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().addPartListener(this.fPartListener);
        this.fActivationListener = new ActivationListener((Control)textViewer.getTextWidget());
        Shell shell = window.getShell();
        shell.addShellListener(this.fActivationListener);
        this.fCElementChangedListener = new ElementChangedListener();
        CoreModel.getDefault().addElementChangedListener(this.fCElementChangedListener);
        this.fIndexerListener = new IndexerListener();
        CCorePlugin.getIndexManager().addIndexerStateListener((IIndexerStateListener)this.fIndexerListener);
        CCorePlugin.getIndexManager().addIndexChangeListener((IIndexChangeListener)this.fIndexerListener);
        this.fTriggerReconcilerJob = new SingletonJob("Trigger Reconciler", () -> this.forceReconciling());
    }

    public void uninstall() {
        this.fTriggerReconcilerJob.cancel();
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().removePartListener(this.fPartListener);
        this.fPartListener = null;
        Shell shell = window.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.removeShellListener(this.fActivationListener);
        }
        this.fActivationListener = null;
        CoreModel.getDefault().removeElementChangedListener(this.fCElementChangedListener);
        this.fCElementChangedListener = null;
        CCorePlugin.getIndexManager().removeIndexerStateListener((IIndexerStateListener)this.fIndexerListener);
        CCorePlugin.getIndexManager().removeIndexChangeListener((IIndexChangeListener)this.fIndexerListener);
        this.fIndexerListener = null;
        super.uninstall();
    }

    protected void scheduleReconciling() {
        if (!this.fInitialProcessDone) {
            return;
        }
        if (this.fTriggerReconcilerJob.cancel()) {
            this.fTriggerReconcilerJob.schedule(50L);
        }
    }

    protected void forceReconciling() {
        if (!this.fInitialProcessDone) {
            return;
        }
        super.forceReconciling();
    }

    protected void aboutToBeReconciled() {
        CCompositeReconcilingStrategy strategy = (CCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.aboutToBeReconciled();
    }

    protected void initialProcess() {
        super.initialProcess();
        this.fInitialProcessDone = true;
        if (!this.fIsReconciling && this.isEditorActive() && this.hasCModelChanged()) {
            this.scheduleReconciling();
        }
    }

    protected void process(DirtyRegion dirtyRegion) {
        this.fIsReconciling = true;
        this.setCModelChanged(false);
        super.process(dirtyRegion);
        this.fIsReconciling = false;
    }

    private synchronized boolean hasCModelChanged() {
        return this.fHasCModelChanged;
    }

    private synchronized void setCModelChanged(boolean state) {
        this.fHasCModelChanged = state;
    }

    private synchronized boolean isEditorActive() {
        return this.fIsEditorActive;
    }

    private synchronized void setEditorActive(boolean active) {
        this.fIsEditorActive = active;
        if (!active) {
            this.fTriggerReconcilerJob.cancel();
        }
    }

    public boolean isRelevantElement(ICElement element) {
        if (!this.fInitialProcessDone) {
            return false;
        }
        if (element instanceof IWorkingCopy) {
            return false;
        }
        if (element instanceof ITranslationUnit) {
            IEditorInput input = this.fTextEditor.getEditorInput();
            IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
            IWorkingCopy copy = manager.getWorkingCopy(input);
            if (copy == null || copy.getOriginalElement().equals(element)) {
                return false;
            }
            return this.isRelevantProject(copy.getCProject());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRelevantProject(ICProject affectedProject) {
        if (affectedProject == null) {
            return false;
        }
        IEditorInput input = this.fTextEditor.getEditorInput();
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy copy = manager.getWorkingCopy(input);
        if (copy == null) {
            return false;
        }
        if (copy.getCProject().equals(affectedProject)) {
            return true;
        }
        IProject project = copy.getCProject().getProject();
        if (project == null) {
            return false;
        }
        try {
            IProject[] referencedProjects = project.getReferencedProjects();
            int i = 0;
            while (true) {
                if (i >= referencedProjects.length) {
                    return false;
                }
                project = referencedProjects[i];
                if (project.equals((Object)affectedProject.getProject())) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private class ActivationListener
    extends ShellAdapter {
        private Control fControl;

        public ActivationListener(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
        }

        public void shellActivated(ShellEvent e) {
            if (!this.fControl.isDisposed() && this.fControl.isVisible()) {
                if (CReconciler.this.hasCModelChanged()) {
                    CReconciler.this.scheduleReconciling();
                }
                CReconciler.this.setEditorActive(true);
            }
        }

        public void shellDeactivated(ShellEvent e) {
            if (!this.fControl.isDisposed() && this.fControl.getShell() == e.getSource()) {
                CReconciler.this.setEditorActive(false);
            }
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (event.getType() == 1 && this.isRelevantDelta(event.getDelta())) {
                if (!CReconciler.this.fIsReconciling && CReconciler.this.isEditorActive() && CReconciler.this.fInitialProcessDone) {
                    CReconciler.this.scheduleReconciling();
                } else {
                    CReconciler.this.setCModelChanged(true);
                }
            }
        }

        private boolean isRelevantDelta(ICElementDelta delta) {
            int flags = delta.getFlags();
            if ((flags & 1) != 0 && !CReconciler.this.fIsReconciling && CReconciler.this.isRelevantElement(delta.getElement())) {
                CReconciler.this.setCModelChanged(true);
            }
            if ((flags & 0xC00) != 0 && CReconciler.this.isRelevantProject(delta.getElement().getCProject())) {
                return true;
            }
            if ((flags & 8) != 0) {
                ICElementDelta[] childDeltas = delta.getChangedChildren();
                int i = 0;
                while (i < childDeltas.length) {
                    if (this.isRelevantDelta(childDeltas[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    private class IndexerListener
    implements IIndexerStateListener,
    IIndexChangeListener {
        private boolean fIndexChanged;

        private IndexerListener() {
        }

        public void indexChanged(IIndexerStateEvent event) {
            if (event.indexerIsIdle() && (this.fIndexChanged || CReconciler.this.hasCModelChanged())) {
                this.fIndexChanged = false;
                if (!CReconciler.this.fIsReconciling && CReconciler.this.isEditorActive() && CReconciler.this.fInitialProcessDone) {
                    CReconciler.this.scheduleReconciling();
                } else {
                    CReconciler.this.setCModelChanged(true);
                }
            }
        }

        public void indexChanged(IIndexChangeEvent event) {
            if (!this.fIndexChanged && CReconciler.this.isRelevantProject(event.getAffectedProject())) {
                this.fIndexChanged = true;
            }
        }
    }

    private class PartListener
    implements IPartListener2 {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == CReconciler.this.fTextEditor) {
                CReconciler.this.setEditorActive(false);
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == CReconciler.this.fTextEditor) {
                CReconciler.this.scheduleReconciling();
                CReconciler.this.setEditorActive(true);
            }
        }
    }

    static class SingletonJob
    extends Job
    implements ISchedulingRule {
        private Runnable fCode;

        SingletonJob(String name, Runnable code) {
            super(name);
            this.fCode = code;
            this.setPriority(20);
            this.setRule(this);
            this.setUser(false);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                this.fCode.run();
            }
            return Status.OK_STATUS;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

