/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.activity.ui;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.activity.ui.UserActivityListener;
import org.eclipse.mylyn.commons.activity.ui.spi.AbstractUserActivityMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.activity.ui.IUserActivityManager;
import org.eclipse.mylyn.internal.commons.activity.ui.IUserActivityManagerCallback;
import org.eclipse.mylyn.internal.commons.activity.ui.MonitorUserActivityJob;
import org.eclipse.osgi.util.NLS;

public class UserActivityManager
implements IUserActivityManager {
    private final Set<UserActivityListener> activityListeners = new CopyOnWriteArraySet<UserActivityListener>();
    private final List<AbstractUserActivityMonitor> activityMonitors;
    private final MonitorUserActivityJob monitorJob;

    public UserActivityManager(List<AbstractUserActivityMonitor> monitors) {
        this.activityMonitors = new CopyOnWriteArrayList<AbstractUserActivityMonitor>(monitors);
        this.monitorJob = this.createMonitorActivityJob();
    }

    @Override
    public void addAttentionListener(UserActivityListener listener) {
        this.activityListeners.add(listener);
    }

    public int getInactivityTimeout() {
        return this.monitorJob.getInactivityTimeout();
    }

    public long getLastInteractionTime() {
        for (final AbstractUserActivityMonitor monitor : this.activityMonitors) {
            final boolean[] success = new boolean[1];
            final long[] result = new long[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    UserActivityManager.this.disableFailedMonitor(monitor, e);
                }

                public void run() throws Exception {
                    if (monitor.isEnabled()) {
                        result[0] = monitor.getLastInteractionTime();
                        success[0] = true;
                    }
                }
            });
            if (!success[0]) continue;
            return result[0];
        }
        return -1L;
    }

    public boolean isTrackingOsTime() {
        return this.activityMonitors.size() > 1;
    }

    @Override
    public void removeAttentionListener(UserActivityListener listener) {
        this.activityListeners.remove(listener);
    }

    public void setInactivityTimeout(int inactivityTimeout) {
        this.monitorJob.setInactivityTimeout(inactivityTimeout);
    }

    public void start() {
        for (final AbstractUserActivityMonitor monitor : this.activityMonitors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    UserActivityManager.this.disableFailedMonitor(monitor, e);
                }

                public void run() throws Exception {
                    monitor.start();
                }
            });
        }
        this.monitorJob.reschedule();
    }

    public void stop() {
        this.monitorJob.cancel();
        for (final AbstractUserActivityMonitor monitor : this.activityMonitors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    UserActivityManager.this.disableFailedMonitor(monitor, e);
                }

                public void run() throws Exception {
                    monitor.stop();
                }
            });
        }
    }

    private MonitorUserActivityJob createMonitorActivityJob() {
        MonitorUserActivityJob job = new MonitorUserActivityJob(new IUserActivityManagerCallback(){

            @Override
            public void active() {
                UserActivityManager.this.fireActive();
            }

            @Override
            public void addMonitoredActivityTime(long localStartTime, long currentTime) {
                UserActivityManager.this.fireMonitoredActivityTime(localStartTime, currentTime);
            }

            @Override
            public long getLastEventTime() {
                return UserActivityManager.this.getLastInteractionTime();
            }

            @Override
            public void inactive() {
                UserActivityManager.this.fireInactive();
            }
        });
        job.setSystem(true);
        job.setPriority(10);
        return job;
    }

    private void disableFailedMonitor(AbstractUserActivityMonitor monitor, Throwable e) {
        StatusHandler.log((IStatus)new Status(2, "org.eclipes.mylyn.commons.activity.ui", NLS.bind((String)"Activity monitor ''{0}'' was disabled due to a failure", monitor.getClass()), e));
        this.activityMonitors.remove(monitor);
    }

    private void fireActive() {
        for (UserActivityListener attentionListener : this.activityListeners) {
            attentionListener.userAttentionGained();
        }
    }

    private void fireInactive() {
        for (UserActivityListener attentionListener : this.activityListeners) {
            attentionListener.userAttentionLost();
        }
    }

    private void fireMonitoredActivityTime(long start, long end) {
        for (UserActivityListener attentionListener : this.activityListeners) {
            attentionListener.userActive(start, end);
        }
    }

    void init(List<AbstractUserActivityMonitor> monitors) {
        this.activityMonitors.addAll(monitors);
    }
}

