/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.wizards;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.CatalogSet;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages;

public class ExportXMLCatalogWizard
extends BasicNewFileResourceWizard
implements IExportWizard {
    protected WizardNewFileCreationPage exportPage = null;
    protected ICatalog workingUserCatalog = null;
    protected ICatalog userCatalog = null;

    public ExportXMLCatalogWizard() {
        this.setWindowTitle(XMLWizardsMessages._UI_DIALOG_XMLCATALOG_EXPORT_TITLE);
        ImageDescriptor descriptor = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/wizban/generatexml_wiz.png");
        this.setDefaultPageImageDescriptor(descriptor);
        ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        INextCatalog[] nextCatalogs = defaultCatalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog catalog = nextCatalogs[i];
            ICatalog referencedCatalog = catalog.getReferencedCatalog();
            if (referencedCatalog != null && "user_catalog".equals(referencedCatalog.getId())) {
                this.userCatalog = referencedCatalog;
            }
            ++i;
        }
        CatalogSet tempCatalogSet = new CatalogSet();
        this.workingUserCatalog = tempCatalogSet.lookupOrCreateCatalog("working", "");
        this.workingUserCatalog.addEntriesFromCatalog(this.userCatalog);
    }

    public boolean performFinish() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        String workspacePath = workspaceRoot.getLocation().toOSString();
        String fullPath = String.valueOf(workspacePath) + this.exportPage.getContainerFullPath().toOSString();
        String requiredString = String.valueOf(fullPath) + File.separator + this.exportPage.getFileName();
        try {
            IFile file = this.exportPage.createNewFile();
            this.workingUserCatalog.setLocation(requiredString);
            this.workingUserCatalog.save();
            file.refreshLocal(0, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void addPages() {
        this.exportPage = new WizardNewFileCreationPage("XML Catalog Export", this.getSelection());
        this.exportPage.setTitle(XMLWizardsMessages._UI_DIALOG_XMLCATALOG_EXPORT_TITLE);
        this.exportPage.setDescription(XMLWizardsMessages._UI_DIALOG_XMLCATALOG_EXPORT_DESCRIPTION);
        this.exportPage.setFileExtension("xml");
        this.addPage((IWizardPage)this.exportPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(XMLWizardsMessages._UI_DIALOG_XMLCATALOG_EXPORT_TITLE);
        ImageDescriptor descriptor = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/wizban/generatexml_wiz.png");
        this.setDefaultPageImageDescriptor(descriptor);
    }
}

