/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.egit.core.synchronize.StagedChangeCache;
import org.eclipse.egit.core.synchronize.WorkingTreeChangeCache;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingTree;
import org.eclipse.egit.ui.internal.synchronize.model.HasProjects;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitModelRepository
extends GitModelObjectContainer
implements HasProjects {
    private IPath location;
    private final GitSynchronizeData gsd;
    private GitModelObject[] children;

    public GitModelRepository(GitSynchronizeData gsd) throws IOException {
        super(null);
        this.gsd = gsd;
    }

    @Override
    public GitModelObject[] getChildren() {
        List commitCache;
        ArrayList<GitModelObjectContainer> result = new ArrayList<GitModelObjectContainer>();
        Repository repo = this.gsd.getRepository();
        RevCommit srcRevCommit = this.gsd.getSrcRevCommit();
        RevCommit dstRevCommit = this.gsd.getDstRevCommit();
        TreeFilter pathFilter = this.gsd.getPathFilter();
        if (srcRevCommit != null && dstRevCommit != null) {
            try {
                commitCache = GitCommitsModelCache.build((Repository)repo, (ObjectId)srcRevCommit, (ObjectId)dstRevCommit, (TreeFilter)pathFilter);
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
                commitCache = null;
            }
        } else {
            commitCache = null;
        }
        if (commitCache != null && !commitCache.isEmpty()) {
            result.addAll(this.getListOfCommit(commitCache));
        }
        result.addAll(this.getWorkingChanges());
        this.disposeOldChildren();
        this.children = result.toArray(new GitModelObjectContainer[0]);
        return this.children;
    }

    @Override
    public String getName() {
        return this.gsd.getRepository().getWorkTree().toString();
    }

    @Override
    public IProject[] getProjects() {
        return this.gsd.getProjects().toArray(new IProject[0]);
    }

    @Override
    public int repositoryHashCode() {
        return this.hashCode();
    }

    public ObjectId getSrcRev() {
        return this.gsd.getSrcRevCommit();
    }

    @Override
    public IPath getLocation() {
        if (this.location == null) {
            this.location = new Path(this.gsd.getRepository().getWorkTree().toString());
        }
        return this.location;
    }

    @Override
    public int getKind() {
        return 3;
    }

    @Override
    public void dispose() {
        this.disposeOldChildren();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GitModelRepository) {
            File objWorkTree = ((GitModelRepository)obj).gsd.getRepository().getWorkTree();
            return objWorkTree.equals(this.gsd.getRepository().getWorkTree());
        }
        return false;
    }

    public int hashCode() {
        return this.gsd.getRepository().getWorkTree().hashCode();
    }

    public String toString() {
        return "ModelRepository[" + String.valueOf(this.gsd.getRepository().getWorkTree()) + "]";
    }

    private List<GitModelObjectContainer> getListOfCommit(List<GitCommitsModelCache.Commit> commitCache) {
        Repository repo = this.gsd.getRepository();
        Set projectsSet = this.gsd.getProjects();
        IProject[] projects = projectsSet.toArray(new IProject[0]);
        ArrayList<GitModelObjectContainer> result = new ArrayList<GitModelObjectContainer>();
        for (GitCommitsModelCache.Commit commit : commitCache) {
            result.add(new GitModelCommit(this, repo, commit, projects));
        }
        return result;
    }

    private List<GitModelObjectContainer> getWorkingChanges() {
        ArrayList<GitModelObjectContainer> result = new ArrayList<GitModelObjectContainer>();
        if (this.gsd.shouldIncludeLocal()) {
            Repository repo = this.gsd.getRepository();
            Map stagedChanges = StagedChangeCache.build((Repository)repo);
            GitModelCache gitCache = new GitModelCache(this, repo, stagedChanges);
            int gitCacheLen = gitCache.getChildren().length;
            Map workingChanges = WorkingTreeChangeCache.build((Repository)repo);
            GitModelWorkingTree gitWorkingTree = new GitModelWorkingTree(this, repo, workingChanges);
            int gitWorkingTreeLen = gitWorkingTree.getChildren().length;
            if (gitCacheLen > 0 || gitWorkingTreeLen > 0) {
                result.add(gitCache);
                result.add(gitWorkingTree);
            }
        }
        return result;
    }

    public Repository getRepository() {
        return this.gsd.getRepository();
    }

    private void disposeOldChildren() {
        if (this.children == null) {
            return;
        }
        GitModelObject[] gitModelObjectArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            GitModelObject child = gitModelObjectArray[n2];
            child.dispose();
            ++n2;
        }
    }
}

