/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IOptionCategoryApplicability;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.internal.enablement.AdjustmentContext;
import org.eclipse.cdt.managedbuilder.internal.enablement.OptionEnablementExpression;

public class BooleanExpressionApplicabilityCalculator
implements IOptionApplicability,
IOptionCategoryApplicability {
    private OptionEnablementExpression[] fExpressions;
    private Map<String, Set<String>> fRefPropsMap;

    public BooleanExpressionApplicabilityCalculator(IManagedConfigElement optionElement) {
        this(optionElement.getChildren("enablement"));
    }

    public BooleanExpressionApplicabilityCalculator(IManagedConfigElement[] enablementElements) {
        this.fExpressions = new OptionEnablementExpression[enablementElements.length];
        int i = 0;
        while (i < enablementElements.length) {
            this.fExpressions[i] = new OptionEnablementExpression(enablementElements[i]);
            ++i;
        }
    }

    @Override
    public boolean isOptionVisible(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        IResourceInfo rcInfo = BooleanExpressionApplicabilityCalculator.rcInfoFromConfiguration(configuration);
        if (rcInfo != null) {
            return this.evaluate(rcInfo, holder, option, 1);
        }
        return true;
    }

    public static IResourceInfo rcInfoFromConfiguration(IBuildObject configuration) {
        if (configuration instanceof IFolderInfo) {
            return (IFolderInfo)configuration;
        }
        if (configuration instanceof IFileInfo) {
            return (IFileInfo)configuration;
        }
        if (configuration instanceof IConfiguration) {
            return ((IConfiguration)configuration).getRootFolderInfo();
        }
        return null;
    }

    public boolean isInputTypeEnabled(ITool tool, IInputType type) {
        return this.evaluate(tool.getParentResourceInfo(), tool, null, 4);
    }

    public boolean isOutputTypeEnabled(ITool tool, IOutputType type) {
        return this.evaluate(tool.getParentResourceInfo(), tool, null, 4);
    }

    public boolean isToolUsedInCommandLine(IResourceInfo rcInfo, ITool tool) {
        return this.evaluate(rcInfo, tool, null, 4);
    }

    @Override
    public boolean isOptionEnabled(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        IResourceInfo rcInfo = BooleanExpressionApplicabilityCalculator.rcInfoFromConfiguration(configuration);
        if (rcInfo != null) {
            return this.evaluate(rcInfo, holder, option, 2);
        }
        return true;
    }

    @Override
    public boolean isOptionUsedInCommandLine(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        IResourceInfo rcInfo = BooleanExpressionApplicabilityCalculator.rcInfoFromConfiguration(configuration);
        if (rcInfo != null) {
            return this.evaluate(rcInfo, holder, option, 4);
        }
        return true;
    }

    public boolean evaluate(IResourceInfo rcInfo, IHoldsOptions holder, IOption option, int flags) {
        int i = 0;
        while (i < this.fExpressions.length) {
            if (!this.fExpressions[i].evaluate(rcInfo, holder, option, flags)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean adjustOption(IResourceInfo rcInfo, IHoldsOptions holder, IOption option, boolean extensionAdjustment) {
        boolean adjusted = false;
        AdjustmentContext context = extensionAdjustment ? null : new AdjustmentContext();
        int i = 0;
        while (i < this.fExpressions.length) {
            if (this.fExpressions[i].adjustOption(rcInfo, holder, option, context, extensionAdjustment)) {
                adjusted = true;
            }
            ++i;
        }
        if (context != null) {
            String[] unadjusted = context.getUnadjusted();
            int i2 = 0;
            while (i2 < unadjusted.length) {
                OptionEnablementExpression.adjustOption(rcInfo, holder, option, unadjusted[i2], null, extensionAdjustment);
                ++i2;
            }
        }
        return adjusted;
    }

    public boolean adjustToolChain(IFolderInfo info, IToolChain tChain, boolean extensionAdjustment) {
        boolean adjusted = false;
        AdjustmentContext context = extensionAdjustment ? null : new AdjustmentContext();
        int i = 0;
        while (i < this.fExpressions.length) {
            if (this.fExpressions[i].adjustToolChain(info, tChain, context, extensionAdjustment)) {
                adjusted = true;
            }
            ++i;
        }
        if (context != null) {
            String[] unadjusted = context.getUnadjusted();
            int i2 = 0;
            while (i2 < unadjusted.length) {
                OptionEnablementExpression.adjustToolChain(info, tChain, unadjusted[i2], null, extensionAdjustment);
                ++i2;
            }
        }
        return adjusted;
    }

    public boolean adjustTool(IResourceInfo info, ITool tool, boolean extensionAdjustment) {
        boolean adjusted = false;
        AdjustmentContext context = extensionAdjustment ? null : new AdjustmentContext();
        int i = 0;
        while (i < this.fExpressions.length) {
            if (this.fExpressions[i].adjustTool(info, tool, context, extensionAdjustment)) {
                adjusted = true;
            }
            ++i;
        }
        if (context != null) {
            String[] unadjusted = context.getUnadjusted();
            int i2 = 0;
            while (i2 < unadjusted.length) {
                OptionEnablementExpression.adjustTool(info, tool, unadjusted[i2], null, extensionAdjustment);
                ++i2;
            }
        }
        return adjusted;
    }

    public boolean adjustConfiguration(IConfiguration cfg, boolean extensionAdjustment) {
        boolean adjusted = false;
        AdjustmentContext context = extensionAdjustment ? null : new AdjustmentContext();
        int i = 0;
        while (i < this.fExpressions.length) {
            if (this.fExpressions[i].adjustConfiguration(cfg, context, extensionAdjustment)) {
                adjusted = true;
            }
            ++i;
        }
        if (context != null) {
            String[] unadjusted = context.getUnadjusted();
            int i2 = 0;
            while (i2 < unadjusted.length) {
                OptionEnablementExpression.adjustConfiguration(cfg, unadjusted[i2], null, extensionAdjustment);
                ++i2;
            }
        }
        return adjusted;
    }

    private Map<String, Set<String>> getReferencedProperties() {
        if (this.fRefPropsMap == null) {
            this.fRefPropsMap = new HashMap<String, Set<String>>();
            int i = 0;
            while (i < this.fExpressions.length) {
                this.fExpressions[i].getReferencedProperties(this.fRefPropsMap);
                ++i;
            }
        }
        return this.fRefPropsMap;
    }

    public boolean referesProperty(String id) {
        Map<String, Set<String>> map = this.getReferencedProperties();
        return map.containsKey(id);
    }

    public boolean referesPropertyValue(String propertyId, String valueId) {
        Map<String, Set<String>> map = this.getReferencedProperties();
        Set<String> set = map.get(propertyId);
        if (set != null) {
            return set.contains(valueId);
        }
        return false;
    }

    public String[] getReferencedPropertyIds() {
        Map<String, Set<String>> map = this.getReferencedProperties();
        return map.keySet().toArray(new String[map.size()]);
    }

    public String[] getReferencedValueIds(String propertyId) {
        Map<String, Set<String>> map = this.getReferencedProperties();
        Set<String> set = map.get(propertyId);
        return set.toArray(new String[set.size()]);
    }

    @Override
    public boolean isOptionCategoryVisible(IBuildObject configuration, IHoldsOptions optHolder, IOptionCategory category) {
        return this.evaluateCategory(BooleanExpressionApplicabilityCalculator.rcInfoFromConfiguration(configuration), optHolder, category);
    }

    private boolean evaluateCategory(IResourceInfo rcInfo, IHoldsOptions holder, IOptionCategory category) {
        int i = 0;
        while (i < this.fExpressions.length) {
            if (!this.fExpressions[i].evaluate(rcInfo, holder, category)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

