/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.compilationdatabase;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;

public abstract class PreferredOptions {
    protected final String qualifier;
    protected final IScopeContext[] scopes;

    public PreferredOptions(String qualifier, IScopeContext[] scopes) {
        this.qualifier = Objects.requireNonNull(qualifier);
        this.scopes = Objects.requireNonNull(scopes);
    }

    protected String stringValue(PreferenceMetadata<?> meta) {
        String actual = String.valueOf(meta.defaultValue());
        int i = this.scopes.length - 1;
        while (i >= 0) {
            IScopeContext scope = this.scopes[i];
            String previous = actual;
            actual = scope.getNode(this.qualifier).get(meta.identifer(), previous);
            --i;
        }
        return actual;
    }

    protected boolean booleanValue(PreferenceMetadata<Boolean> meta) {
        return Optional.of(meta).map(this::stringValue).map(Boolean::valueOf).orElseGet(() -> meta.defaultValue());
    }
}

