/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.internal.parser.TclParseUtils;

public class TclResolver {
    private IResolveElementParent resolver;
    private ModuleDeclaration moduleDeclaration;
    private ISourceModule sourceModule;

    public TclResolver(ISourceModule sourceModule, ModuleDeclaration moduleDeclaration, IResolveElementParent resolver) {
        this(sourceModule, moduleDeclaration);
        this.resolver = resolver;
    }

    public TclResolver(ISourceModule sourceModule, ModuleDeclaration moduleDeclaration) {
        this.sourceModule = sourceModule;
        this.moduleDeclaration = moduleDeclaration;
    }

    public IModelElement findModelElementFrom(ASTNode node) {
        List statements = this.moduleDeclaration.getStatements();
        ArrayList elements = new ArrayList();
        this.searchAddElementsTo(statements, node, (IParent)this.sourceModule, elements);
        if (elements.size() == 1) {
            return (IModelElement)elements.get(0);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void searchAddElementsTo(List statements, ASTNode node, IParent element, List selectionElements) {
        if (statements == null || element == null) {
            return;
        }
        i = statements.iterator();
        while (i.hasNext()) {
            block29: {
                block28: {
                    nde = (ASTNode)i.next();
                    if (!nde.equals(node)) break block29;
                    if (!(node instanceof MethodDeclaration) || (oName = ((MethodDeclaration)node).getName()).indexOf("::") == -1) break block28;
                    pName = oName.substring(0, oName.lastIndexOf("::"));
                    if (!(pName = pName.replaceAll("::", "\\$")).startsWith("$")) ** GOTO lbl20
                    if (pName.equals("$")) {
                        element = this.sourceModule;
                    } else {
                        try {
                            element = TclResolver.findTypeFrom(this.sourceModule.getChildren(), "", pName, '$');
                        }
                        catch (ModelException e) {
                            if (DLTKCore.DEBUG) {
                                e.printStackTrace();
                            }
                            break block28;
                        }
lbl20:
                        // 1 sources

                        pName = "$" + pName;
                        try {
                            element = TclResolver.findTypeFrom(element.getChildren(), "", pName, '$');
                            if (element == null) {
                                return;
                            }
                        }
                        catch (ModelException e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                }
                if ((nodeName = TclResolver.getNodeChildName(node)) != null) {
                    e = null;
                    if (nodeName.startsWith("::")) {
                        nodeName = nodeName.substring(2);
                        e = TclResolver.findChildrenByName(nodeName, (IParent)this.sourceModule);
                    } else {
                        e = TclResolver.findChildrenByName(nodeName, element);
                    }
                    if (e == null && this.resolver != null) {
                        e = this.resolver.findElementParent(node, nodeName, element);
                    }
                    if (e != null) {
                        toRemove = new ArrayList<IModelElement>();
                        k = 0;
                        while (k < selectionElements.size()) {
                            ke = (IModelElement)selectionElements.get(k);
                            keName = ke.getElementName();
                            if (keName.equals(nodeName)) {
                                toRemove.add(ke);
                            }
                            ++k;
                        }
                        k = 0;
                        while (k < toRemove.size()) {
                            selectionElements.remove(toRemove.get(k));
                            ++k;
                        }
                        selectionElements.add(e);
                    }
                }
                return;
            }
            if (nde.sourceStart() > node.sourceStart() || node.sourceEnd() > nde.sourceEnd()) continue;
            if (element instanceof IParent) {
                if (nde instanceof TypeDeclaration) {
                    type = (TypeDeclaration)nde;
                    typeName = TclResolver.getNodeChildName((ASTNode)type);
                    e = TclResolver.findChildrenByName(typeName, element);
                    if (e == null && type.getName().startsWith("::")) {
                        try {
                            e = (IModelElement)TclResolver.findTypeFrom(this.sourceModule.getChildren(), "", type.getName().replaceAll("::", "\\$"), '$');
                        }
                        catch (ModelException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (e instanceof IParent) {
                        stats = ((TypeDeclaration)nde).getStatements();
                        this.searchAddElementsTo(stats, node, (IParent)e, selectionElements);
                    }
                } else if (nde instanceof MethodDeclaration) {
                    this.searchInMethod(node, element, nde, selectionElements);
                } else {
                    e = element;
                    statements2 = TclResolver.findExtractBlocks(nde);
                    if (statements2.size() > 0) {
                        this.searchAddElementsTo(statements2, node, e, selectionElements);
                    }
                }
            }
            return;
        }
    }

    public static IModelElement findChildrenByName(String childName, IParent element) {
        block11: {
            block10: {
                if (element != null) break block10;
                return null;
            }
            try {
                IModelElement[] children;
                String nextName = null;
                int pos = childName.indexOf("::");
                if (pos != -1) {
                    nextName = childName.substring(pos + 2);
                    childName = childName.split("::")[0];
                }
                if ((children = element.getChildren()) != null) {
                    int i = 0;
                    while (i < children.length) {
                        String name = children[i].getElementName();
                        if (children[i] instanceof IField && name.indexOf(40) != -1) {
                            name = name.substring(0, name.indexOf(40));
                        }
                        if (name.equals(childName)) {
                            if (nextName == null) {
                                return children[i];
                            }
                            if (children[i] instanceof IParent) {
                                return TclResolver.findChildrenByName(nextName, (IParent)children[i]);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block11;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IParent findTypeFrom(IModelElement[] childs, String name, String parentName, char delimiter) {
        block6: {
            try {
                int i = 0;
                while (i < childs.length) {
                    if (childs[i] instanceof IType && (((IType)childs[i]).getFlags() & 0x1000) != 0) {
                        IType type = (IType)childs[i];
                        String qname = String.valueOf(name) + delimiter + type.getElementName();
                        if (qname.equals(parentName)) {
                            return type;
                        }
                        IParent val = TclResolver.findTypeFrom(type.getChildren(), qname, parentName, delimiter);
                        if (val != null) {
                            return val;
                        }
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getNodeChildName(ASTNode node) {
        if (node instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)node;
            String name = method.getName();
            if (name.indexOf("::") != -1) {
                return name.substring(name.lastIndexOf("::") + 2);
            }
            return name;
        }
        if (node instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)node;
            String name = type.getName();
            return name;
        }
        if (node instanceof TclStatement) {
            String[] var = TclParseUtils.returnVariable((TclStatement)node);
            if (var != null) {
                return var[0];
            }
        } else if (node instanceof FieldDeclaration) {
            return ((FieldDeclaration)node).getName();
        }
        return null;
    }

    public void searchInMethod(ASTNode node, IParent element, ASTNode nde, List selectionElements) {
        IModelElement e;
        MethodDeclaration method = (MethodDeclaration)nde;
        String methodName = method.getName();
        if (methodName.indexOf("::") != -1) {
            String pName = methodName.substring(0, methodName.lastIndexOf("::"));
            if ((pName = pName.replaceAll("::", "\\$")).equals("$")) {
                element = this.sourceModule;
            } else {
                try {
                    element = TclResolver.findTypeFrom(this.sourceModule.getChildren(), "", pName, '$');
                    if (element == null) {
                        return;
                    }
                }
                catch (ModelException e2) {
                    e2.printStackTrace();
                    return;
                }
            }
            methodName = TclResolver.getNodeChildName(nde);
        }
        if ((e = TclResolver.findChildrenByName(methodName, element)) != null && e instanceof IParent) {
            List stats = ((MethodDeclaration)nde).getStatements();
            this.searchAddElementsTo(stats, node, (IParent)e, selectionElements);
        }
    }

    public static List findExtractBlocks(ASTNode node) {
        ArrayList statements2;
        block2: {
            statements2 = new ArrayList();
            ASTVisitor visitor = new ASTVisitor(){

                public boolean visit(Expression s) throws Exception {
                    if (s instanceof Block) {
                        statements2.addAll(((Block)s).getStatements());
                    }
                    return super.visit(s);
                }
            };
            try {
                node.traverse(visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return statements2;
    }

    public static interface IResolveElementParent {
        public IModelElement findElementParent(ASTNode var1, String var2, IParent var3);
    }
}

