/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.rectpacking.RectPackingLayoutProvider;
import org.eclipse.elk.alg.rectpacking.options.OptimizationGoal;
import org.eclipse.elk.alg.rectpacking.options.RectPackingMetaDataProvider;
import org.eclipse.elk.alg.rectpacking.p1widthapproximation.WidthApproximationStrategy;
import org.eclipse.elk.alg.rectpacking.p2packing.PackingStrategy;
import org.eclipse.elk.alg.rectpacking.p3whitespaceelimination.WhiteSpaceEliminationStrategy;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.ContentAlignment;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class RectPackingOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.rectpacking";
    private static final double ASPECT_RATIO_DEFAULT = 1.3;
    public static final IProperty<Double> ASPECT_RATIO = new Property(CoreOptions.ASPECT_RATIO, (Object)1.3);
    private static final boolean NODE_SIZE_FIXED_GRAPH_SIZE_DEFAULT = false;
    public static final IProperty<Boolean> NODE_SIZE_FIXED_GRAPH_SIZE = new Property(CoreOptions.NODE_SIZE_FIXED_GRAPH_SIZE, (Object)false);
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(15.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 15.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)15.0);
    public static final IProperty<EnumSet<ContentAlignment>> CONTENT_ALIGNMENT = CoreOptions.CONTENT_ALIGNMENT;
    public static final IProperty<EnumSet<SizeConstraint>> NODE_SIZE_CONSTRAINTS = CoreOptions.NODE_SIZE_CONSTRAINTS;
    public static final IProperty<KVector> NODE_SIZE_MINIMUM = CoreOptions.NODE_SIZE_MINIMUM;
    public static final IProperty<EnumSet<SizeOptions>> NODE_SIZE_OPTIONS = CoreOptions.NODE_SIZE_OPTIONS;
    public static final IProperty<EnumSet<NodeLabelPlacement>> NODE_LABELS_PLACEMENT = CoreOptions.NODE_LABELS_PLACEMENT;
    public static final IProperty<Boolean> OMIT_NODE_MICRO_LAYOUT = CoreOptions.OMIT_NODE_MICRO_LAYOUT;
    public static final IProperty<EnumSet<PortLabelPlacement>> PORT_LABELS_PLACEMENT = CoreOptions.PORT_LABELS_PLACEMENT;
    public static final IProperty<OptimizationGoal> WIDTH_APPROXIMATION_OPTIMIZATION_GOAL = RectPackingMetaDataProvider.WIDTH_APPROXIMATION_OPTIMIZATION_GOAL;
    public static final IProperty<Boolean> WIDTH_APPROXIMATION_LAST_PLACE_SHIFT = RectPackingMetaDataProvider.WIDTH_APPROXIMATION_LAST_PLACE_SHIFT;
    public static final IProperty<Double> WIDTH_APPROXIMATION_TARGET_WIDTH = RectPackingMetaDataProvider.WIDTH_APPROXIMATION_TARGET_WIDTH;
    public static final IProperty<WidthApproximationStrategy> WIDTH_APPROXIMATION_STRATEGY = RectPackingMetaDataProvider.WIDTH_APPROXIMATION_STRATEGY;
    public static final IProperty<PackingStrategy> PACKING_STRATEGY = RectPackingMetaDataProvider.PACKING_STRATEGY;
    public static final IProperty<Boolean> PACKING_COMPACTION_ROW_HEIGHT_REEVALUATION = RectPackingMetaDataProvider.PACKING_COMPACTION_ROW_HEIGHT_REEVALUATION;
    public static final IProperty<Integer> PACKING_COMPACTION_ITERATIONS = RectPackingMetaDataProvider.PACKING_COMPACTION_ITERATIONS;
    public static final IProperty<WhiteSpaceEliminationStrategy> WHITE_SPACE_ELIMINATION_STRATEGY = RectPackingMetaDataProvider.WHITE_SPACE_ELIMINATION_STRATEGY;
    public static final IProperty<Boolean> INTERACTIVE = CoreOptions.INTERACTIVE;
    public static final IProperty<Boolean> INTERACTIVE_LAYOUT = CoreOptions.INTERACTIVE_LAYOUT;
    public static final IProperty<Integer> DESIRED_POSITION = RectPackingMetaDataProvider.DESIRED_POSITION;
    public static final IProperty<Integer> CURRENT_POSITION = RectPackingMetaDataProvider.CURRENT_POSITION;
    public static final IProperty<Boolean> IN_NEW_ROW = RectPackingMetaDataProvider.IN_NEW_ROW;
    public static final IProperty<Boolean> TRYBOX = RectPackingMetaDataProvider.TRYBOX;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK Rectangle Packing").description("Algorithm for packing of unconnected boxes, i.e. graphs without edges. The given order of the boxes is always preserved and the main reading direction of the boxes is left to right. The algorithm is divided into two phases. One phase approximates the width in which the rectangles can be placed. The next phase places the rectangles in rows using the previously calculated width as bounding width and bundles rectangles with a similar height in blocks. A compaction step reduces the size of the drawing. Finally, the rectangles are expanded to fill their bounding box and eliminate empty unused spaces.").providerFactory((IFactory)new RectpackingFactory()).melkBundleName(null).definingBundleId("org.eclipse.elk.alg.rectpacking").create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.aspectRatio", (Object)1.3);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.fixedGraphSize", (Object)false);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", (Object)PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", (Object)15.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.contentAlignment", CONTENT_ALIGNMENT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.constraints", NODE_SIZE_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.minimum", NODE_SIZE_MINIMUM.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.options", NODE_SIZE_OPTIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeLabels.placement", NODE_LABELS_PLACEMENT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.omitNodeMicroLayout", OMIT_NODE_MICRO_LAYOUT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.portLabels.placement", PORT_LABELS_PLACEMENT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.widthApproximation.optimizationGoal", WIDTH_APPROXIMATION_OPTIMIZATION_GOAL.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.widthApproximation.lastPlaceShift", WIDTH_APPROXIMATION_LAST_PLACE_SHIFT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.widthApproximation.targetWidth", WIDTH_APPROXIMATION_TARGET_WIDTH.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.widthApproximation.strategy", WIDTH_APPROXIMATION_STRATEGY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.packing.strategy", PACKING_STRATEGY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.packing.compaction.rowHeightReevaluation", PACKING_COMPACTION_ROW_HEIGHT_REEVALUATION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.packing.compaction.iterations", PACKING_COMPACTION_ITERATIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.whiteSpaceElimination.strategy", WHITE_SPACE_ELIMINATION_STRATEGY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactive", INTERACTIVE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactiveLayout", INTERACTIVE_LAYOUT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.desiredPosition", DESIRED_POSITION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.currentPosition", CURRENT_POSITION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.inNewRow", IN_NEW_ROW.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.trybox", TRYBOX.getDefault());
    }

    public static class RectpackingFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            RectPackingLayoutProvider provider = new RectPackingLayoutProvider();
            provider.initialize("");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

